/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.template;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eurocarbdb.resourcesdb.Config;
import org.eurocarbdb.resourcesdb.GlycanNamescheme;
import org.eurocarbdb.resourcesdb.ResourcesDbException;
import org.eurocarbdb.resourcesdb.atom.Atom;
import org.eurocarbdb.resourcesdb.atom.AtomConnection;
import org.eurocarbdb.resourcesdb.atom.Periodic;
import org.eurocarbdb.resourcesdb.nonmonosaccharide.AglyconAlias;
import org.eurocarbdb.resourcesdb.nonmonosaccharide.AglyconTemplate;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AglyconTemplateContainer {
    private Config config = null;
    private ArrayList<AglyconTemplate> templateList;
    private HashMap<GlycanNamescheme, ArrayList<String>> aglycTemplateListsMap;

    public AglyconTemplateContainer() {
        this.setConfig(new Config());
    }

    public AglyconTemplateContainer(Config conf) {
        this.setConfig(conf);
    }

    private void setConfig(Config theConf) {
        this.config = theConf;
    }

    public Config getConfig() {
        return this.config;
    }

    public ArrayList<AglyconTemplate> getTemplateList() throws ResourcesDbException {
        if (this.templateList == null) {
            this.templateList = this.readTemplates(this.getConfig());
        }
        return this.templateList;
    }

    public AglyconTemplate getAglyconTemplateByName(GlycanNamescheme scheme, String name) throws ResourcesDbException {
        for (AglyconTemplate aglyc : this.getTemplateList()) {
            for (AglyconAlias alias : aglyc.getAliasList()) {
                if (!alias.getNamescheme().equals((Object)scheme)) continue;
                if (scheme.isCaseSensitive() && alias.getName().equals(name)) {
                    return aglyc;
                }
                if (scheme.isCaseSensitive() || !alias.getName().equalsIgnoreCase(name)) continue;
                return aglyc;
            }
        }
        return null;
    }

    public ArrayList<String> getTemplateNameList(GlycanNamescheme namescheme) throws ResourcesDbException {
        ArrayList<String> nameschemeTemplateList;
        if (this.aglycTemplateListsMap == null) {
            this.aglycTemplateListsMap = new HashMap();
        }
        if ((nameschemeTemplateList = this.aglycTemplateListsMap.get((Object)namescheme)) == null) {
            nameschemeTemplateList = new ArrayList();
            for (AglyconTemplate aglyc : this.getTemplateList()) {
                for (AglyconAlias alias : aglyc.getAliasList()) {
                    if (!alias.getNamescheme().equals((Object)namescheme)) continue;
                    nameschemeTemplateList.add(alias.getName());
                }
            }
        }
        return nameschemeTemplateList;
    }

    public ArrayList<AglyconTemplate> readTemplates(Config conf) throws ResourcesDbException {
        Periodic.setDataIfNotSet(conf);
        return this.readTemplatesFromXmlFile(conf.getAglyconTemplatesXmlUrl());
    }

    public ArrayList<AglyconTemplate> readTemplatesFromXmlFile(URL xmlUrl) throws ResourcesDbException {
        ArrayList<AglyconTemplate> tmplList = new ArrayList<AglyconTemplate>();
        SAXBuilder parser = new SAXBuilder();
        try {
            Document doc = parser.build(xmlUrl);
            Element root = doc.getRootElement();
            List templateList = root.getChildren();
            for (Element xmlTemplate : templateList) {
                AglyconTemplate template = AglyconTemplateContainer.getTemplateFromXmlTree(xmlTemplate);
                if (template == null) continue;
                tmplList.add(template);
            }
        }
        catch (JDOMException je) {
            throw new ResourcesDbException("Exception in setting aglycon template data from xml file.", je);
        }
        catch (IOException ie) {
            throw new ResourcesDbException("Exception in setting aglycon template data from xml file.", ie);
        }
        return tmplList;
    }

    private static AglyconTemplate getTemplateFromXmlTree(Element xmlTemplate) throws ResourcesDbException {
        if (xmlTemplate.getName().equalsIgnoreCase("aglycon")) {
            AglyconTemplate aglycTemplate = new AglyconTemplate();
            List propList = xmlTemplate.getChildren();
            for (Element property : propList) {
                String propertyName = property.getName().toLowerCase();
                String propertyValue = property.getValue();
                if (propertyValue == null) {
                    propertyValue = "";
                }
                if (propertyName.equals("name")) {
                    aglycTemplate.setName(propertyValue);
                    aglycTemplate.setPrimaryAlias(GlycanNamescheme.GLYCOCT, propertyValue);
                    continue;
                }
                if (propertyName.equals("valence") && !propertyValue.equals("")) {
                    aglycTemplate.setValence(Integer.parseInt(propertyValue));
                    continue;
                }
                if (propertyName.equals("default_linking_position1") && !propertyValue.equals("")) {
                    aglycTemplate.setDefaultLinkingPosition1(Integer.parseInt(propertyValue));
                    continue;
                }
                if (propertyName.equals("default_linking_position2") && !propertyValue.equals("")) {
                    aglycTemplate.setDefaultLinkingPosition2(Integer.parseInt(propertyValue));
                    continue;
                }
                if (propertyName.equals("formula")) {
                    aglycTemplate.setFormula(propertyValue);
                    continue;
                }
                if (propertyName.equals("class")) {
                    aglycTemplate.setAglyconClass(propertyValue);
                    continue;
                }
                if (propertyName.equals("atoms")) {
                    List atomList = property.getChildren();
                    for (Element atomtag : atomList) {
                        Atom a = Atom.parseXmlAtomTag(atomtag);
                        aglycTemplate.addAtom(a);
                    }
                    continue;
                }
                if (propertyName.equals("atom_connections")) {
                    List connectionList = property.getChildren();
                    for (Element atomtag : connectionList) {
                        AtomConnection.parseXmlAtomConnectionTag(atomtag, aglycTemplate);
                    }
                    continue;
                }
                if (propertyName.equals("valid_linking_positions")) {
                    List vlpList = property.getChildren();
                    for (Element vlpTag : vlpList) {
                        int id = Integer.parseInt(vlpTag.getAttributeValue("id"));
                        int atomId = Integer.parseInt(vlpTag.getAttributeValue("atom_id"));
                        Atom linkAtom = aglycTemplate.getAtomById(atomId);
                        if (linkAtom == null) {
                            throw new ResourcesDbException("Cannot get atom id " + atomId + " for aglycon template " + aglycTemplate.getName());
                        }
                        Atom replAtom = null;
                        String replAtomStr = vlpTag.getAttributeValue("replaced_atom_id");
                        if (replAtomStr != null && replAtomStr.length() > 0 && (replAtom = aglycTemplate.getAtomById(Integer.parseInt(replAtomStr))) == null) {
                            throw new ResourcesDbException("Cannot get atom id " + replAtomStr + " for aglycon template " + aglycTemplate.getName());
                        }
                        Double bo = null;
                        String boStr = vlpTag.getAttributeValue("bond_order");
                        if (boStr != null && boStr.length() > 0) {
                            bo = Double.parseDouble(boStr);
                        }
                        aglycTemplate.addValidLinkingPosition(id, linkAtom, replAtom, bo, null);
                    }
                    continue;
                }
                if (!propertyName.equals("synonyms")) continue;
                List synonymList = property.getChildren();
                for (Element synonym : synonymList) {
                    AglyconAlias alias = AglyconTemplateContainer.parseXmlAliasTag(synonym);
                    if (alias == null) continue;
                    aglycTemplate.addAlias(alias);
                    if (!alias.isPrimaryName()) continue;
                    aglycTemplate.setPrimaryAlias(alias.getNamescheme(), alias.getName());
                }
            }
            return aglycTemplate;
        }
        return null;
    }

    private static AglyconAlias parseXmlAliasTag(Element synonym) {
        AglyconAlias alias = null;
        if (synonym.getName().equalsIgnoreCase("primary_alias") || synonym.getName().equalsIgnoreCase("secondary_alias")) {
            alias = new AglyconAlias();
            GlycanNamescheme scheme = GlycanNamescheme.forName(synonym.getAttribute("namescheme").getValue());
            alias.setNamescheme(scheme);
            alias.setName(synonym.getAttributeValue("name"));
            if (synonym.getName().equalsIgnoreCase("primary_alias")) {
                alias.setIsPrimary(true);
            } else {
                alias.setIsPrimary(false);
            }
        }
        return alias;
    }
}

