/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.part;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.io.ProjectDetailsHandler;
import org.grits.toolbox.core.datamodel.property.project.ProjectCollaborator;
import org.grits.toolbox.core.datamodel.property.project.ProjectDetails;
import org.grits.toolbox.core.datamodel.property.project.ProjectEvent;
import org.grits.toolbox.core.datamodel.property.project.ProjectTasklist;
import org.grits.toolbox.core.img.ImageShare;
import org.grits.toolbox.core.part.provider.CollaboratorsLabelProvider;
import org.grits.toolbox.core.part.provider.EventsLabelProvider;
import org.grits.toolbox.core.part.provider.TasklistsLabelProvider;
import org.grits.toolbox.core.preference.project.CollaboratorTableColumn;
import org.grits.toolbox.core.preference.project.TasklistTableColumn;
import org.grits.toolbox.core.preference.share.MultiChoicePreference;
import org.grits.toolbox.core.preference.share.ProjectPreferenceStore;
import org.grits.toolbox.core.utilShare.ListenerFactory;
import org.grits.toolbox.core.utilShare.SelectKeywordsDialog;
import org.grits.toolbox.core.utilShare.provider.GenericListContentProvider;
import org.grits.toolbox.core.utilShare.sort.TableColumnComparatorListener;
import org.grits.toolbox.core.utilShare.sort.TableViewerComparator;
import org.grits.toolbox.core.utils.MaintainTableColumnRatioListener;

public class ProjectEntryPart {
    private static final Logger logger = Logger.getLogger(ProjectEntryPart.class);
    public static final String PART_ID = "org.grits.toolbox.core.partdescriptor.entry.project";
    public static final String EVENT_TOPIC_FIELD_SELECTION = "grits_project_some_field_selected";
    private static final String DATE_FORMAT = "yyyy-MM-dd hh:mm:ss";
    public static final String ADD_NEW_TO_PREFERENCE = "Add New ...";
    private static final int TABLE_MIN_WIDTH = 600;
    private Entry projectEntry = null;
    private ProjectDetails projectDetails = null;
    protected Font boldFont = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
    private Color backgroundColor = null;
    @Inject
    private MDirtyable dirtyable;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private ESelectionService selectionService = null;
    @Inject
    private EHandlerService eHandlerService;
    @Inject
    private ECommandService eCommandService;
    private Text creationTimeText = null;
    private Text modificationTimeText = null;
    private Text descriptionText = null;
    private TableViewer collaboratorsTableViewer = null;
    private TableViewer tasklistsTableViewer = null;
    private TableViewer eventsTableViewer = null;
    private ControlListener[] controlListeners = null;
    private Text keywordText = null;
    private Button selectKeywordsButton = null;
    public ProjectCollaborator lastCollaboratorSelection = null;
    public ProjectTasklist lastProjectTaskSelection = null;
    public ProjectEvent lastProjectEventSelection = null;
    EPartService partService;

    @Inject
    public ProjectEntryPart(@Named(value="org.eclipse.ui.selection") Entry entry, @Named(value="e4ActivePart") MPart part, EPartService partService, EModelService modelService, MApplication application) {
        this.partService = partService;
        if (entry != null && "org.grits.toolbox.core.part.projectexplorer".equals(part.getElementId())) {
            this.projectEntry = entry;
            try {
                this.projectDetails = ProjectDetailsHandler.getProjectDetails(this.projectEntry);
                String projectPerspectiveId = "org.grits.toolbox.core.perspective.entry.project";
                MPerspective projectPerspective = (MPerspective)modelService.find(projectPerspectiveId, (MUIElement)application);
                if (projectPerspective == null) {
                    projectPerspectiveId = "org.grits.toolbox.core.perspective.entry.project.<Project Perspective>";
                    projectPerspective = (MPerspective)modelService.find(projectPerspectiveId, (MUIElement)application);
                }
                partService.switchPerspective(projectPerspective);
            }
            catch (IOException e) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error Creating Project Details", (String)e.getMessage());
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @PostConstruct
    public void postConstruct(Composite parent) {
        logger.debug((Object)"Creating Project Editor Part");
        if (this.projectDetails != null) {
            parent.setLayout((Layout)new FillLayout());
            ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 2816);
            GridData layoutData = new GridData();
            scrolledComposite.setLayoutData((Object)layoutData);
            this.backgroundColor = Display.getCurrent().getSystemColor(25);
            scrolledComposite.setBackground(this.backgroundColor);
            scrolledComposite.setBackgroundMode(2);
            scrolledComposite.setLayout((Layout)new FillLayout());
            Composite generalPartComposite = new Composite((Composite)scrolledComposite, 4);
            GridLayout generalPartLayout = new GridLayout();
            generalPartLayout.marginWidth = 10;
            generalPartLayout.marginHeight = 10;
            generalPartLayout.horizontalSpacing = 30;
            generalPartLayout.verticalSpacing = 10;
            generalPartLayout.numColumns = 2;
            generalPartComposite.setLayout((Layout)generalPartLayout);
            generalPartComposite.setLayoutData((Object)new GridData());
            Label creationTimeLabel = new Label(generalPartComposite, 0);
            creationTimeLabel.setFont(this.boldFont);
            creationTimeLabel.setLayoutData((Object)new GridData());
            creationTimeLabel.setText("Created");
            this.creationTimeText = new Text(generalPartComposite, 8);
            this.creationTimeText.setLayoutData((Object)new GridData(4, 1, true, false));
            SimpleDateFormat sf = new SimpleDateFormat(DATE_FORMAT);
            this.creationTimeText.setText(sf.format(this.projectEntry.getCreationDate()));
            Label modificationTimeLabel = new Label(generalPartComposite, 0);
            modificationTimeLabel.setFont(this.boldFont);
            modificationTimeLabel.setLayoutData((Object)new GridData());
            modificationTimeLabel.setText("Modified");
            this.modificationTimeText = new Text(generalPartComposite, 8);
            if (this.projectDetails.getModificationTime() != null) {
                this.modificationTimeText.setText(sf.format(this.projectDetails.getModificationTime()));
            }
            this.modificationTimeText.setLayoutData((Object)new GridData(4, 1, true, false));
            Label descriptionLabel = new Label(generalPartComposite, 0);
            descriptionLabel.setFont(this.boldFont);
            descriptionLabel.setText("Description");
            GridData labelLayoutData = new GridData(2);
            labelLayoutData.verticalSpan = 8;
            labelLayoutData.horizontalSpan = 1;
            descriptionLabel.setLayoutData((Object)labelLayoutData);
            this.descriptionText = new Text(generalPartComposite, 2624);
            GridData gridData = new GridData(1808);
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            gridData.verticalSpan = 8;
            gridData.widthHint = 400;
            gridData.heightHint = 80;
            this.descriptionText.setLayoutData((Object)gridData);
            this.controlListeners = new ControlListener[3];
            this.createCollaboratorsTable(generalPartComposite);
            this.createTasklistsTable(generalPartComposite);
            this.createEventsTable(generalPartComposite);
            this.createKeywordsPart(generalPartComposite);
            this.initializeValues();
            this.descriptionText.addTraverseListener(ListenerFactory.getTabTraverseListener());
            this.descriptionText.addKeyListener(ListenerFactory.getCTRLAListener());
            this.descriptionText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String newDescription = ProjectEntryPart.this.descriptionText.getText().trim();
                    if (!newDescription.equals(ProjectEntryPart.this.projectDetails.getDescription())) {
                        ProjectEntryPart.this.projectDetails.setDescription(newDescription);
                        ProjectEntryPart.this.dirtyable.setDirty(true);
                    }
                }
            });
            scrolledComposite.setContent((Control)generalPartComposite);
            scrolledComposite.setMinSize(generalPartComposite.computeSize(-1, -1));
            scrolledComposite.setExpandVertical(true);
            scrolledComposite.setExpandHorizontal(true);
        }
        logger.debug((Object)"Finished creating Project Editor");
    }

    private void initializeValues() {
        if (this.projectDetails.getDescription() != null) {
            this.descriptionText.setText(this.projectDetails.getDescription());
        }
        this.collaboratorsTableViewer.setInput(this.projectDetails.getCollaborators());
        this.tasklistsTableViewer.setInput(this.projectDetails.getTasklists());
        this.eventsTableViewer.setInput(this.projectDetails.getEvents());
        this.keywordText.setText(this.getCSKeywords(this.projectDetails.getKeywords()));
    }

    private void createCollaboratorsTable(Composite parent) {
        logger.debug((Object)"Creating Collaborator's part");
        this.collaboratorsTableViewer = this.createTable(parent, "Collaborators", 2);
        Section section = (Section)this.collaboratorsTableViewer.getTable().getParent().getParent();
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)section);
        section.setTextClient((Control)toolbar);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("org.grits.toolbox.core.commandparameter.addtotable.type", ProjectCollaborator.class.getName());
        this.addToolItem(toolbar, ImageShare.ADD_ICON.createImage(), "Add a new Collaborator", "org.grits.toolbox.core.command.entry.project.table.add", parameters);
        this.addToolItem(toolbar, ImageShare.DELETE_ICON.createImage(), "Remove the selected Collaborator", "org.grits.toolbox.core.command.entry.project.table.delete", null);
        this.addToolItem(toolbar, ImageShare.VIEW_ICON.createImage(), "View the selected Collaborator", "org.grits.toolbox.core.command.entry.project.table.view", null);
        toolbar.setData((Object)this.collaboratorsTableViewer);
        HashSet<Integer> visibleColumns = new HashSet<Integer>();
        visibleColumns.add(0);
        visibleColumns.addAll(ProjectPreferenceStore.getMultiChoiceInteger(ProjectPreferenceStore.IntegerPreference.COLLABORATORS_TABLE).getSelectedValues());
        int[] columnRatios = this.getColumnRatios(this.collaboratorsTableViewer, CollaboratorTableColumn.COLUMNS, visibleColumns);
        this.collaboratorsTableViewer.getTable().setHeaderVisible(true);
        this.collaboratorsTableViewer.getTable().setLinesVisible(true);
        this.controlListeners[0] = new MaintainTableColumnRatioListener(600, columnRatios);
        this.collaboratorsTableViewer.getTable().addControlListener(this.controlListeners[0]);
        this.collaboratorsTableViewer.setLabelProvider((IBaseLabelProvider)new CollaboratorsLabelProvider(this.collaboratorsTableViewer));
        this.collaboratorsTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProjectEntryPart.this.lastCollaboratorSelection = (ProjectCollaborator)((StructuredSelection)event.getSelection()).getFirstElement();
                ProjectEntryPart.this.partService.bringToTop(ProjectEntryPart.this.partService.findPart("org.grits.toolbox.core.part.project.collaborator"));
                ProjectEntryPart.this.eventBroker.post(ProjectEntryPart.EVENT_TOPIC_FIELD_SELECTION, (Object)ProjectEntryPart.this.lastCollaboratorSelection);
            }
        });
        this.collaboratorsTableViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                if (event.keyCode == 127) {
                    event.data = ProjectEntryPart.this.collaboratorsTableViewer;
                    ProjectEntryPart.this.executeCommand(event, "org.grits.toolbox.core.command.entry.project.table.delete", null);
                }
            }
        });
        this.collaboratorsTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ProjectEntryPart.this.executeCommand(event, "org.grits.toolbox.core.command.entry.project.table.view", null);
            }
        });
        this.addViewerComparator(this.collaboratorsTableViewer);
        logger.debug((Object)"Creating Collaborator's part");
    }

    private void createTasklistsTable(Composite parent) {
        logger.debug((Object)"Creating Tasklist part");
        this.tasklistsTableViewer = this.createTable(parent, "Tasklist", 3);
        Section section = (Section)this.tasklistsTableViewer.getTable().getParent().getParent();
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)section);
        section.setTextClient((Control)toolbar);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("org.grits.toolbox.core.commandparameter.addtotable.type", ProjectTasklist.class.getName());
        this.addToolItem(toolbar, ImageShare.ADD_ICON.createImage(), "Add a new Task", "org.grits.toolbox.core.command.entry.project.table.add", parameters);
        this.addToolItem(toolbar, ImageShare.DELETE_ICON.createImage(), "Remove the selected Task", "org.grits.toolbox.core.command.entry.project.table.delete", null);
        this.addToolItem(toolbar, ImageShare.VIEW_ICON.createImage(), "View the selected Task", "org.grits.toolbox.core.command.entry.project.table.view", null);
        toolbar.setData((Object)this.tasklistsTableViewer);
        HashSet<Integer> visibleColumns = new HashSet<Integer>();
        visibleColumns.add(0);
        visibleColumns.addAll(ProjectPreferenceStore.getMultiChoiceInteger(ProjectPreferenceStore.IntegerPreference.TASKLIST_TABLE).getSelectedValues());
        int[] columnRatios = this.getColumnRatios(this.tasklistsTableViewer, TasklistTableColumn.COLUMNS, visibleColumns);
        this.tasklistsTableViewer.getTable().setHeaderVisible(true);
        this.tasklistsTableViewer.getTable().setLinesVisible(true);
        this.controlListeners[1] = new MaintainTableColumnRatioListener(600, columnRatios);
        this.tasklistsTableViewer.getTable().addControlListener(this.controlListeners[1]);
        this.tasklistsTableViewer.setLabelProvider((IBaseLabelProvider)new TasklistsLabelProvider(this.tasklistsTableViewer));
        this.tasklistsTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProjectEntryPart.this.lastProjectTaskSelection = (ProjectTasklist)((StructuredSelection)event.getSelection()).getFirstElement();
                ProjectEntryPart.this.partService.bringToTop(ProjectEntryPart.this.partService.findPart("org.grits.toolbox.core.part.project.task"));
                ProjectEntryPart.this.eventBroker.post(ProjectEntryPart.EVENT_TOPIC_FIELD_SELECTION, (Object)ProjectEntryPart.this.lastProjectTaskSelection);
            }
        });
        this.tasklistsTableViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                if (event.keyCode == 127) {
                    event.data = ProjectEntryPart.this.tasklistsTableViewer;
                    ProjectEntryPart.this.executeCommand(event, "org.grits.toolbox.core.command.entry.project.table.delete", null);
                }
            }
        });
        this.tasklistsTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ProjectEntryPart.this.executeCommand(event, "org.grits.toolbox.core.command.entry.project.table.view", null);
            }
        });
        this.addViewerComparator(this.tasklistsTableViewer);
        logger.debug((Object)"Creating Tasklist part");
    }

    private void createEventsTable(Composite parent) {
        logger.debug((Object)"Creating Event part");
        this.eventsTableViewer = this.createTable(parent, "Events", 2);
        TableViewerColumn nameColumnViewer = new TableViewerColumn(this.eventsTableViewer, 16384);
        nameColumnViewer.getColumn().setText("Action");
        TableViewerColumn dateColumnViewer = new TableViewerColumn(this.eventsTableViewer, 16384);
        dateColumnViewer.getColumn().setText("Date");
        TableViewerColumn descriptionColumnViewer = new TableViewerColumn(this.eventsTableViewer, 16384);
        descriptionColumnViewer.getColumn().setText("Description");
        Section section = (Section)this.eventsTableViewer.getTable().getParent().getParent();
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)section);
        section.setTextClient((Control)toolbar);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("org.grits.toolbox.core.commandparameter.addtotable.type", ProjectEvent.class.getName());
        this.addToolItem(toolbar, ImageShare.ADD_ICON.createImage(), "Add a new Event", "org.grits.toolbox.core.command.entry.project.table.add", parameters);
        this.addToolItem(toolbar, ImageShare.DELETE_ICON.createImage(), "Remove the selected Event", "org.grits.toolbox.core.command.entry.project.table.delete", null);
        this.addToolItem(toolbar, ImageShare.VIEW_ICON.createImage(), "View the selected Event", "org.grits.toolbox.core.command.entry.project.table.view", null);
        toolbar.setData((Object)this.eventsTableViewer);
        this.controlListeners[2] = new MaintainTableColumnRatioListener(600, 1, 1, 4);
        this.eventsTableViewer.getTable().addControlListener(this.controlListeners[2]);
        this.eventsTableViewer.getTable().setHeaderVisible(true);
        this.eventsTableViewer.getTable().setLinesVisible(true);
        this.eventsTableViewer.setContentProvider((IContentProvider)new GenericListContentProvider());
        this.eventsTableViewer.setLabelProvider((IBaseLabelProvider)new EventsLabelProvider());
        this.eventsTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProjectEntryPart.this.lastProjectEventSelection = (ProjectEvent)((StructuredSelection)event.getSelection()).getFirstElement();
                ProjectEntryPart.this.partService.bringToTop(ProjectEntryPart.this.partService.findPart("org.grits.toolbox.core.part.project.event"));
                ProjectEntryPart.this.eventBroker.post(ProjectEntryPart.EVENT_TOPIC_FIELD_SELECTION, (Object)ProjectEntryPart.this.lastProjectEventSelection);
            }
        });
        this.eventsTableViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                if (event.keyCode == 127) {
                    event.data = ProjectEntryPart.this.eventsTableViewer;
                    ProjectEntryPart.this.executeCommand(event, "org.grits.toolbox.core.command.entry.project.table.delete", null);
                }
            }
        });
        this.eventsTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ProjectEntryPart.this.executeCommand(event, "org.grits.toolbox.core.command.entry.project.table.view", null);
            }
        });
        this.addViewerComparator(this.eventsTableViewer);
        logger.debug((Object)"Creating Event part");
    }

    @Optional
    @Inject
    void refreshCollaboratorsTable(@UIEventTopic(value="EventTopic_CollabPart_Modified") ProjectCollaborator collaborator) {
        if (collaborator != null && ((List)this.collaboratorsTableViewer.getInput()).contains(collaborator)) {
            this.collaboratorsTableViewer.refresh((Object)collaborator);
            this.dirtyable.setDirty(true);
        }
    }

    @Optional
    @Inject
    void refreshTaskTable(@UIEventTopic(value="EventTopic_EventPart_Modified") ProjectTasklist projectTasklist) {
        if (projectTasklist != null && ((List)this.tasklistsTableViewer.getInput()).contains(projectTasklist)) {
            this.tasklistsTableViewer.refresh((Object)projectTasklist);
            this.dirtyable.setDirty(true);
        }
    }

    @Optional
    @Inject
    void refreshEventsTable(@UIEventTopic(value="EventTopic_EventPart_Modified") ProjectEvent projectEvent) {
        if (projectEvent != null && ((List)this.eventsTableViewer.getInput()).contains(projectEvent)) {
            this.eventsTableViewer.refresh((Object)projectEvent);
            this.dirtyable.setDirty(true);
        }
    }

    @Optional
    @Inject
    void resetTableColumn(@UIEventTopic(value="preference_value_changed_in_grits") String preferenceName) {
        int[] columnRatios;
        HashSet<Integer> visibleColumns;
        if (ProjectPreferenceStore.IntegerPreference.COLLABORATORS_TABLE.getPreferenceName().equals(preferenceName)) {
            logger.debug((Object)"Resetting columns for collaborators table");
            this.collaboratorsTableViewer.getTable().removeControlListener(this.controlListeners[0]);
            this.removeColumns(this.collaboratorsTableViewer);
            visibleColumns = new HashSet<Integer>();
            visibleColumns.addAll(ProjectPreferenceStore.getMultiChoiceInteger(ProjectPreferenceStore.IntegerPreference.COLLABORATORS_TABLE).getSelectedValues());
            columnRatios = this.getColumnRatios(this.collaboratorsTableViewer, CollaboratorTableColumn.COLUMNS, visibleColumns);
            this.controlListeners[0] = new MaintainTableColumnRatioListener(600, columnRatios);
            this.collaboratorsTableViewer.getTable().addControlListener(this.controlListeners[0]);
            this.collaboratorsTableViewer.setLabelProvider((IBaseLabelProvider)new CollaboratorsLabelProvider(this.collaboratorsTableViewer));
            this.resizeTable(this.collaboratorsTableViewer, this.controlListeners[0]);
            this.addViewerComparator(this.collaboratorsTableViewer);
        }
        if (ProjectPreferenceStore.IntegerPreference.TASKLIST_TABLE.getPreferenceName().equals(preferenceName)) {
            logger.debug((Object)"Resetting columns for tasklist table");
            this.tasklistsTableViewer.getTable().removeControlListener(this.controlListeners[1]);
            this.removeColumns(this.tasklistsTableViewer);
            visibleColumns = new HashSet();
            visibleColumns.addAll(ProjectPreferenceStore.getMultiChoiceInteger(ProjectPreferenceStore.IntegerPreference.TASKLIST_TABLE).getSelectedValues());
            columnRatios = this.getColumnRatios(this.tasklistsTableViewer, TasklistTableColumn.COLUMNS, visibleColumns);
            this.controlListeners[1] = new MaintainTableColumnRatioListener(600, columnRatios);
            this.tasklistsTableViewer.getTable().addControlListener(this.controlListeners[1]);
            this.tasklistsTableViewer.setLabelProvider((IBaseLabelProvider)new TasklistsLabelProvider(this.tasklistsTableViewer));
            this.resizeTable(this.tasklistsTableViewer, this.controlListeners[1]);
            this.addViewerComparator(this.tasklistsTableViewer);
        }
    }

    private void removeColumns(TableViewer tableViewer) {
        TableColumn[] columns = tableViewer.getTable().getColumns();
        int i = 0;
        while (i < columns.length) {
            columns[i].dispose();
            ++i;
        }
    }

    private void resizeTable(TableViewer tableViewer, ControlListener controlListener) {
        Event event = new Event();
        event.widget = tableViewer.getTable();
        controlListener.controlResized(new ControlEvent(event));
    }

    private void executeCommand(Object eventObject, String commandId, Map<String, Object> commandParameters) {
        this.selectionService.setSelection(eventObject);
        this.eHandlerService.executeHandler(this.eCommandService.createCommand(commandId, commandParameters));
    }

    private ToolItem addToolItem(ToolBar toolbar, Image icon, String toolTipText, final String commandId, final Map<String, Object> commandParameters) {
        ToolItem toolItem = new ToolItem(toolbar, 8);
        toolItem.setImage(icon);
        toolItem.setToolTipText(toolTipText);
        toolItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProjectEntryPart.this.executeCommand(e, commandId, commandParameters);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ProjectEntryPart.this.executeCommand(e, commandId, commandParameters);
            }
        });
        return toolItem;
    }

    private void createKeywordsPart(Composite parent) {
        logger.debug((Object)"Creating Keywords Part");
        Label placeholderLabel = new Label(parent, 0);
        GridData placeHolderData = new GridData(2);
        placeHolderData.horizontalSpan = 2;
        placeHolderData.verticalSpan = 2;
        placeholderLabel.setLayoutData((Object)placeHolderData);
        Label kewywordLabel = new Label(parent, 4);
        kewywordLabel.setFont(this.boldFont);
        kewywordLabel.setBackground(this.backgroundColor);
        kewywordLabel.setText("Keywords");
        GridData keywordLabelLayoutData = new GridData(2);
        keywordLabelLayoutData.verticalSpan = 6;
        kewywordLabel.setLayoutData((Object)keywordLabelLayoutData);
        this.keywordText = new Text(parent, 2120);
        GridData keywordTextData = new GridData(1808);
        keywordTextData.horizontalAlignment = 4;
        keywordTextData.grabExcessHorizontalSpace = true;
        keywordTextData.verticalSpan = 6;
        keywordTextData.widthHint = 400;
        keywordTextData.heightHint = 70;
        this.keywordText.setLayoutData((Object)keywordTextData);
        this.keywordText.addTraverseListener(ListenerFactory.getTabTraverseListener());
        this.keywordText.addKeyListener(ListenerFactory.getCTRLAListener());
        this.keywordText.setEnabled(false);
        this.selectKeywordsButton = new Button(parent, 0);
        this.selectKeywordsButton.setText("Modify Keywords");
        this.selectKeywordsButton.addSelectionListener(new SelectionListener(){
            private SelectKeywordsDialog selectKeywordsDialog;

            public void widgetSelected(SelectionEvent e) {
                HashSet<String> allKeywords = new HashSet<String>();
                MultiChoicePreference keywordPreference = ProjectPreferenceStore.getMultiChoicePreference(ProjectPreferenceStore.ParameterizedPreference.KEYWORD);
                allKeywords.addAll(keywordPreference.getSelectedValues());
                allKeywords.addAll(keywordPreference.getOtherValues());
                this.selectKeywordsDialog = new SelectKeywordsDialog(Display.getCurrent().getActiveShell(), allKeywords);
                this.selectKeywordsDialog.setSelectedKeyWords(ProjectEntryPart.this.projectDetails.getKeywords());
                if (this.selectKeywordsDialog.open() == 0) {
                    HashSet<String> keywords = new HashSet<String>();
                    keywords.addAll(this.selectKeywordsDialog.getSelectedKeywords());
                    ProjectEntryPart.this.keywordText.setText(ProjectEntryPart.this.getCSKeywords(keywords));
                    ProjectEntryPart.this.projectDetails.setKeywords(keywords);
                    ProjectEntryPart.this.dirtyable.setDirty(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (((Button)e.getSource()).getSelection() && this.selectKeywordsDialog.open() == 0) {
                    Set<String> keywords = ProjectEntryPart.this.projectDetails.getKeywords();
                    keywords.addAll(this.selectKeywordsDialog.getSelectedKeywords());
                    ProjectEntryPart.this.keywordText.setText(ProjectEntryPart.this.getCSKeywords(keywords));
                    ProjectEntryPart.this.projectDetails.setKeywords(keywords);
                    ProjectEntryPart.this.dirtyable.setDirty(true);
                }
            }
        });
        GridData selectKeywordsButtonData = new GridData();
        selectKeywordsButtonData.horizontalAlignment = 0x1000000;
        selectKeywordsButtonData.horizontalSpan = 2;
        selectKeywordsButtonData.widthHint = 200;
        selectKeywordsButtonData.verticalSpan = 2;
        this.selectKeywordsButton.setLayoutData((Object)selectKeywordsButtonData);
        logger.debug((Object)"Creating Keywords Part");
    }

    private String getCSKeywords(Set<String> keywordSet) {
        String keywords = "";
        for (String keyword : keywordSet) {
            keywords = String.valueOf(keywords) + keyword + ", ";
        }
        if (!keywords.isEmpty()) {
            keywords = keywords.substring(0, keywords.length() - ", ".length());
        }
        return keywords;
    }

    private int[] getColumnRatios(TableViewer tableViewer, String[] allColumns, Set<Integer> visibleColumns) {
        int i = 0;
        TableViewerColumn columnViewer = null;
        int columnNumber = 0;
        int[] columnRatios = new int[visibleColumns.size()];
        while (i < allColumns.length) {
            if (visibleColumns.contains(i)) {
                columnViewer = new TableViewerColumn(tableViewer, 16384, columnNumber);
                columnViewer.getColumn().setText(allColumns[i]);
                columnRatios[columnNumber] = 2;
                ++columnNumber;
            }
            ++i;
        }
        columnRatios[0] = 3;
        return columnRatios;
    }

    private void addViewerComparator(TableViewer tableViewer) {
        tableViewer.setComparator((ViewerComparator)new TableViewerComparator());
        int totalColumns = tableViewer.getTable().getColumns().length;
        int i = 0;
        while (i < totalColumns) {
            tableViewer.getTable().getColumn(i).addSelectionListener((SelectionListener)new TableColumnComparatorListener(tableViewer));
            ++i;
        }
    }

    private TableViewer createTable(Composite parent, String tableTitle, int verticalSpan) {
        Composite sectionParentComposite = new Composite(parent, 4);
        sectionParentComposite.setLayout((Layout)new TableWrapLayout());
        Section section = new Section(sectionParentComposite, 324);
        section.setText(tableTitle);
        Color sectionColor = new Color((Device)Display.getCurrent(), 20, 199, 255);
        section.setTitleBarBackground(sectionColor);
        section.setBackground(this.backgroundColor);
        section.setTitleBarForeground(Display.getCurrent().getSystemColor(10));
        section.setLayout((Layout)new TableWrapLayout());
        Composite infoComposite = new Composite((Composite)section, 0);
        infoComposite.setLayout((Layout)new GridLayout());
        infoComposite.setBackground(this.backgroundColor);
        infoComposite.setBackgroundMode(2);
        TableViewer tableViewer = new TableViewer(infoComposite, 68356);
        tableViewer.setContentProvider((IContentProvider)new GenericListContentProvider());
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 1;
        gridData.heightHint = verticalSpan * 50;
        gridData.widthHint = 600;
        tableViewer.getTable().setLayoutData((Object)gridData);
        TableWrapData sectionLayoutData = new TableWrapData(128, 64);
        sectionLayoutData.grabHorizontal = true;
        sectionLayoutData.grabVertical = true;
        section.setLayoutData((Object)sectionLayoutData);
        section.setClient((Control)infoComposite);
        GridData compositeLayoutData = new GridData(1808);
        compositeLayoutData.verticalSpan = 1;
        compositeLayoutData.horizontalSpan = 2;
        sectionParentComposite.setLayoutData((Object)compositeLayoutData);
        return tableViewer;
    }

    @PreDestroy
    public void preDestroy() {
    }

    @Focus
    public void onFocus() {
        this.descriptionText.setFocus();
    }

    @Persist
    public void save() {
        logger.info((Object)"saving project entry");
        boolean changesSaved = false;
        try {
            Date date = new Date();
            SimpleDateFormat sf = new SimpleDateFormat(DATE_FORMAT);
            this.projectDetails.setModificationTime(date);
            changesSaved = ProjectDetailsHandler.writeProjectDetails(this.projectDetails);
            this.modificationTimeText.setText(sf.format(date));
        }
        catch (IOException iOException) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error saving details.", (String)"The project information could not be saved to the file.");
        }
        this.dirtyable.setDirty(!changesSaved);
    }

    public ProjectCollaborator getLastCollaboratorSelection() {
        return this.lastCollaboratorSelection;
    }

    public ProjectTasklist getLastProjectTaskSelection() {
        return this.lastProjectTaskSelection;
    }

    public ProjectEvent getLastProjectEventSelection() {
        return this.lastProjectEventSelection;
    }
}

