/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.preference;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceManager;
import org.grits.toolbox.core.preference.GritsPreferenceNode;

@Singleton
public class PreferenceManagerLoader {
    private static final Logger logger = Logger.getLogger(PreferenceManagerLoader.class);
    public static final String GRITS_PREFERENCE_MANAGER = "Grits_Preference_Manager";
    private static final String PREFERENCE_EXT_POINT_ID = "org.grits.toolbox.core.preferencePages";
    private static final String ELMT_PAGE = "page";
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_CATEGORY = "category";
    @Inject
    private IExtensionRegistry extensionRegistry;
    private PreferenceManager gritsPreferenceManager = null;

    public PreferenceManager loadPreferenceManager() {
        if (this.gritsPreferenceManager != null) {
            return this.gritsPreferenceManager;
        }
        this.gritsPreferenceManager = new PreferenceManager();
        String bundleId = null;
        String pageId = null;
        String name = null;
        String className = null;
        GritsPreferenceNode preferenceNode = null;
        HashMap<String, GritsPreferenceNode> idToPreferenceNodeMap = new HashMap<String, GritsPreferenceNode>();
        HashMap<String, ArrayList<GritsPreferenceNode>> categoryChildrenMap = new HashMap<String, ArrayList<GritsPreferenceNode>>();
        IConfigurationElement[] iConfigurationElementArray = this.extensionRegistry.getConfigurationElementsFor(PREFERENCE_EXT_POINT_ID);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            bundleId = configElement.getNamespaceIdentifier();
            if (!ELMT_PAGE.equals(configElement.getName())) {
                logger.error((Object)("Missing \"page\" element for preference. found: \"" + configElement.getName() + "\" in plugin " + bundleId));
            } else {
                pageId = configElement.getAttribute(ATTR_ID);
                name = configElement.getAttribute(ATTR_NAME);
                if (pageId == null || pageId.trim().isEmpty()) {
                    logger.error((Object)("Missing mandatory attribute \"id\" for preference in plugin " + bundleId));
                } else if (name == null || name.trim().isEmpty()) {
                    logger.error((Object)("Missing mandatory attribute \"name\" for preference in plugin " + bundleId));
                } else {
                    className = configElement.getAttribute(ATTR_CLASS);
                    if (className != null) {
                        try {
                            name = name.trim();
                            pageId = pageId.trim();
                            logger.info((Object)("Adding preference node for : " + pageId));
                            preferenceNode = new GritsPreferenceNode(bundleId, pageId, name, null, className);
                            idToPreferenceNodeMap.put(pageId, preferenceNode);
                            String category = configElement.getAttribute(ATTR_CATEGORY);
                            if (category == null || category.isEmpty()) {
                                this.gritsPreferenceManager.addToRoot((IPreferenceNode)preferenceNode);
                            } else {
                                ArrayList<GritsPreferenceNode> children = (ArrayList<GritsPreferenceNode>)categoryChildrenMap.get(category);
                                if (children == null) {
                                    children = new ArrayList<GritsPreferenceNode>();
                                    categoryChildrenMap.put(category, children);
                                }
                                children.add(preferenceNode);
                            }
                        }
                        catch (Exception e) {
                            logger.fatal((Object)("Unexpected error while adding preference node for : " + pageId));
                            logger.fatal((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
            ++n2;
        }
        GritsPreferenceNode categoryPreferenceNode = null;
        for (String categoryId : categoryChildrenMap.keySet()) {
            categoryPreferenceNode = (GritsPreferenceNode)((Object)idToPreferenceNodeMap.get(categoryId));
            if (categoryPreferenceNode == null) {
                logger.error((Object)("No such category found : " + categoryId));
                continue;
            }
            for (GritsPreferenceNode child : (List)categoryChildrenMap.get(categoryId)) {
                categoryPreferenceNode.add((IPreferenceNode)child);
            }
        }
        return this.gritsPreferenceManager;
    }
}

