/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.preference.project;

import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.datamodel.property.project.ProjectCollaborator;
import org.grits.toolbox.core.preference.share.ProjectPreferenceStore;
import org.grits.toolbox.core.wizard.addcollaborator.CollaboratorEditListener;
import org.grits.toolbox.core.wizard.addcollaborator.ProjectCollaboratorUI;

public class CollaboratorInfoDialog
extends TitleAreaDialog
implements CollaboratorEditListener {
    private static final Logger logger = Logger.getLogger(CollaboratorInfoDialog.class);
    private ProjectCollaborator collaborator = null;
    private ProjectCollaboratorUI projectCollaboratorUI = new ProjectCollaboratorUI(this);

    public CollaboratorInfoDialog(Shell parentShell) {
        super(parentShell);
    }

    public void setCollaborator(ProjectCollaborator collaborator) {
        this.collaborator = collaborator;
    }

    public ProjectCollaborator getCollaborator() {
        return this.collaborator;
    }

    public void create() {
        super.create();
        super.setTitle("Project Collaborator");
        if (this.collaborator == null) {
            super.setMessage("Create a new Collaborator");
            this.collaborator = new ProjectCollaborator();
            this.collaborator.setName("Collaborator");
            this.collaborator.setPosition(ProjectPreferenceStore.getSingleChoicePreference(ProjectPreferenceStore.Preference.POSITION).getDefaultValue());
            this.collaborator.setCountry(ProjectPreferenceStore.StringPreference.COUNTRY.getValue());
            this.collaborator.setFundingAgency(ProjectPreferenceStore.getSingleChoicePreference(ProjectPreferenceStore.Preference.FUNDING).getDefaultValue());
        } else {
            super.setMessage(this.collaborator.getName());
        }
        this.projectCollaboratorUI.setCollaborator(this.collaborator);
    }

    protected Control createDialogArea(Composite parent) {
        logger.debug((Object)"START : Creating Colloborator UI");
        this.projectCollaboratorUI.createPartControl(parent);
        logger.debug((Object)"END   : Creating Colloborator UI");
        return parent;
    }

    @Override
    public void valueEdited() {
    }
}

