/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.preference.share;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.log4j.Logger;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.core.preference.PreferenceHandler;
import org.grits.toolbox.core.preference.project.UtilityPreferenceValue;
import org.grits.toolbox.core.preference.share.IGritsPreferenceStore;
import org.grits.toolbox.core.preference.share.PreferenceEntity;
import org.grits.toolbox.core.preference.share.ProjectPreferenceStore;
import org.jdom.Element;

public class MultiChoicePreference<T> {
    protected static final Logger logger = Logger.getLogger(MultiChoicePreference.class);
    protected IGritsPreferenceStore gritsPreferenceStore = null;
    protected ProjectPreferenceStore.ParameterizedPreference parameterizedPreference = null;
    protected String preferenceName = null;
    protected List<T> selectedValues = new ArrayList<T>();
    protected List<T> otherValues = new ArrayList<T>();
    protected boolean dirty = false;

    protected MultiChoicePreference(IGritsPreferenceStore gritsPreferenceStore, String preferenceName) {
        logger.info((Object)("Creating multi selection type preference : " + preferenceName));
        this.gritsPreferenceStore = gritsPreferenceStore;
        this.preferenceName = preferenceName;
    }

    MultiChoicePreference(IGritsPreferenceStore gritsPreferenceStore, ProjectPreferenceStore.ParameterizedPreference parameterizedPreference) {
        this(gritsPreferenceStore, parameterizedPreference.getPreferenceName());
        this.parameterizedPreference = parameterizedPreference;
        this.initializeValues();
        if (this.dirty) {
            this.savePreference();
        }
    }

    protected void initializeValues() {
        Map<String, Boolean> valueSelectionMap = this.getValueSelectionMap(this.preferenceName);
        if (this.parameterizedPreference.previousNames.length % 2 == 0) {
            int index = 0;
            while (valueSelectionMap == null && index < this.parameterizedPreference.previousNames.length - 1) {
                valueSelectionMap = this.getPreversioningValues(this.parameterizedPreference.previousNames[index++], this.parameterizedPreference.previousNames[index++]);
            }
        }
        if (valueSelectionMap == null) {
            valueSelectionMap = this.loadDefaultValues();
            this.dirty = true;
        }
        this.loadFromMap(this.parameterizedPreference.unmarshallerClass, valueSelectionMap);
    }

    private void loadFromMap(Class<T> clazz, Map<String, Boolean> valueSelectionMap) {
        for (String value : valueSelectionMap.keySet()) {
            T object = this.parseObject(clazz, value);
            if (object == null) continue;
            if (valueSelectionMap.get(value).booleanValue()) {
                this.selectedValues.add(object);
                continue;
            }
            this.otherValues.add(object);
        }
    }

    public List<T> getSelectedValues() {
        return this.selectedValues;
    }

    public void setSelectedValues(List<T> selectedValues) {
        this.selectedValues = selectedValues;
    }

    public boolean addSelectedValue(T selectedValue) {
        return this.selectedValues.add(selectedValue);
    }

    public List<T> getOtherValues() {
        return this.otherValues;
    }

    public void setOtherValues(List<T> otherValues) {
        this.otherValues = otherValues;
    }

    public boolean addOtherValue(T otherValue) {
        return this.otherValues.add(otherValue);
    }

    public boolean savePreference() {
        PreferenceEntity preferenceEntity = new PreferenceEntity(this.preferenceName);
        HashSet<String> ov = new HashSet<String>();
        String stringValue = null;
        for (T t : this.otherValues) {
            stringValue = this.getStringForObject(t);
            if (stringValue == null) continue;
            ov.add(stringValue);
        }
        HashSet<String> sv = new HashSet<String>();
        for (T t : this.selectedValues) {
            stringValue = this.getStringForObject(t);
            if (stringValue == null) continue;
            sv.add(stringValue);
        }
        preferenceEntity.setValue(UtilityPreferenceValue.getPreferenceValueString(sv, ov));
        if (this.gritsPreferenceStore != null) {
            return this.gritsPreferenceStore.savePreference(preferenceEntity);
        }
        return false;
    }

    protected Map<String, Boolean> loadDefaultValues() {
        return this.parameterizedPreference.getDefaultFileName() == null ? new HashMap() : PreferenceHandler.getPreferenceValues(this.parameterizedPreference.getDefaultFileName());
    }

    public Map<T, Boolean> getDefaultValuesObjectMap() {
        Map<String, Boolean> defaultStringValueMap = this.loadDefaultValues();
        HashMap<Object, Boolean> defaultObjectMap = new HashMap<Object, Boolean>();
        Object object = null;
        for (String stringObject : defaultStringValueMap.keySet()) {
            object = this.parseObject(this.parameterizedPreference.unmarshallerClass, stringObject);
            if (object == null) continue;
            defaultObjectMap.put(object, defaultStringValueMap.get(stringObject));
        }
        return defaultObjectMap;
    }

    protected Map<String, Boolean> getValueSelectionMap(String preferenceName) {
        Map<String, Boolean> valueSelectionMap = null;
        try {
            PreferenceEntity preferenceEntity;
            if (this.gritsPreferenceStore != null && (preferenceEntity = this.gritsPreferenceStore.getPreferenceEntity(preferenceName)) != null) {
                logger.info((Object)("Preference found : " + preferenceName));
                valueSelectionMap = UtilityPreferenceValue.getPreferenceValuesWithSelection(preferenceEntity);
            }
        }
        catch (UnsupportedVersionException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return valueSelectionMap;
    }

    protected Map<String, Boolean> getPreversioningValues(String defaultName, String otherName) {
        HashMap<String, Boolean> valueSelectionMap = null;
        if (this.gritsPreferenceStore == null) {
            return null;
        }
        Element preferenceElement = this.gritsPreferenceStore.getPreferenceElement(defaultName);
        if (preferenceElement != null) {
            logger.info((Object)("Preference found : " + defaultName));
            valueSelectionMap = new HashMap<String, Boolean>();
            String selectedValue = UtilityPreferenceValue.getPreversioningSelected(preferenceElement);
            if (selectedValue != null && selectedValue.trim().isEmpty()) {
                valueSelectionMap.put(selectedValue.trim(), true);
            }
            this.gritsPreferenceStore.removePreference(defaultName);
            this.dirty = true;
        }
        if ((preferenceElement = this.gritsPreferenceStore.getPreferenceElement(otherName)) != null) {
            logger.info((Object)("Preference found : " + defaultName));
            valueSelectionMap = valueSelectionMap == null ? new HashMap<String, Boolean>() : valueSelectionMap;
            for (String v : UtilityPreferenceValue.getPreversioningValues(preferenceElement)) {
                valueSelectionMap.put(v, false);
            }
            this.gritsPreferenceStore.removePreference(otherName);
            this.dirty = true;
        }
        return valueSelectionMap;
    }

    protected T parseObject(Class<T> unmarshallerClass, String stringValue) {
        if (String.class.equals(unmarshallerClass)) {
            return (T)stringValue;
        }
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{unmarshallerClass});
            return (T)context.createUnmarshaller().unmarshal((Reader)new StringReader(stringValue));
        }
        catch (JAXBException e) {
            logger.error((Object)("The object could not be read from xml.\n" + e.getMessage()), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("The object could not be read from xml.\n" + e.getMessage()), (Throwable)e);
        }
        return null;
    }

    protected String getStringForObject(T object) {
        if (object instanceof String) {
            return (String)object;
        }
        String xmlString = null;
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.marshal(object, (OutputStream)os);
            xmlString = os.toString();
        }
        catch (JAXBException e) {
            logger.error((Object)("The object could not be serialized as xml." + e.getMessage()), (Throwable)e);
        }
        catch (Exception e) {
            logger.fatal((Object)("The object could not be serialized as xml." + e.getMessage()), (Throwable)e);
        }
        return xmlString;
    }
}

