/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.projectexplorer.dialog;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.io.ProjectDetailsHandler;
import org.grits.toolbox.core.datamodel.property.ProjectProperty;
import org.grits.toolbox.core.datamodel.property.project.ProjectCollaborator;
import org.grits.toolbox.core.datamodel.property.project.ProjectContribution;
import org.grits.toolbox.core.datamodel.property.project.ProjectContributor;
import org.grits.toolbox.core.datamodel.property.project.ProjectDetails;
import org.grits.toolbox.core.datamodel.property.project.ProjectTasklist;
import org.grits.toolbox.core.preference.share.ProjectPreferenceStore;
import org.grits.toolbox.core.utilShare.CheckboxTableViewer;
import org.grits.toolbox.core.utilShare.provider.EntryLabelProvider;
import org.grits.toolbox.core.utilShare.provider.GenericListContentProvider;

public class ExportTaskDialog
extends TitleAreaDialog {
    protected static final String DEFAULT_FILENAME = "GRITS_TaskExport.xlsx";
    private CheckboxTableViewer projectTableViewer = null;
    private CheckboxTableViewer statusTableViewer = null;
    private List<ProjectContributor> selectedPeople = new ArrayList<ProjectContributor>();
    private String savingLocation = null;
    private Text locationText;

    public ExportTaskDialog(Shell parentShell) {
        super(parentShell);
    }

    public void create() {
        super.create();
        this.setTitle("Export People");
        this.setMessage("Export People to an Excel Sheet");
        this.getShell().setText("Export");
        this.getButton(0).setText("Export");
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(comp, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginBottom = 20;
        layout.verticalSpacing = 10;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText("Projects");
        GridData labelGridData = new GridData(128);
        labelGridData.horizontalSpan = 1;
        label.setLayoutData((Object)labelGridData);
        Table projectsTable = new Table(container, 68356);
        GridData tableLayouData = new GridData(1808);
        tableLayouData.horizontalSpan = 3;
        tableLayouData.heightHint = 100;
        projectsTable.setLayoutData((Object)tableLayouData);
        this.projectTableViewer = new CheckboxTableViewer(projectsTable, "Select");
        TableViewerColumn tableColumn2 = new TableViewerColumn((TableViewer)this.projectTableViewer, 4, 1);
        tableColumn2.getColumn().setText("Projects");
        tableColumn2.getColumn().setWidth(300);
        this.projectTableViewer.getTable().setHeaderVisible(true);
        this.projectTableViewer.getTable().setLinesVisible(true);
        this.projectTableViewer.setContentProvider((IContentProvider)new GenericListContentProvider());
        this.projectTableViewer.setLabelProvider((IBaseLabelProvider)new EntryLabelProvider());
        Entry workspaceEntry = PropertyHandler.getDataModel().getRoot();
        ArrayList<Entry> projectEntries = new ArrayList<Entry>();
        this.projectTableViewer.setInput(projectEntries);
        for (Entry child : workspaceEntry.getChildren()) {
            if (!(child.getProperty() instanceof ProjectProperty)) continue;
            projectEntries.add(child);
            this.projectTableViewer.add(child);
            this.projectTableViewer.setChecked(child, ((ProjectProperty)child.getProperty()).getOpen());
        }
        label = new Label(container, 0);
        label.setText("Status");
        labelGridData = new GridData(128);
        labelGridData.horizontalSpan = 1;
        label.setLayoutData((Object)labelGridData);
        Table statusTable = new Table(container, 68356);
        GridData statusLayouData = new GridData(1808);
        statusLayouData.horizontalSpan = 3;
        statusLayouData.heightHint = 100;
        statusTable.setLayoutData((Object)statusLayouData);
        this.statusTableViewer = new CheckboxTableViewer(statusTable, "Select");
        TableViewerColumn statusColumn2 = new TableViewerColumn((TableViewer)this.statusTableViewer, 4, 1);
        statusColumn2.getColumn().setText("Status");
        statusColumn2.getColumn().setWidth(300);
        this.statusTableViewer.getTable().setHeaderVisible(true);
        this.statusTableViewer.getTable().setLinesVisible(true);
        this.statusTableViewer.setContentProvider((IContentProvider)new GenericListContentProvider());
        this.statusTableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getColumnText(Object element, int columnIndex) {
                if (columnIndex > 0 && element instanceof String) {
                    return (String)element;
                }
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }
        });
        ArrayList<String> status = new ArrayList<String>();
        status.addAll(ProjectPreferenceStore.getSingleChoicePreference(ProjectPreferenceStore.Preference.STATUS).getAllValues());
        Collections.sort(status, String.CASE_INSENSITIVE_ORDER);
        this.statusTableViewer.setInput(status);
        Object[] allStatus = new String[status.size()];
        int i = 0;
        for (String keyword : status) {
            allStatus[i++] = keyword;
        }
        this.statusTableViewer.setCheckedElements(allStatus);
        this.statusTableViewer.refresh();
        this.locationText = new Text(container, 2048);
        GridData textData = new GridData(4, 1, true, false);
        textData.horizontalSpan = 2;
        this.locationText.setLayoutData((Object)textData);
        this.locationText.setText(String.valueOf(System.getProperty("user.home")) + File.separator + DEFAULT_FILENAME);
        Button browseButton = new Button(container, 8);
        browseButton.setText("Browse Location");
        GridData browseButtonGridData = new GridData(128);
        browseButtonGridData.horizontalSpan = 1;
        browseButton.setLayoutData((Object)browseButtonGridData);
        browseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(ExportTaskDialog.this.getShell(), 8192);
                fileDialog.setText("Select File");
                fileDialog.setFilterExtensions(new String[]{"*.xls"});
                fileDialog.setFilterNames(new String[]{"Excel (*.xls)"});
                fileDialog.setFileName(ExportTaskDialog.DEFAULT_FILENAME);
                fileDialog.setOverwrite(true);
                String selected = fileDialog.open();
                if (selected != null) {
                    ExportTaskDialog.this.locationText.setText(selected);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        browseButton.setFocus();
        container.setLayoutData((Object)new GridData(1808));
        comp.setLayoutData((Object)new GridData(1808));
        return comp;
    }

    public List<ProjectContributor> getSelectedPeople() {
        return this.selectedPeople;
    }

    protected void okPressed() {
        if (this.projectTableViewer.getCheckedElements().length > 0 && this.statusTableViewer.getCheckedElements().length > 0) {
            if (this.locationText.getText().isEmpty()) {
                this.setErrorMessage("Choose a location to Save");
            } else {
                this.savingLocation = this.locationText.getText();
                this.setErrorMessage("");
            }
            this.selectedPeople = new ArrayList<ProjectContributor>();
            ArrayList<String> alreadyAdded = new ArrayList<String>();
            String workspaceLocationFolder = PropertyHandler.getVariable("workspace_location");
            workspaceLocationFolder = workspaceLocationFolder.substring(0, workspaceLocationFolder.length());
            ProjectContributor contributor = null;
            ProjectContribution projectContribution = null;
            String collaborator = null;
            ArrayList<String> checkedStatus = new ArrayList<String>();
            Object[] objectArray = this.statusTableViewer.getCheckedElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object status = objectArray[n2];
                checkedStatus.add((String)status);
                ++n2;
            }
            objectArray = this.projectTableViewer.getCheckedElements();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                Object pj = objectArray[n2];
                if (pj instanceof Entry) {
                    Entry projectEntry = (Entry)pj;
                    try {
                        ProjectDetails projectDetails = ProjectDetailsHandler.getProjectDetails(projectEntry);
                        if (projectDetails != null) {
                            collaborator = "";
                            for (ProjectCollaborator coll : projectDetails.getCollaborators()) {
                                collaborator = coll.getName();
                                if (coll.getAddress() != null) {
                                    collaborator = String.valueOf(collaborator) + "\n" + coll.getAddress();
                                }
                                collaborator = String.valueOf(collaborator) + "\n\n";
                            }
                            if (!collaborator.isEmpty()) {
                                collaborator = collaborator.substring(0, collaborator.length() - 2);
                            }
                            for (ProjectTasklist taskList : projectDetails.getTasklists()) {
                                if (!checkedStatus.contains(taskList.getStatus())) continue;
                                if (alreadyAdded.contains(taskList.getPerson())) {
                                    for (ProjectContributor contbtr : this.selectedPeople) {
                                        if (!contbtr.getName().equals(taskList.getPerson())) continue;
                                        contributor = contbtr;
                                    }
                                } else {
                                    contributor = new ProjectContributor();
                                    contributor.setName(taskList.getPerson());
                                    this.selectedPeople.add(contributor);
                                    alreadyAdded.add(taskList.getPerson());
                                }
                                projectContribution = new ProjectContribution();
                                projectContribution.setProjectName(projectEntry.getDisplayName());
                                projectContribution.setTask(taskList.getTask());
                                projectContribution.setStatus(taskList.getStatus());
                                projectContribution.setProjectCollaborator(collaborator);
                                projectContribution.setDueDate(taskList.getDueDate());
                                projectContribution.setNumberOfTasks(taskList.getNumberOfTasks());
                                contributor.addContribution(projectContribution);
                            }
                        }
                    }
                    catch (IOException iOException) {}
                }
                ++n2;
            }
            super.okPressed();
        }
    }

    public String getSavingLocation() {
        return this.savingLocation;
    }
}

