/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.wizard.addcollaborator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.grits.toolbox.core.datamodel.property.project.ProjectCollaborator;
import org.grits.toolbox.core.part.toolitem.SaveCollaborator;
import org.grits.toolbox.core.wizard.addcollaborator.pages.AddNewCollaborator;
import org.grits.toolbox.core.wizard.addcollaborator.pages.SelectCollaborator;

public class AddCollaboratorWizard
extends Wizard {
    private List<ProjectCollaborator> collaborators = null;
    private SelectCollaborator pageOne = new SelectCollaborator();
    private AddNewCollaborator pageTwo = new AddNewCollaborator();

    public void addPages() {
        this.addPage((IWizardPage)this.pageOne);
        this.addPage((IWizardPage)this.pageTwo);
        super.addPages();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        return page == this.pageOne ? this.pageTwo : null;
    }

    public boolean performFinish() {
        this.collaborators = new ArrayList<ProjectCollaborator>();
        if (this.getContainer().getCurrentPage() == this.pageOne && this.pageOne.selectFromButton.getSelection()) {
            this.collaborators.addAll(this.pageOne.getSelectedCollaborators());
        } else if (this.getContainer().getCurrentPage() == this.pageTwo && this.pageTwo.isPageComplete()) {
            ProjectCollaborator newCollaborator = this.pageTwo.getCollaborator();
            this.collaborators.add(newCollaborator);
            if (this.pageTwo.addToPreference.getSelection()) {
                this.addCollaboratorToPreference(newCollaborator);
            }
        }
        return true;
    }

    private void addCollaboratorToPreference(ProjectCollaborator newCollaborator) {
        SaveCollaborator.saveToPreference(newCollaborator, true);
    }

    public boolean canFinish() {
        if (this.getContainer().getCurrentPage() == this.pageOne) {
            return this.pageOne.selectFromButton.getSelection() && !this.pageOne.getSelectedCollaborators().isEmpty();
        }
        if (this.getContainer().getCurrentPage() == this.pageTwo) {
            return this.pageTwo != null && this.pageTwo.isPageComplete();
        }
        return false;
    }

    public List<ProjectCollaborator> getCollaborators() {
        return this.collaborators;
    }
}

