/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.wizard.taskexport.pages;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SelectColumnPage
extends WizardPage {
    private static Set<String> DEFAULT_COLUMNS = new HashSet<String>();
    public static final String PROJECT = "Project";
    public static final String NAME_ADDRESS = "Name/Address";
    public static final String GROUP_PI = "Group/P.I.";
    public static final String ROLE = "Role";
    public static final String TASK = "Task";
    public static final String STATUS = "Status";
    public static final String NUMBER_OF_SAMPLES = "#Samples";
    public static final String COMPLETION_DATE = "Completion Date";
    public static final String[] COLUMNS = new String[]{"Project", "Name/Address", "Group/P.I.", "Role", "Task", "Status", "#Samples", "Completion Date"};
    private static Logger logger = Logger.getLogger(SelectColumnPage.class);
    private static String title = "Preference";
    public Button[] columnsToExport = null;

    public SelectColumnPage() {
        super(title);
        this.setTitle(title);
        this.setMessage("Select Columns to export");
    }

    public void createControl(Composite parent) {
        logger.debug((Object)"START : Creating Columns part");
        DEFAULT_COLUMNS = new HashSet<String>(Arrays.asList(PROJECT));
        Composite container = new Composite(parent, 4);
        GridLayout layout = new GridLayout();
        layout.marginRight = 8;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 10;
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText("Columns");
        GridData selectExistingData = new GridData(32);
        selectExistingData.horizontalSpan = 1;
        selectExistingData.verticalSpan = 1;
        label.setLayoutData((Object)selectExistingData);
        this.createColumnVisibilityPart(container);
        this.setControl((Control)container);
        logger.debug((Object)"START : Creating Columns part");
    }

    private void createColumnVisibilityPart(Composite container) {
        Composite composite = new Composite(container, 2052);
        GridLayout layout = new GridLayout();
        layout.marginRight = 8;
        layout.marginTop = 10;
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 10;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)layout);
        String[] buttonNames = COLUMNS;
        this.columnsToExport = new Button[buttonNames.length];
        int i = 0;
        while (i < buttonNames.length) {
            this.columnsToExport[i] = this.createCheckbox(composite, buttonNames[i]);
            if (DEFAULT_COLUMNS.contains(buttonNames[i])) {
                // empty if block
            }
            this.columnsToExport[i].setSelection(true);
            ++i;
        }
        GridData compositeLayoutData = new GridData(1808);
        compositeLayoutData.grabExcessHorizontalSpace = true;
        compositeLayoutData.horizontalSpan = 1;
        compositeLayoutData.verticalSpan = 1;
        composite.setLayoutData((Object)compositeLayoutData);
    }

    private Button createCheckbox(Composite composite, String label) {
        Button checkButton = new Button(composite, 32);
        checkButton.setText(label);
        GridData createNewData = new GridData(768);
        createNewData.horizontalSpan = 1;
        createNewData.verticalSpan = 1;
        checkButton.setLayoutData((Object)createNewData);
        return checkButton;
    }
}

