/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.grits.toolbox.entry.sample.model.EntityWithPosition;
import org.grits.toolbox.entry.sample.model.MeasurementUnit;
import org.grits.toolbox.entry.sample.model.Namespace;
import org.grits.toolbox.entry.sample.model.ValueTriple;

@XmlRootElement(name="descriptor")
@XmlType(propOrder={"label", "uri", "description", "categories", "namespaces", "valueTriple", "selectedMeasurementUnit", "validUnits"})
public class Descriptor
implements EntityWithPosition {
    private String uri = null;
    private String label = null;
    private String description = null;
    private Integer maxOccurrence = null;
    private String defaultMeasurementUnit = null;
    private String selectedMeasurementUnit = null;
    private ValueTriple valueTriple = new ValueTriple();
    private List<String> categories = new ArrayList<String>();
    private List<Namespace> namespaces = new ArrayList<Namespace>();
    private List<MeasurementUnit> validUnits = new ArrayList<MeasurementUnit>();
    private HashMap<String, String> unitUriToLabelMap = new HashMap();
    private HashMap<String, String> unitLabelToUriMap = new HashMap();
    private Integer position = null;

    @XmlAttribute(name="uri", required=true)
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    @XmlAttribute(name="label", required=true)
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @XmlElement(name="description", required=false)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @XmlAttribute(name="maxOccurrence", required=true)
    public Integer getMaxOccurrence() {
        return this.maxOccurrence;
    }

    public void setMaxOccurrence(Integer maxOccurrence) {
        this.maxOccurrence = maxOccurrence;
    }

    @XmlElement(name="namespace")
    public List<Namespace> getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(List<Namespace> namespaces) {
        this.namespaces = namespaces;
    }

    public void addNamespace(Namespace namespace) {
        this.namespaces.add(namespace);
    }

    @XmlElement(name="valueTriple", required=true)
    public ValueTriple getValueTriple() {
        return this.valueTriple;
    }

    public void setValueTriple(ValueTriple valueTriple) {
        this.valueTriple = valueTriple;
    }

    @Override
    @XmlAttribute
    public Integer getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Integer position) {
        this.position = position;
    }

    @XmlTransient
    public String getValue() {
        return this.valueTriple.getValue();
    }

    public void setValue(String value) {
        if (this.namespaces.iterator().hasNext()) {
            Namespace ns = this.namespaces.iterator().next();
            this.valueTriple.setNamespaceURI(ns.getUri());
            this.valueTriple.setValue(value);
        }
    }

    @XmlAttribute(name="selectedUnit", required=false)
    public String getSelectedMeasurementUnit() {
        if (this.selectedMeasurementUnit == null && this.defaultMeasurementUnit != null) {
            this.selectedMeasurementUnit = this.defaultMeasurementUnit;
        }
        return this.selectedMeasurementUnit;
    }

    public void setSelectedMeasurementUnit(String selectedMeasurementUnit) {
        this.selectedMeasurementUnit = selectedMeasurementUnit;
    }

    @XmlAttribute(name="defaultUnit", required=false)
    public String getDefaultMeasurementUnit() {
        return this.defaultMeasurementUnit;
    }

    public void setDefaultMeasurementUnit(String defaultMeasurementUnit) {
        this.defaultMeasurementUnit = defaultMeasurementUnit;
    }

    @XmlElement(name="category")
    public List<String> getCategories() {
        return this.categories;
    }

    public void setCategories(List<String> categories) {
        this.categories = categories;
    }

    public void addCategory(String category) {
        this.categories.add(category);
    }

    @XmlElement(name="unit")
    public List<MeasurementUnit> getValidUnits() {
        return this.validUnits;
    }

    public void setValidUnits(List<MeasurementUnit> validUnits) {
        this.validUnits = validUnits;
        this.fillUnitLabelMaps();
    }

    private void fillUnitLabelMaps() {
        this.fillUnitLabelToUriMap();
        this.fillUnitUriToLabelMap();
    }

    public void addValidUnit(MeasurementUnit validUnit) {
        this.validUnits.add(validUnit);
        if (!this.unitLabelToUriMap.containsKey(validUnit.getLabel())) {
            this.unitLabelToUriMap.put(validUnit.getLabel(), validUnit.getUri());
        }
        if (!this.unitUriToLabelMap.containsKey(validUnit.getUri())) {
            this.unitUriToLabelMap.put(validUnit.getUri(), validUnit.getLabel());
        }
    }

    public String getUnitLabelFromUri(String uri) {
        if (this.validUnits.size() != this.unitUriToLabelMap.keySet().size()) {
            this.fillUnitUriToLabelMap();
        }
        return this.unitUriToLabelMap.get(uri);
    }

    private void fillUnitUriToLabelMap() {
        this.unitUriToLabelMap = new HashMap();
        for (MeasurementUnit munit : this.validUnits) {
            this.unitUriToLabelMap.put(munit.getUri(), munit.getLabel());
        }
    }

    public String getUnitUriFromLabel(String label) {
        if (this.validUnits.size() != this.unitLabelToUriMap.keySet().size()) {
            this.fillUnitLabelToUriMap();
        }
        return this.unitLabelToUriMap.get(label);
    }

    private void fillUnitLabelToUriMap() {
        this.unitLabelToUriMap = new HashMap();
        for (MeasurementUnit munit : this.validUnits) {
            this.unitLabelToUriMap.put(munit.getLabel(), munit.getUri());
        }
    }

    public Descriptor getACopy() {
        Descriptor descriptor = new Descriptor();
        descriptor.setUri(this.uri);
        descriptor.setLabel(this.label);
        descriptor.setDescription(this.description);
        descriptor.setCategories(new ArrayList<String>(this.getCategories()));
        if (this.maxOccurrence != null) {
            descriptor.setMaxOccurrence((int)this.maxOccurrence);
        }
        if (this.position != null) {
            descriptor.setPosition(this.position);
        }
        for (Namespace ns : this.getNamespaces()) {
            descriptor.addNamespace(ns.getACopy());
        }
        for (MeasurementUnit validUnit : this.getValidUnits()) {
            descriptor.addValidUnit(validUnit.getACopy());
        }
        descriptor.setDefaultMeasurementUnit(this.getDefaultMeasurementUnit());
        descriptor.setSelectedMeasurementUnit(this.getSelectedMeasurementUnit());
        descriptor.setValue(this.getValue());
        descriptor.setValueTriple(this.getValueTriple().getACopy());
        return descriptor;
    }
}

