/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.property;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.io.PropertyWriter;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.datamodel.property.PropertyDataFile;
import org.grits.toolbox.core.datamodel.util.DataModelSearch;
import org.grits.toolbox.core.utilShare.DeleteUtils;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.entry.sample.config.ImageRegistry;
import org.grits.toolbox.entry.sample.io.SamplePropertyWriter;
import org.grits.toolbox.entry.sample.model.Component;
import org.grits.toolbox.entry.sample.model.Sample;
import org.grits.toolbox.entry.sample.utilities.UtilityFile;

public class SampleProperty
extends Property {
    private static Logger logger = Logger.getLogger(SampleProperty.class);
    public static final String SAMPLE_FOLDER = "sample";
    public static final String TYPE = "org.grits.toolbox.property.sample";
    protected static ImageDescriptor imageDescriptor = ImageRegistry.getImageDescriptor(ImageRegistry.SampleImage.SAMPLE_ICON_SMALL);
    protected static PropertyWriter writer = new SamplePropertyWriter();

    public PropertyDataFile getSampleFile() {
        logger.info((Object)"Getting sample property data file name");
        PropertyDataFile sampleFile = null;
        for (PropertyDataFile dataFile : this.dataFiles) {
            if (!"default".equals(dataFile.getType())) continue;
            sampleFile = dataFile;
            logger.info((Object)("Sample property data file name found with type default [" + sampleFile.getName() + ", version - " + sampleFile.getVersion() + "]"));
            break;
        }
        return sampleFile;
    }

    public String getType() {
        return TYPE;
    }

    public PropertyWriter getWriter() {
        return writer;
    }

    public ImageDescriptor getImage() {
        return imageDescriptor;
    }

    public void delete(Entry entry) {
        logger.info((Object)"Deleting sample entry");
        String sampleGroupFolderLocation = UtilityFile.getSampleFolderForSample(entry).getAbsolutePath();
        PropertyDataFile sampleDataFile = this.getSampleFile();
        if (sampleDataFile != null) {
            String fileLocation = String.valueOf(sampleGroupFolderLocation) + File.separator + sampleDataFile.getName();
            try {
                DeleteUtils.delete((File)new File(fileLocation));
                logger.info((Object)("Sample file deleted " + fileLocation));
            }
            catch (IOException e) {
                logger.error((Object)("Error deleting sample file.\n" + e.getMessage()), (Throwable)e);
                ErrorUtils.createErrorMessageBox((Shell)Display.getCurrent().getActiveShell(), (String)"Cannot Delete Entry", (Exception)e);
            }
        }
    }

    public Object clone() {
        return null;
    }

    public Property getParentProperty() {
        return null;
    }

    public static Sample loadAnalyte(Entry sampleEntry) throws FileNotFoundException, JAXBException, UnsupportedEncodingException {
        logger.info((Object)"Loading sample object for entry");
        Sample sample = null;
        if (sampleEntry != null && sampleEntry.getProperty() != null && sampleEntry.getProperty() instanceof SampleProperty) {
            logger.info((Object)("Sample entry : " + sampleEntry.getDisplayName()));
            SampleProperty sampleProperty = (SampleProperty)sampleEntry.getProperty();
            PropertyDataFile sampleDataFile = sampleProperty.getSampleFile();
            if (sampleDataFile == null || sampleDataFile.getName() == null) {
                logger.error((Object)("Missing file name from the sample Entry " + sampleEntry.getDisplayName()));
                throw new FileNotFoundException("Missing file name from the Sample Entry " + sampleEntry.getDisplayName());
            }
            if ("1.0".equals(sampleDataFile.getVersion())) {
                File file = new File(UtilityFile.getSampleFolderForSample(sampleEntry) + File.separator + sampleDataFile.getName());
                logger.info((Object)("Loading File : " + file.getAbsolutePath()));
                FileInputStream inputStream = new FileInputStream(file.getAbsolutePath());
                InputStreamReader reader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Sample.class});
                Unmarshaller unmarshaller = context.createUnmarshaller();
                sample = (Sample)unmarshaller.unmarshal((Reader)reader);
                for (Component component : sample.getComponents()) {
                    if (component.getComponentId() != null) continue;
                    component.setComponentId(sample.getNextAvailableComponentId());
                }
                logger.info((Object)("Sample loaded from file : " + file.getAbsolutePath()));
            }
        }
        return sample;
    }

    public void makeACopy(Entry currentEntry, Entry destinationEntry) throws IOException {
        if (currentEntry == null || destinationEntry == null) {
            logger.fatal((Object)("Cannot copy entry for null values : " + currentEntry + " - " + destinationEntry));
            throw new IOException("Cannot copy entry for null values : " + currentEntry + " - " + destinationEntry);
        }
        try {
            File destinationSampleFolder;
            logger.info((Object)("Copying sample " + currentEntry.getDisplayName() + " to " + destinationEntry.getDisplayName()));
            File currentSampleFile = new File(UtilityFile.getSampleFolderForSample(currentEntry), this.getSampleFile().getName());
            if (currentSampleFile.exists()) {
                destinationSampleFolder = UtilityFile.getSampleGroupDirectory(destinationEntry.getParent().getDisplayName());
                if (!destinationSampleFolder.exists() || !destinationSampleFolder.isDirectory()) {
                    logger.info((Object)("Creating Sample folder in destination entry : " + destinationSampleFolder.getAbsolutePath()));
                    destinationSampleFolder.mkdir();
                }
            } else {
                throw new FileNotFoundException("Could not find sample file for selected sample \"" + currentEntry.getDisplayName() + "\" in project \"" + DataModelSearch.findParentByType((Entry)currentEntry, (String)"org.grits.toolbox.property.project").getDisplayName() + "\"");
            }
            File destinationSampleFile = new File(destinationSampleFolder, UtilityFile.generateFileName(destinationSampleFolder.list()));
            logger.info((Object)("Copying sample file : from [" + currentSampleFile.getAbsolutePath() + "] to [" + destinationSampleFile.getAbsolutePath() + "]"));
            Files.copy(currentSampleFile.toPath(), destinationSampleFile.toPath(), new CopyOption[0]);
            ArrayList<PropertyDataFile> dataFiles = new ArrayList<PropertyDataFile>();
            PropertyDataFile currentSampleDataFile = this.getSampleFile();
            dataFiles.add(new PropertyDataFile(destinationSampleFile.getName(), currentSampleDataFile.getVersion(), currentSampleDataFile.getType()));
            SampleProperty sampleProperty = new SampleProperty();
            sampleProperty.setDataFiles(dataFiles);
            sampleProperty.setRemoved(!this.exists());
            sampleProperty.setVersion(this.getVersion());
            sampleProperty.setViewerRank(this.getViewerRank());
            destinationEntry.setProperty((Property)sampleProperty);
            logger.info((Object)"Sample copied");
        }
        catch (FileNotFoundException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        catch (IOException ex) {
            logger.error((Object)("Error copying sample information.\n" + ex.getMessage()), (Throwable)ex);
            throw new IOException("Error copying sample information.\n" + ex.getMessage(), ex);
        }
    }
}

