/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.utilities;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class MaintainTreeColumnRatioListener
implements ControlListener {
    private Logger logger = Logger.getLogger(MaintainTreeColumnRatioListener.class);
    private int minWidth = 0;
    private final int TREE_EXTRA_PADDING = 5;
    private static final int COLUMN_FALL_BACK_WIDTH = 10;
    private List<Integer> ratios = null;
    private int ratioDenominator = 0;

    public MaintainTreeColumnRatioListener(int minWidth, int ... ratios) {
        this.minWidth = minWidth;
        this.ratios = new ArrayList<Integer>();
        int i = 0;
        int[] nArray = ratios;
        int n = ratios.length;
        int n2 = 0;
        while (n2 < n) {
            int relativeWidth = nArray[n2];
            relativeWidth = relativeWidth < 1 ? 1 : relativeWidth;
            this.ratios.add(i++, relativeWidth);
            this.ratioDenominator += relativeWidth;
            ++n2;
        }
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
        this.logger.debug((Object)"- START : Resizing columns.");
        try {
            Tree table = (Tree)e.getSource();
            if (table.getColumns().length == this.ratios.size()) {
                int totalWidth = Math.max(table.getSize().x - 5, this.minWidth);
                totalWidth = table.getVerticalBar().getVisible() ? totalWidth - table.getVerticalBar().getSize().x : totalWidth;
                totalWidth -= 20;
                int index = 0;
                TreeColumn[] columns = table.getColumns();
                int width = 0;
                int widthTillLastColumn = 0;
                while (index < table.getColumnCount() - 1) {
                    width = totalWidth / this.ratioDenominator * this.ratios.get(index);
                    columns[index].setWidth(width);
                    widthTillLastColumn += width;
                    ++index;
                }
                int remainingWidth = totalWidth - widthTillLastColumn;
                if (remainingWidth >= 0) {
                    columns[index].setWidth(remainingWidth);
                } else {
                    columns[index].setWidth(10);
                    this.logger.error((Object)"Negative width values");
                }
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex);
        }
        this.logger.debug((Object)"- END   : Resizing columns.");
    }
}

