/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.wizard.analyte;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.entry.sample.model.Component;
import org.grits.toolbox.entry.sample.model.Sample;
import org.grits.toolbox.entry.sample.preference.SamplePreferenceStore;
import org.grits.toolbox.entry.sample.utilities.AnalyteFactory;
import org.grits.toolbox.entry.sample.wizard.analyte.pages.NewAnalytePageOne;
import org.grits.toolbox.entry.sample.wizard.analyte.pages.NewAnalytePageTwo;

public class NewAnalyteWizard
extends Wizard {
    private NewAnalytePageOne pageOne = new NewAnalytePageOne();
    private NewAnalytePageTwo pageTwo = new NewAnalytePageTwo();
    private Sample sample = null;

    public void addPages() {
        this.addPage((IWizardPage)this.pageOne);
        this.addPage((IWizardPage)this.pageTwo);
        this.getShell().setSize(750, 450);
    }

    public boolean performFinish() {
        this.sample = new Sample();
        this.sample.setName(this.pageOne.getName());
        this.sample.setDescription(this.pageOne.getDescription());
        Component component = null;
        if (this.pageTwo.radioButton2.getSelection()) {
            Component componentToBeCopied = this.pageTwo.getSampleToBeCopied();
            component = componentToBeCopied.getACopy();
            String description = "Copy of another component : " + componentToBeCopied.getLabel();
            description = String.valueOf(description) + (componentToBeCopied.getDescription() == null ? "" : "\n(  " + componentToBeCopied.getDescription() + "  )");
            component.setDescription(description);
        } else {
            component = this.pageTwo.radioButton3.getSelection() ? AnalyteFactory.createComponentFromTemplate(this.pageTwo.getSelectedTemplate()) : new Component();
        }
        String componentLabel = this.pageTwo.getLabel();
        component.setLabel(componentLabel);
        component.setComponentId(this.sample.getNextAvailableComponentId());
        this.sample.addComponent(component);
        Component nextComponent = null;
        int numberOfComponents = SamplePreferenceStore.getDefaultNumberOfComponents();
        int i = 2;
        while (i <= numberOfComponents) {
            nextComponent = component.getACopy();
            nextComponent.setLabel(String.valueOf(componentLabel) + " " + i);
            nextComponent.setComponentId(this.sample.getNextAvailableComponentId());
            this.sample.addComponent(nextComponent);
            ++i;
        }
        return true;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.pageOne) {
            return this.pageTwo;
        }
        return null;
    }

    public Sample getSample() {
        return this.sample;
    }

    public Entry getProjectEntry() {
        return this.pageOne.getProjectEntry();
    }

    public void setProjectEntry(Entry projectEntry) {
        this.pageOne.setProjectEntry(projectEntry);
    }
}

