/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collection;
import java.util.TreeMap;
import java.util.Vector;
import org.eurocarbdb.application.glycanbuilder.FragmentCollection;
import org.eurocarbdb.application.glycanbuilder.FragmentDocument;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.TextUtils;
import org.eurocarbdb.application.glycoworkbench.plugin.GAGOptions;
import org.eurocarbdb.application.glycoworkbench.plugin.GAGType;
import org.eurocarbdb.application.glycoworkbench.plugin.Generator;
import org.eurocarbdb.application.glycoworkbench.plugin.GeneratorListener;

public class GAGDictionary
implements Generator {
    protected TreeMap<String, GAGType> dictionary = new TreeMap();
    protected GAGOptions static_options = null;

    public GAGDictionary(String filename) {
        this.loadDictionary(filename);
    }

    public Collection<String> getFamilies() {
        return this.dictionary.keySet();
    }

    public Collection<GAGType> getTypes() {
        return this.dictionary.values();
    }

    public GAGType getType(String family) {
        return this.dictionary.get(family);
    }

    public GAGType getType(String family, GAGOptions options) {
        GAGType ret = this.dictionary.get(family);
        if (ret == null) {
            return null;
        }
        if (options.ALLOW_UNLIKELY_ACETYLATION) {
            ret = ret.allowUnlikelyAcetylation();
        }
        ret = ret.applyModifications(options.MODIFICATIONS);
        return ret;
    }

    public void setOptions(GAGOptions opt) {
        this.static_options = opt;
    }

    @Override
    public Vector<Glycan> getMotifs() {
        return this.getMotifs(this.static_options);
    }

    public Vector<Glycan> getMotifs(GAGOptions options) {
        Vector<Glycan> ret = new Vector<Glycan>();
        for (int i = 0; i < options.GAG_FAMILIES.length; ++i) {
            GAGType gt = this.getType(options.GAG_FAMILIES[i], options);
            ret.add(gt.getMotifStructure(options));
        }
        return ret;
    }

    @Override
    public void generate(int motif_ind, GeneratorListener listener) {
        GAGType gt = this.getType(this.static_options.GAG_FAMILIES[motif_ind], this.static_options);
        gt.generateStructures(listener, this.static_options);
    }

    public FragmentDocument generateStructures() {
        return this.generateStructures(this.static_options);
    }

    public FragmentDocument generateStructures(GAGOptions options) {
        FragmentDocument ret = new FragmentDocument();
        for (int i = 0; i < options.GAG_FAMILIES.length; ++i) {
            GAGType gt = this.getType(options.GAG_FAMILIES[i], options);
            FragmentCollection fc = gt.generateStructures(options);
            ret.addFragments(gt.getMotifStructure(options), fc);
        }
        return ret;
    }

    private void loadDictionary(String filename) {
        this.dictionary.clear();
        try {
            String line;
            URL file_url = GAGDictionary.class.getResource(filename);
            if (file_url == null) {
                throw new FileNotFoundException(filename);
            }
            BufferedReader is = new BufferedReader(new InputStreamReader(file_url.openStream()));
            while ((line = is.readLine()) != null) {
                if ((line = TextUtils.trim((String)line)).length() <= 0 || line.startsWith("%")) continue;
                GAGType type = new GAGType(line);
                this.dictionary.put(type.getFamily(), type);
            }
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
        }
    }
}

