/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.Action;
import javax.swing.JToolBar;
import org.eurocarbdb.application.glycanbuilder.BaseDocument;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.STOCK_ICON;
import org.eurocarbdb.application.glycoworkbench.AnnotatedPeakList;
import org.eurocarbdb.application.glycoworkbench.GlycanWorkspace;
import org.eurocarbdb.application.glycoworkbench.GlycoWorkbench;
import org.eurocarbdb.application.glycoworkbench.plugin.DocumentPanel;
import org.eurocarbdb.application.glycoworkbench.plugin.Plugin;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.XYDataset;

public class PeakAnnotationReportPanel
extends DocumentPanel<AnnotatedPeakList>
implements ActionListener {
    protected DefaultXYDataset theDataset;
    protected XYPlot thePlot;
    protected JFreeChart theChart;
    protected ChartPanel theChartPanel;
    protected JToolBar theToolBar;

    @Override
    protected void initComponents() {
        this.setLayout(new BorderLayout());
        this.theDataset = new DefaultXYDataset();
        this.theChart = ChartFactory.createScatterPlot((String)"Annotation", (String)"Count", (String)"Intensity", (XYDataset)this.theDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        this.thePlot = (XYPlot)this.theChart.getPlot();
        this.thePlot.setRenderer((XYItemRenderer)new StandardXYItemRenderer(2));
        this.theChartPanel = new ChartPanel(this.theChart);
        this.theChartPanel.setDomainZoomable(true);
        this.theChartPanel.setRangeZoomable(false);
        this.add((Component)this.theChartPanel, "Center");
        this.theToolBar = this.createToolBar();
        this.add((Component)this.theToolBar, "South");
    }

    @Override
    public AnnotatedPeakList getDocumentFromWorkspace(GlycanWorkspace workspace) {
        return workspace != null ? workspace.getAnnotatedPeakList() : null;
    }

    @Override
    public void setDocumentFromWorkspace(GlycanWorkspace workspace) {
        if (this.theDocument != null) {
            ((AnnotatedPeakList)((Object)this.theDocument)).removeDocumentChangeListener(this);
        }
        this.theDocument = this.getDocumentFromWorkspace(workspace);
        if (this.theDocument == null) {
            this.theDocument = new AnnotatedPeakList();
        }
        ((AnnotatedPeakList)((Object)this.theDocument)).addDocumentChangeListener(this);
        this.updateView();
        this.updateActions();
    }

    @Override
    protected void createActions() {
        this.theActionManager.add("new", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.REFRESH, Plugin.DEFAULT_ICON_SIZE), "Clear", 78, "", (ActionListener)this);
        this.theActionManager.add("print", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.DOCUMENT_PRINT, Plugin.DEFAULT_ICON_SIZE), "Print...", 80, "", (ActionListener)this);
    }

    @Override
    protected void updateActions() {
    }

    private JToolBar createToolBar() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.add((Action)this.theActionManager.get("new"));
        toolbar.addSeparator();
        toolbar.add((Action)this.theActionManager.get("print"));
        return toolbar;
    }

    @Override
    protected void updateData() {
    }

    @Override
    protected void updateView() {
        int l;
        for (l = 0; l < ((AnnotatedPeakList)((Object)this.theDocument)).getNoStructures(); ++l) {
            this.theDataset.removeSeries((Comparable)((Object)("series" + l)));
        }
        for (l = 0; l < ((AnnotatedPeakList)((Object)this.theDocument)).getNoStructures(); ++l) {
            int i;
            double[][] data = new double[][]{new double[((AnnotatedPeakList)((Object)this.theDocument)).getNoPeaks()], new double[((AnnotatedPeakList)((Object)this.theDocument)).getNoPeaks()]};
            LinkedList<Double> sortedList = new LinkedList<Double>();
            for (i = 0; i < ((AnnotatedPeakList)((Object)this.theDocument)).getNoPeaks(); ++i) {
                int index;
                double intensity = ((AnnotatedPeakList)((Object)this.theDocument)).getPeak(i).getIntensity();
                if (((AnnotatedPeakList)((Object)this.theDocument)).getAnnotations(i, l).size() == 0) {
                    intensity = 0.0;
                }
                if ((index = Collections.binarySearch(sortedList, intensity)) < 0) {
                    index = -index - 1;
                }
                sortedList.add(index, intensity);
            }
            for (i = 0; i < ((AnnotatedPeakList)((Object)this.theDocument)).getNoPeaks(); ++i) {
                data[0][i] = i;
                data[1][i] = (Double)sortedList.get(((AnnotatedPeakList)((Object)this.theDocument)).getNoPeaks() - i - 1);
            }
            this.theDataset.addSeries((Comparable)((Object)("series" + l)), (double[][])data);
        }
    }

    public void onPrint() {
        PrinterJob pj = this.theWorkspace.getPrinterJob();
        if (pj == null) {
            return;
        }
        try {
            pj.setPrintable((Printable)this.theChartPanel);
            if (pj.printDialog()) {
                pj.print();
            }
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals("new")) {
            this.theApplication.onNew((BaseDocument)this.theDocument);
        } else if (action.equals("print")) {
            this.onPrint();
        }
        this.updateActions();
    }
}

