/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.views.tabbed;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.entry.ms.annotation.process.loader.MSAnnotationTableDataProcessor;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationMultiPageViewer;
import org.grits.toolbox.ms.om.data.CustomExtraData;

public class MSAnnotationFilterWindow
extends Dialog {
    private static final Logger logger = Logger.getLogger(MSAnnotationFilterWindow.class);
    protected final Font boldFont = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
    protected Text txtOutput;
    protected static final String PARAMS_OK = "Valid parameters";
    protected MPart part;
    private Text txtMSGlyResult;
    private Entry msAnnotationEntry;
    private Label lblFilter;
    private Combo filterList;
    private Label lblNumTopHits;
    private Text txtNumTopHits;
    protected static final String ALL = "All";
    private Button btnOverrideManualAnnotations;
    private List<CustomExtraData> featureCustomExtraData;

    public MSAnnotationFilterWindow(Shell parentShell, Entry entry, MPart part) {
        super(parentShell);
        this.msAnnotationEntry = entry;
        this.part = part;
        this.setShellStyle(66800);
    }

    public void setFeatureCustomExtraData(List<CustomExtraData> featureCustomExtraData) {
        this.featureCustomExtraData = featureCustomExtraData;
    }

    public List<CustomExtraData> getFeatureCustomExtraData() {
        return this.featureCustomExtraData;
    }

    public int open() {
        if (this.msAnnotationEntry == null) {
            return -1;
        }
        this.setFeatureCustomExtraData(MSAnnotationTableDataProcessor.getMSAnnotationFeatureCustomExtraData(this.getMSAnnotationEntry()));
        super.create();
        this.getShell().open();
        this.getShell().setText(this.getTitle());
        this.getShell().layout();
        this.getShell().pack();
        this.getButton(0).setEnabled(false);
        return this.getReturnCode();
    }

    protected String getTitle() {
        return "MS Annotation Filter";
    }

    protected Control createDialogArea(Composite parent) {
        Composite content = (Composite)super.createDialogArea(parent);
        Monitor primary = this.getShell().getDisplay().getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = this.getShell().getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        this.getShell().setLocation(x, y);
        content.setLayout((Layout)new GridLayout(1, false));
        ScrolledComposite sc = new ScrolledComposite(content, 2816);
        sc.setExpandVertical(true);
        sc.setExpandHorizontal(true);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 400;
        data.widthHint = 700;
        sc.setLayoutData((Object)data);
        Composite container = new Composite((Composite)sc, 0);
        container.setLayout((Layout)new GridLayout(4, false));
        this.txtOutput = new Text(container, 2122);
        this.txtOutput.setText("Please specify filter parameters.\n\n");
        this.txtOutput.setFont(this.boldFont);
        this.txtOutput.setBackground(Display.getCurrent().getSystemColor(1));
        GridData gridDataTxtOutput = new GridData(768);
        gridDataTxtOutput.horizontalSpan = 4;
        gridDataTxtOutput.verticalSpan = 2;
        this.txtOutput.setLayoutData((Object)gridDataTxtOutput);
        Label lblMsExperiment = new Label(container, 0);
        lblMsExperiment.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        lblMsExperiment.setText("MS Annotation");
        this.txtMSGlyResult = new Text(container, 2056);
        this.txtMSGlyResult.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        if (this.getMSAnnotationEntry() != null) {
            this.txtMSGlyResult.setText(this.getMSAnnotationEntry().getDisplayName());
        }
        this.createFilterSection(container);
        this.createScoreFilterSection(container);
        sc.setContent((Control)container);
        sc.setMinSize(container.computeSize(-1, -1));
        return parent;
    }

    protected String getAnnotationLabelText() {
        return "MS Annotation";
    }

    public int getNumTopHits() {
        if (this.txtNumTopHits != null && this.txtNumTopHits.getText().equals(ALL)) {
            return -1;
        }
        if (this.txtNumTopHits == null) {
            return -1;
        }
        try {
            return Integer.parseInt(this.txtNumTopHits.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return -2;
        }
    }

    public boolean getOverrideManualAnnotations() {
        if (this.btnOverrideManualAnnotations != null) {
            return this.btnOverrideManualAnnotations.getSelection();
        }
        return false;
    }

    public String getFilterKey() {
        if (this.filterList == null) {
            return null;
        }
        if (!this.filterList.getText().equals("")) {
            for (CustomExtraData cnd : this.getFeatureCustomExtraData()) {
                if (!this.filterList.getText().equals(cnd.getLabel())) continue;
                return cnd.getKey();
            }
        }
        return null;
    }

    protected void createScoreFilterSection(Composite container) {
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.lblFilter = new Label(container, 0);
        this.lblFilter.setText("Choose a criterion to use as score filter");
        this.lblFilter.setLayoutData((Object)gridData);
        MSAnnotationMultiPageViewer parentViewer = MSAnnotationMultiPageViewer.getActiveViewerForEntry(this.part.getContext(), this.getMSAnnotationEntry());
        this.createLists(parentViewer, container);
        this.lblNumTopHits = new Label(container, 0);
        this.lblNumTopHits.setText("Number of Top Hits to Select: ");
        GridData gridData2 = new GridData(768);
        gridData2.horizontalSpan = 1;
        gridData2.verticalSpan = 1;
        this.lblNumTopHits.setLayoutData((Object)gridData2);
        this.txtNumTopHits = new Text(container, 2048);
        this.txtNumTopHits.setText(ALL);
        GridData gridData4 = new GridData(768);
        gridData4.horizontalSpan = 3;
        gridData4.verticalSpan = 1;
        this.txtNumTopHits.setLayoutData((Object)gridData4);
        if (parentViewer != null && parentViewer.getFilter() != null) {
            if (parentViewer.getFilter().getNumTopHits() == -1) {
                this.txtNumTopHits.setText(ALL);
            } else {
                this.txtNumTopHits.setText(String.valueOf(parentViewer.getFilter().getNumTopHits()));
            }
        }
        this.txtNumTopHits.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MSAnnotationFilterWindow.this.validateInput();
            }
        });
        new Label(container, 0);
        new Label(container, 0);
        this.btnOverrideManualAnnotations = new Button(container, 32);
        this.btnOverrideManualAnnotations.setText("Override manually selected annotations");
        GridData gridData3 = new GridData(768);
        gridData3.horizontalSpan = 4;
        gridData3.verticalSpan = 1;
        this.btnOverrideManualAnnotations.setLayoutData((Object)gridData3);
    }

    private void createLists(MSAnnotationMultiPageViewer parentViewer, Composite parent) {
        if (this.filterList != null) {
            this.filterList.removeAll();
        } else {
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            gridData.verticalSpan = 1;
            this.filterList = new Combo(parent, 4);
            this.filterList.setLayoutData((Object)gridData);
        }
        this.filterList.add("");
        this.filterList.setEnabled(false);
        if (this.getFeatureCustomExtraData() == null) {
            return;
        }
        int i = 1;
        for (CustomExtraData cnd : this.getFeatureCustomExtraData()) {
            this.filterList.add(cnd.getLabel());
            if (parentViewer != null && parentViewer.getFilter() != null && cnd.getKey().equals(parentViewer.getFilter().getColumnKey())) {
                this.filterList.select(i);
            }
            ++i;
        }
        if (this.filterList.getItemCount() > 1) {
            this.filterList.setEnabled(true);
            this.filterList.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    MSAnnotationFilterWindow.this.validateInput();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
    }

    public Entry getMSAnnotationEntry() {
        return this.msAnnotationEntry;
    }

    public void setMSAnnotationEntry(Entry msGlycanEntry) {
        this.msAnnotationEntry = msGlycanEntry;
    }

    public void validateInput() {
        this.txtOutput.setText(PARAMS_OK);
        if (this.getMSAnnotationEntry() == null) {
            this.txtOutput.setText("Please select MS Annotation Results");
        } else if (this.getFilterKey() == null) {
            this.txtOutput.setText("Please select a filter criterion");
        } else if (this.getNumTopHits() == -2) {
            this.txtOutput.setText("Invalid value for 'Num Top Hits'. Please enter 'All' or an integer greater than 0.");
        }
        if (this.txtOutput.getText().equals(PARAMS_OK)) {
            this.getButton(0).setEnabled(true);
        } else {
            this.getButton(0).setEnabled(false);
        }
    }

    protected void createFilterSection(Composite parent) {
    }
}

