/*
 * Decompiled with CFR 0.152.
 */
package org.glycomedb.residuetranslator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eurocarbdb.resourcesdb.GlycanNamescheme;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.EcdbAnomer;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.EcdbBaseType;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.EcdbModification;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.EcdbModificationType;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.EcdbMonosaccharide;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.EcdbSuperclass;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.GlycoconjugateException;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.LinkageType;
import org.eurocarbdb.resourcesdb.io.MonosaccharideExchangeObject;
import org.eurocarbdb.resourcesdb.io.SubstituentExchangeObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResidueLoader {
    private HashMap<GlycanNamescheme, HashMap<String, MonosaccharideExchangeObject>> m_monosaccharideMapping = new HashMap();
    private HashMap<GlycanNamescheme, HashMap<String, SubstituentExchangeObject>> m_substitutentMapping = new HashMap();
    private HashMap<GlycanNamescheme, HashMap<String, List<MonosaccharideExchangeObject>>> m_msFromGlycoCTMapping = new HashMap();
    private HashMap<GlycanNamescheme, HashMap<String, List<SubstituentExchangeObject>>> m_substFromGlycoCTMapping = new HashMap();
    private HashMap<GlycanNamescheme, HashMap<String, String>> m_nonCarbohydrateMapping = new HashMap();

    public void loadResidues() throws IOException {
        HashMap<Integer, ArrayList<SubstituentExchangeObject>> hashMap = this.loadCarbohydratesToSubstituent(new BufferedReader(new InputStreamReader(ResidueLoader.class.getResourceAsStream("/dictionaries/carbohydrate_has_substituent.csv"))));
        this.loadCarbohydrates(new BufferedReader(new InputStreamReader(ResidueLoader.class.getResourceAsStream("/dictionaries/carbohydrate.csv"))), hashMap);
        this.loadSubstituents(new BufferedReader(new InputStreamReader(ResidueLoader.class.getResourceAsStream("/dictionaries/substituent.csv"))));
        this.loadNonCarbohydrate(new BufferedReader(new InputStreamReader(ResidueLoader.class.getResourceAsStream("/dictionaries/noncarbohydrate.csv"))));
    }

    private void loadNonCarbohydrate(BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        HashMap<String, String> hashMap = null;
        while ((string = bufferedReader.readLine()) != null) {
            String[] stringArray = string.split("\";\"");
            GlycanNamescheme glycanNamescheme = this.getNameschema(stringArray[2].substring(0, stringArray[2].length() - 1));
            hashMap = this.m_nonCarbohydrateMapping.get(glycanNamescheme);
            if (hashMap == null) {
                hashMap = new HashMap();
                hashMap.put(stringArray[1].toLowerCase(), stringArray[1]);
                this.m_nonCarbohydrateMapping.put(glycanNamescheme, hashMap);
                continue;
            }
            hashMap.put(stringArray[1].toLowerCase(), stringArray[1]);
        }
    }

    private void loadCarbohydrates(BufferedReader bufferedReader, HashMap<Integer, ArrayList<SubstituentExchangeObject>> hashMap) throws IOException {
        String string = bufferedReader.readLine();
        HashMap<String, List<Object>> hashMap2 = null;
        HashMap<String, Object> hashMap3 = null;
        MonosaccharideExchangeObject monosaccharideExchangeObject = null;
        while ((string = bufferedReader.readLine()) != null) {
            Object object;
            String[] stringArray = string.split("\";\"");
            Integer n = this.getId(stringArray[0].substring(1));
            GlycanNamescheme glycanNamescheme = this.getNameschema(stringArray[2]);
            monosaccharideExchangeObject = new MonosaccharideExchangeObject();
            try {
                monosaccharideExchangeObject.setBasetype(this.createBaseType(stringArray[3].substring(0, stringArray[3].length() - 1)));
            }
            catch (GlycoconjugateException glycoconjugateException) {
                throw new IOException(glycoconjugateException.getMessage() + " - " + stringArray[3].substring(0, stringArray[3].length() - 1), glycoconjugateException);
            }
            ArrayList<Object> arrayList = hashMap.get(n);
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            monosaccharideExchangeObject.setSubstituents(arrayList);
            monosaccharideExchangeObject.setMonosaccharideName(stringArray[1]);
            hashMap3 = this.m_monosaccharideMapping.get(glycanNamescheme);
            if (hashMap3 == null) {
                hashMap3 = new HashMap();
                hashMap3.put(stringArray[1].toLowerCase(), monosaccharideExchangeObject);
                this.m_monosaccharideMapping.put(glycanNamescheme, hashMap3);
            } else {
                hashMap3.put(stringArray[1].toLowerCase(), monosaccharideExchangeObject);
            }
            hashMap2 = this.m_msFromGlycoCTMapping.get(glycanNamescheme);
            if (hashMap2 == null) {
                hashMap2 = new HashMap();
                object = new ArrayList<MonosaccharideExchangeObject>();
                object.add(monosaccharideExchangeObject);
                hashMap2.put(stringArray[3].substring(0, stringArray[3].length() - 1).toLowerCase(), (List<Object>)object);
                this.m_msFromGlycoCTMapping.put(glycanNamescheme, hashMap2);
                continue;
            }
            object = stringArray[3].substring(0, stringArray[3].length() - 1).toLowerCase();
            List<Object> list = hashMap2.get(object);
            if (list == null) {
                list = new ArrayList<Object>();
                list.add(monosaccharideExchangeObject);
                hashMap2.put((String)object, list);
                continue;
            }
            list.add(monosaccharideExchangeObject);
        }
    }

    private EcdbMonosaccharide createBaseType(String string) throws IOException, GlycoconjugateException {
        String[] stringArray = string.split("\\|");
        String[] stringArray2 = stringArray[0].split("-");
        if (stringArray2.length < 3) {
            throw new IOException("Invalid monosaccharide name: " + string);
        }
        EcdbAnomer ecdbAnomer = EcdbAnomer.forName((char)stringArray2[0].charAt(0));
        EcdbSuperclass ecdbSuperclass = EcdbSuperclass.SUG;
        if (!stringArray2[stringArray2.length - 2].equals("NNN")) {
            ecdbSuperclass = EcdbSuperclass.forName((String)stringArray2[stringArray2.length - 2]);
        }
        EcdbMonosaccharide ecdbMonosaccharide = new EcdbMonosaccharide(ecdbAnomer, ecdbSuperclass);
        ArrayList<EcdbBaseType> arrayList = new ArrayList<EcdbBaseType>();
        for (int i = 1; i < stringArray2.length - 2; ++i) {
            arrayList.add(EcdbBaseType.forName((String)stringArray2[i]));
        }
        ecdbMonosaccharide.setBaseType(arrayList);
        String[] stringArray3 = stringArray2[stringArray2.length - 1].split(":");
        ecdbMonosaccharide.setRing(this.getRingPosition(stringArray3[0]).intValue(), this.getRingPosition(stringArray3[1]).intValue());
        for (int i = 1; i < stringArray.length; ++i) {
            String[] stringArray4 = stringArray[i].split(":");
            String[] stringArray5 = stringArray4[0].split(",");
            EcdbModification ecdbModification = null;
            ecdbModification = stringArray5.length == 1 ? new EcdbModification(EcdbModificationType.forName((String)stringArray4[1]), Integer.valueOf(Integer.parseInt(stringArray5[0]))) : new EcdbModification(EcdbModificationType.forName((String)stringArray4[1]), Integer.valueOf(Integer.parseInt(stringArray5[0])), Integer.valueOf(Integer.parseInt(stringArray5[1])));
            ecdbMonosaccharide.addModification(ecdbModification);
        }
        return ecdbMonosaccharide;
    }

    private Integer getRingPosition(String string) {
        if (string.equalsIgnoreCase("x")) {
            return -1;
        }
        if (string.equals("0")) {
            return 0;
        }
        return Integer.parseInt(string);
    }

    private HashMap<Integer, ArrayList<SubstituentExchangeObject>> loadCarbohydratesToSubstituent(BufferedReader bufferedReader) throws IOException {
        HashMap<Integer, ArrayList<SubstituentExchangeObject>> hashMap = new HashMap<Integer, ArrayList<SubstituentExchangeObject>>();
        String string = bufferedReader.readLine();
        SubstituentExchangeObject substituentExchangeObject = null;
        ArrayList<Object> arrayList = null;
        while ((string = bufferedReader.readLine()) != null) {
            String[] stringArray = string.split("\";\"");
            substituentExchangeObject = new SubstituentExchangeObject(GlycanNamescheme.GLYCOCT);
            substituentExchangeObject.setName(stringArray[1]);
            substituentExchangeObject.setPosition1(this.getPosition(stringArray[2]));
            substituentExchangeObject.setPosition2(this.getPosition(stringArray[4]));
            substituentExchangeObject.setLinkagetype1(this.getLinkageType(stringArray[3]));
            substituentExchangeObject.setLinkagetype2(this.getLinkageType(stringArray[5].substring(0, stringArray[5].length() - 1)));
            substituentExchangeObject.setSubstituentPosition1(1);
            substituentExchangeObject.setSubstituentPosition2(1);
            Integer n = this.getId(stringArray[0].substring(1));
            arrayList = hashMap.get(n);
            if (arrayList == null) {
                arrayList = new ArrayList();
                arrayList.add(substituentExchangeObject);
                hashMap.put(n, arrayList);
                continue;
            }
            arrayList.add(substituentExchangeObject);
        }
        return hashMap;
    }

    private ArrayList<Integer> getPosition(String string) throws IOException {
        String[] stringArray;
        if (string.equals("")) {
            return new ArrayList<Integer>();
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (String string2 : stringArray = string.split("\\|")) {
            arrayList.add(this.getId(string2));
        }
        return arrayList;
    }

    private Integer getId(String string) throws IOException {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            throw new IOException("Not a number: " + string);
        }
    }

    private void loadSubstituents(BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        SubstituentExchangeObject substituentExchangeObject = null;
        HashMap<String, Object> hashMap = null;
        HashMap<String, List<Object>> hashMap2 = null;
        while ((string = bufferedReader.readLine()) != null) {
            Object object;
            String[] stringArray = string.split("\";\"");
            GlycanNamescheme glycanNamescheme = this.getNameschema(stringArray[1]);
            substituentExchangeObject = new SubstituentExchangeObject(GlycanNamescheme.GLYCOCT);
            substituentExchangeObject.setLinkagetype1(this.getLinkageType(stringArray[3]));
            substituentExchangeObject.setLinkagetype2(this.getLinkageType(stringArray[4].substring(0, stringArray[4].length() - 1)));
            substituentExchangeObject.setName(stringArray[2]);
            substituentExchangeObject.setOriginalName(stringArray[0].substring(1));
            hashMap = this.m_substitutentMapping.get(glycanNamescheme);
            if (hashMap == null) {
                hashMap = new HashMap();
                hashMap.put(stringArray[0].substring(1).toLowerCase(), substituentExchangeObject);
                this.m_substitutentMapping.put(glycanNamescheme, hashMap);
            } else {
                hashMap.put(stringArray[0].substring(1).toLowerCase(), substituentExchangeObject);
            }
            hashMap2 = this.m_substFromGlycoCTMapping.get(glycanNamescheme);
            if (hashMap2 == null) {
                hashMap2 = new HashMap();
                object = new ArrayList();
                object.add(substituentExchangeObject);
                hashMap2.put(stringArray[2].toLowerCase(), (List<Object>)object);
                this.m_substFromGlycoCTMapping.put(glycanNamescheme, hashMap2);
                continue;
            }
            object = stringArray[2].toLowerCase();
            List<Object> list = hashMap2.get(object);
            if (list == null) {
                list = new ArrayList<Object>();
                list.add(substituentExchangeObject);
                hashMap2.put(stringArray[2].toLowerCase(), list);
                continue;
            }
            list.add(substituentExchangeObject);
        }
    }

    private LinkageType getLinkageType(String string) throws IOException {
        if (string.equals("")) {
            return null;
        }
        if (string.equals("o")) {
            return LinkageType.H_AT_OH;
        }
        if (string.equals("h")) {
            return LinkageType.H_LOSE;
        }
        if (string.equals("d")) {
            return LinkageType.DEOXY;
        }
        if (string.equals("x")) {
            return null;
        }
        throw new IOException("Unknown linkage type: " + string);
    }

    private GlycanNamescheme getNameschema(String string) throws IOException {
        if (string.equals("bcsdb")) {
            return GlycanNamescheme.BCSDB;
        }
        if (string.equals("kegg")) {
            return GlycanNamescheme.KEGG;
        }
        if (string.equals("glycosciences.de")) {
            return GlycanNamescheme.GLYCOSCIENCES;
        }
        if (string.equals("glycobase(lille)")) {
            return GlycanNamescheme.AUTO;
        }
        if (string.equals("cfg")) {
            return GlycanNamescheme.CFG;
        }
        if (string.equals("carbbank")) {
            return GlycanNamescheme.CARBBANK;
        }
        if (string.equals("glycomedb")) {
            return GlycanNamescheme.GLYCOCT;
        }
        if (string.equals("eurocarbdb")) {
            return GlycanNamescheme.GLYCOCT;
        }
        throw new IOException("Unknown nameschema: " + string);
    }

    public HashMap<GlycanNamescheme, HashMap<String, MonosaccharideExchangeObject>> getMonosaccharideMapping() {
        return this.m_monosaccharideMapping;
    }

    public void setMonosaccharideMapping(HashMap<GlycanNamescheme, HashMap<String, MonosaccharideExchangeObject>> hashMap) {
        this.m_monosaccharideMapping = hashMap;
    }

    public HashMap<GlycanNamescheme, HashMap<String, SubstituentExchangeObject>> getSubstitutentMapping() {
        return this.m_substitutentMapping;
    }

    public void setSubstitutentMapping(HashMap<GlycanNamescheme, HashMap<String, SubstituentExchangeObject>> hashMap) {
        this.m_substitutentMapping = hashMap;
    }

    public HashMap<GlycanNamescheme, HashMap<String, List<MonosaccharideExchangeObject>>> getMsFromGlycoCTMapping() {
        return this.m_msFromGlycoCTMapping;
    }

    public void setMsFromGlycoCTMapping(HashMap<GlycanNamescheme, HashMap<String, List<MonosaccharideExchangeObject>>> hashMap) {
        this.m_msFromGlycoCTMapping = hashMap;
    }

    public HashMap<GlycanNamescheme, HashMap<String, List<SubstituentExchangeObject>>> getSubstFromGlycoCTMapping() {
        return this.m_substFromGlycoCTMapping;
    }

    public void setSubstFromGlycoCTMapping(HashMap<GlycanNamescheme, HashMap<String, List<SubstituentExchangeObject>>> hashMap) {
        this.m_substFromGlycoCTMapping = hashMap;
    }

    public void setAglycaMapping(HashMap<GlycanNamescheme, HashMap<String, String>> hashMap) {
        this.m_nonCarbohydrateMapping = hashMap;
    }

    public HashMap<GlycanNamescheme, HashMap<String, String>> getAglycaMapping() {
        return this.m_nonCarbohydrateMapping;
    }
}

