/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.datamodel.io;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.datamodel.property.PropertyDataFile;
import org.jdom.Attribute;
import org.jdom.Element;

public abstract class PropertyReader {
    private static final Logger logger = Logger.getLogger(PropertyReader.class);
    public static boolean UPDATE_PROJECT_XML = false;

    public static void addGenericInfo(Element propertyElement, Property property) {
        Attribute versionAttribute = propertyElement.getAttribute("version");
        if (versionAttribute != null) {
            property.setVersion(versionAttribute.getValue());
            ArrayList<PropertyDataFile> dataFiles = new ArrayList<PropertyDataFile>();
            Element fileElement = null;
            String name = null;
            PropertyDataFile dataFile = null;
            for (Object ch : propertyElement.getChildren("file")) {
                if (!(ch instanceof Element)) continue;
                fileElement = (Element)ch;
                name = fileElement.getAttributeValue("name");
                if (name != null) {
                    dataFile = new PropertyDataFile(name, fileElement.getAttributeValue("version"), fileElement.getAttributeValue("type"));
                    dataFiles.add(dataFile);
                    continue;
                }
                logger.error((Object)("No file name found for data file in property : " + property.getType()));
            }
            property.setDataFiles(dataFiles);
        } else {
            property.setVersion(null);
            logger.error((Object)("No version was found for the property : " + property.getType()));
        }
    }

    public abstract Property read(Element var1) throws UnsupportedVersionException, IOException;
}

