/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.datamodel.io.project;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.GritsDataModelService;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.core.datamodel.io.MissingReaderException;
import org.grits.toolbox.core.datamodel.io.ProjectFileHandler;
import org.grits.toolbox.core.datamodel.io.PropertyReader;
import org.grits.toolbox.core.datamodel.property.ProjectProperty;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.service.IGritsDataModelService;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

@Singleton
public class ProjectFileReader {
    private static final Logger logger = Logger.getLogger(ProjectFileReader.class);
    @Inject
    private IGritsDataModelService gritsDataModelService;
    private boolean partialReadMode = false;
    private HashMap<String, Element> propertyIdElementMap = new HashMap();
    public Integer lastIdentifier = 0;

    private void clearMap() {
        this.propertyIdElementMap.clear();
    }

    private Entry getEntry(Element entryElement) throws IOException, UnsupportedVersionException, MissingReaderException {
        Element propertyElement;
        String attributeValue;
        Entry currentEntry = new Entry();
        String idValue = entryElement.getAttributeValue("id");
        Integer identifier = null;
        if (idValue != null) {
            try {
                identifier = Integer.parseInt(idValue);
            }
            catch (NumberFormatException numberFormatException) {
                logger.fatal((Object)("Identifier is invalid for entry name (id=" + entryElement.getAttributeValue("id") + ")."));
                throw new IOException("Identifier is invalid for entry name (id=" + entryElement.getAttributeValue("id") + ").");
            }
        }
        if ((attributeValue = entryElement.getAttributeValue("name")) == null) {
            logger.fatal((Object)("Unable to find entry name (id=" + entryElement.getAttributeValue("id") + ")."));
            throw new IOException("Unable to find entry name (id=" + entryElement.getAttributeValue("id") + ").");
        }
        if (identifier > this.lastIdentifier) {
            this.lastIdentifier = identifier;
        }
        currentEntry.setId(identifier);
        currentEntry.setDisplayName(attributeValue);
        Date creationTime = new Date();
        attributeValue = entryElement.getAttributeValue("creationTime");
        try {
            creationTime = attributeValue == null ? creationTime : ProjectFileHandler.DATEFORMATER.parse(attributeValue);
        }
        catch (Exception exception) {
            logger.error((Object)("Unable to parse creation date for entry (id=" + entryElement.getAttributeValue("id") + "): " + attributeValue));
        }
        currentEntry.setCreationDate(creationTime);
        attributeValue = entryElement.getAttributeValue("lastEditorId");
        if (attributeValue != null) {
            currentEntry.setLastEditorId(attributeValue);
        }
        if ((attributeValue = entryElement.getAttributeValue("type")) != null) {
            try {
                currentEntry.setEntryType(Integer.parseInt(attributeValue));
            }
            catch (Exception exception) {
                logger.error((Object)("Entry type was not a number: " + attributeValue));
            }
        }
        if ((propertyElement = this.propertyIdElementMap.get(entryElement.getAttributeValue("id"))) == null) {
            logger.fatal((Object)("Unable to find property for entry (id=" + entryElement.getAttributeValue("id") + ")."));
            throw new IOException("Unable to find property for entry (id=" + entryElement.getAttributeValue("id") + ").");
        }
        try {
            PropertyReader reader = this.buildReader(propertyElement.getAttributeValue("type"));
            Property t_property = reader.read(propertyElement);
            currentEntry.setProperty(t_property);
            if (!(this.partialReadMode || currentEntry.getProperty() instanceof ProjectProperty && !((ProjectProperty)currentEntry.getProperty()).isOpen())) {
                this.addChildrenEntries(entryElement, currentEntry);
            }
        }
        catch (MissingReaderException ex) {
            logger.fatal((Object)("No Reader found for " + propertyElement.getAttributeValue("type") + "\n" + ex.getMessage()), (Throwable)ex);
            if (!this.partialReadMode) {
                throw ex;
            }
        }
        catch (UnsupportedVersionException ex) {
            logger.fatal((Object)("Version is not supported for " + propertyElement.getAttributeValue("type") + "\n" + ex.getMessage()), (Throwable)ex);
            if (!this.partialReadMode) {
                throw ex;
            }
        }
        catch (IOException ex) {
            logger.fatal((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        return currentEntry;
    }

    private void addChildrenEntries(Element entryElement, Entry parentEntry) throws IOException, UnsupportedVersionException, MissingReaderException {
        List children = entryElement.getChildren();
        for (Element child : children) {
            if (!child.getName().equals("entry")) continue;
            GritsDataModelService.updateMode = false;
            this.gritsDataModelService.addEntry(parentEntry, this.getEntry(child));
            GritsDataModelService.updateMode = true;
        }
    }

    private PropertyReader buildReader(String entryType) throws IOException, MissingReaderException {
        IExtension[] iExtensionArray = Platform.getExtensionRegistry().getExtensionPoint("org.grits.toolbox.core", "propertyreader").getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension thisExtention = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = thisExtention.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement thisConfigurationElement = iConfigurationElementArray[n4];
                if (thisConfigurationElement.getName().equals("reader") && thisConfigurationElement.getAttribute("propertyId").equals(entryType)) {
                    try {
                        Object readerClass = thisConfigurationElement.createExecutableExtension("class");
                        PropertyReader propertyReader = (PropertyReader)readerClass;
                        return propertyReader;
                    }
                    catch (Exception e) {
                        logger.fatal((Object)("Unable to instantiate PropertyReader for type: " + entryType), (Throwable)e);
                        throw new IOException("Unable to instantiate PropertyReader for type: " + entryType, e);
                    }
                }
                ++n4;
            }
            ++n2;
        }
        logger.warn((Object)("Unable to find PropertyReader for type: " + entryType));
        throw new MissingReaderException("Unable to find PropertyReader for type: " + entryType);
    }

    public Entry readProjectXMLFile(File projectXmlFile) throws FileNotFoundException, IOException, UnsupportedVersionException, MissingReaderException {
        this.clearMap();
        this.partialReadMode = false;
        return this.buildProjectEntry(projectXmlFile);
    }

    public Entry readPartialProjectXMLFile(File projectXmlFile) throws IOException {
        this.clearMap();
        this.partialReadMode = true;
        Entry projectEntry = null;
        try {
            try {
                projectEntry = this.buildProjectEntry(projectXmlFile);
                ((ProjectProperty)projectEntry.getProperty()).setOpen(false);
            }
            catch (UnsupportedVersionException | MissingReaderException ex) {
                logger.fatal((Object)("This error should not happen in partial read mode.\n" + ex.getMessage()), (Throwable)ex);
                this.partialReadMode = false;
            }
            catch (IOException ex) {
                logger.fatal((Object)ex.getMessage(), (Throwable)ex);
                throw ex;
            }
        }
        finally {
            this.partialReadMode = false;
        }
        return projectEntry;
    }

    private Entry buildProjectEntry(File projectXmlFile) throws FileNotFoundException, IOException, UnsupportedVersionException, MissingReaderException {
        Entry projectEntry;
        block16: {
            projectEntry = null;
            if (projectXmlFile == null || !projectXmlFile.exists()) break block16;
            try {
                this.propertyIdElementMap.clear();
                SAXBuilder builder = new SAXBuilder();
                Document doc = builder.build(projectXmlFile);
                Element project = doc.getRootElement();
                if (!project.getName().equals("project")) {
                    logger.fatal((Object)("Project file does not start with project tag " + projectXmlFile.getAbsolutePath()));
                    throw new IOException("Project file does not start with project tag " + projectXmlFile.getAbsolutePath());
                }
                List children = project.getChildren();
                Element entryElement = null;
                for (Element childElement : children) {
                    switch (childElement.getName()) {
                        case "entry": {
                            entryElement = childElement;
                            break;
                        }
                        case "property": {
                            this.propertyIdElementMap.put(childElement.getAttributeValue("id"), childElement);
                            break;
                        }
                        default: {
                            throw new IOException("In .project.xml file project's child element has tag other than entry or property");
                        }
                    }
                }
                if (entryElement == null) {
                    logger.fatal((Object)("Unable to find entry tag " + projectXmlFile.getAbsolutePath()));
                    throw new IOException("Unable to find entry tag " + projectXmlFile.getAbsolutePath());
                }
                projectEntry = this.getEntry(entryElement);
                PropertyHandler.getDataModel().setShow(true);
                if (projectEntry != null) {
                    this.gritsDataModelService.setLastIdentifierForProject(projectEntry, this.lastIdentifier + 1);
                    this.lastIdentifier = 0;
                }
                this.propertyIdElementMap.clear();
            }
            catch (JDOMException e) {
                logger.fatal((Object)e.getMessage(), (Throwable)e);
                throw new IOException("Project xml is not a valid xml file [" + projectXmlFile.getAbsolutePath() + "]: \n" + e.getMessage());
            }
        }
        logger.fatal((Object)("Project xml file does not exist: " + projectXmlFile.getAbsolutePath()));
        throw new FileNotFoundException("Project xml file does not exist: " + projectXmlFile.getAbsolutePath());
        return projectEntry;
    }
}

