/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.preference.project;

import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.grits.toolbox.core.preference.project.CollaboratorTableColumn;
import org.grits.toolbox.core.preference.share.MultiChoiceInteger;
import org.grits.toolbox.core.preference.share.ProjectPreferenceStore;

public class CollaboratorTablePreference
extends PreferencePage {
    private static final Logger logger = Logger.getLogger(CollaboratorTablePreference.class);
    private Button[] buttons = null;
    private MultiChoiceInteger columnPreference = null;

    private void loadValuesAndSelect() {
        logger.info((Object)("Loading preference " + ProjectPreferenceStore.IntegerPreference.COLLABORATORS_TABLE.getPreferenceName()));
        this.columnPreference = ProjectPreferenceStore.getMultiChoiceInteger(ProjectPreferenceStore.IntegerPreference.COLLABORATORS_TABLE);
        this.buttons[0].setSelection(true);
        int i = 1;
        while (i < CollaboratorTableColumn.COLUMNS.length) {
            this.buttons[i].setSelection(this.columnPreference.getSelectedValues().contains(i));
            ++i;
        }
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 4);
        GridLayout layout = new GridLayout();
        layout.marginRight = 8;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 10;
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText("Visible Columns");
        GridData selectExistingData = new GridData(32);
        selectExistingData.horizontalSpan = 1;
        selectExistingData.verticalSpan = 1;
        label.setLayoutData((Object)selectExistingData);
        this.createColumnVisibilityPart(container);
        this.loadValuesAndSelect();
        return container;
    }

    private void createColumnVisibilityPart(Composite container) {
        Composite composite = new Composite(container, 2052);
        GridLayout layout = new GridLayout();
        layout.marginRight = 8;
        layout.marginTop = 10;
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 10;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)layout);
        String[] buttonNames = CollaboratorTableColumn.COLUMNS;
        this.buttons = new Button[buttonNames.length];
        this.buttons[0] = this.createCheckbox(composite, buttonNames[0]);
        ((GridData)this.buttons[0].getLayoutData()).horizontalSpan = 2;
        this.buttons[0].setSelection(true);
        this.buttons[0].setEnabled(false);
        int i = 1;
        while (i < buttonNames.length) {
            this.buttons[i] = this.createCheckbox(composite, buttonNames[i]);
            ++i;
        }
        GridData compositeLayoutData = new GridData(1808);
        compositeLayoutData.grabExcessHorizontalSpace = true;
        compositeLayoutData.horizontalSpan = 1;
        compositeLayoutData.verticalSpan = 1;
        composite.setLayoutData((Object)compositeLayoutData);
    }

    private Button createCheckbox(Composite composite, String label) {
        Button checkButton = new Button(composite, 32);
        checkButton.setText(label);
        GridData createNewData = new GridData(768);
        createNewData.horizontalSpan = 1;
        createNewData.verticalSpan = 1;
        checkButton.setLayoutData((Object)createNewData);
        return checkButton;
    }

    protected void performDefaults() {
        Map allSelectedMap = this.columnPreference.getDefaultValuesObjectMap();
        this.buttons[0].setSelection(true);
        int i = 1;
        while (i < CollaboratorTableColumn.COLUMNS.length) {
            this.buttons[i].setSelection(allSelectedMap.get(i).booleanValue());
            ++i;
        }
        super.performDefaults();
    }

    protected void performApply() {
        this.save();
    }

    public boolean performOk() {
        return this.save();
    }

    private boolean save() {
        this.columnPreference.setSelectedValues(new ArrayList());
        this.columnPreference.setOtherValues(new ArrayList());
        int columnNumber = 0;
        Button[] buttonArray = this.buttons;
        int n = this.buttons.length;
        int n2 = 0;
        while (n2 < n) {
            Button button = buttonArray[n2];
            columnNumber = CollaboratorTableColumn.getColumnNumber(button.getText());
            if (button.getSelection()) {
                this.columnPreference.addSelectedValue(columnNumber);
            } else {
                this.columnPreference.addOtherValue(columnNumber);
            }
            ++n2;
        }
        return this.columnPreference.savePreference();
    }
}

