/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.projectexplorer.handler;

import java.io.File;
import javax.inject.Named;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Display;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.io.ProjectDetailsHandler;
import org.grits.toolbox.core.datamodel.io.ProjectFileHandler;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.datamodel.property.WorkspaceProperty;
import org.grits.toolbox.core.datamodel.property.project.ProjectDetails;
import org.grits.toolbox.core.service.IGritsDataModelService;
import org.grits.toolbox.core.service.IGritsUIService;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.core.utilShare.validator.EntryNameValidator;
import org.grits.toolbox.core.utils.WorkspaceXMLHandler;

public class RenameEntryHandler {
    private static final Logger logger = Logger.getLogger(RenameEntryHandler.class);

    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") Object object, EHandlerService handlerService, ECommandService commandService, EPartService partService, IGritsDataModelService gritsDataModelService, IGritsUIService gritsUIService) {
        logger.info((Object)"- START COMMAND : Rename entry");
        if (object instanceof Entry) {
            String newName;
            Entry selectedEntry = (Entry)object;
            InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), "Rename Entry", "Give a unique name to this entry.", selectedEntry.getDisplayName(), (IInputValidator)new EntryNameValidator(selectedEntry));
            if (dialog.open() == 0 && !(newName = dialog.getValue().trim()).equals(selectedEntry.getDisplayName())) {
                boolean needToReopen = false;
                MPartDescriptor partDescriptor = gritsUIService.findPartDescriptorForEntry(selectedEntry);
                if (partDescriptor != null) {
                    MPart part = gritsUIService.findPartForEntry(selectedEntry);
                    needToReopen = part != null && part.getObject() != null && part.isVisible();
                    partService.hidePart(part);
                    this.closeChildEntries(selectedEntry, partService, gritsUIService);
                }
                if (this.renameEntry(gritsDataModelService, selectedEntry, newName) && needToReopen) {
                    handlerService.executeHandler(commandService.createCommand("org.grits.toolbox.core.command.projectexplorer.entry.view", null));
                }
            }
        }
    }

    private void closeChildEntries(Entry selectedEntry, EPartService partService, IGritsUIService gritsUIService) {
        for (MPart part : partService.getParts()) {
            Entry child;
            if (!part.isVisible() || (child = (Entry)part.getTransientData().get("org.grits.toolbox.entry.current")) == null || !this.checkIfParent(selectedEntry.getProperty(), child.getProperty())) continue;
            partService.hidePart(part);
        }
    }

    private boolean checkIfParent(Property selectedProp, Property child) {
        Property parentProperty = child.getParentProperty();
        if (parentProperty != null && parentProperty.equals(selectedProp)) {
            return true;
        }
        if (parentProperty != null) {
            return this.checkIfParent(selectedProp, parentProperty);
        }
        return false;
    }

    private boolean renameEntry(IGritsDataModelService gritsDataModelService, Entry entry, String newName) {
        block10: {
            logger.debug((Object)("Renaming entry " + entry.getDisplayName()));
            String workspaceLocation = ((WorkspaceProperty)gritsDataModelService.getRootEntry().getProperty()).getLocation();
            workspaceLocation = workspaceLocation.substring(0, workspaceLocation.length() - 1);
            if (entry.getProperty().getType().equals("org.grits.toolbox.property.project")) {
                try {
                    File workspaceFolder = new File(workspaceLocation);
                    if (!workspaceFolder.exists() || !workspaceFolder.isDirectory()) break block10;
                    File fileToBeRenamed = null;
                    File[] fileArray = workspaceFolder.listFiles();
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File child = fileArray[n2];
                        logger.debug((Object)("Matching with " + child.getName()));
                        if (child.isDirectory() && child.getName().equals(entry.getDisplayName())) {
                            fileToBeRenamed = child;
                            break;
                        }
                        ++n2;
                    }
                    if (fileToBeRenamed == null) break block10;
                    fileToBeRenamed.renameTo(new File(workspaceFolder, newName));
                    WorkspaceXMLHandler.renameEntry(entry, newName);
                    gritsDataModelService.renameEntry(entry, newName);
                    try {
                        ProjectDetails projectDetails = ProjectDetailsHandler.getProjectDetails(entry);
                        if (!projectDetails.getEntryName().equals(newName)) {
                            projectDetails.setEntryName(newName);
                            ProjectDetailsHandler.writeProjectDetails(projectDetails);
                        }
                        ProjectFileHandler.saveProject(entry);
                        break block10;
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        ErrorUtils.createErrorMessageBox(Display.getCurrent().getActiveShell(), "Unable to update project_details.xml file with the new project name", e);
                        return false;
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    ErrorUtils.createErrorMessageBox(Display.getCurrent().getActiveShell(), "Unable to update workspace file", e);
                    return false;
                }
            }
            try {
                ProjectFileHandler.renameEntryInProject(entry, newName);
                gritsDataModelService.renameEntry(entry, newName);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                ErrorUtils.createErrorMessageBox(Display.getCurrent().getActiveShell(), "Unable to update project xml", e);
                return false;
            }
        }
        logger.debug((Object)("Renamed entry " + entry.getDisplayName()));
        return true;
    }

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") Object object) {
        return object instanceof Entry && ((Entry)object).getProperty().isRenamable();
    }
}

