/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.utilShare.validator;

import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.swt.graphics.Image;

public class IntegerValidator
implements ICellEditorValidator {
    private static final String INVALID_MESSAGE = "Not an Integer Value";
    private ControlDecoration controlDecoration;

    public IntegerValidator(ControlDecoration controlDecoration) {
        this.controlDecoration = controlDecoration;
        Image errorImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
        this.controlDecoration.setMarginWidth(2);
        this.controlDecoration.setImage(errorImage);
        this.controlDecoration.setDescriptionText(INVALID_MESSAGE);
    }

    public String isValid(Object value) {
        String stringValue;
        String inValidMessage = null;
        this.controlDecoration.hide();
        if (value != null && !(stringValue = (String)value).isEmpty()) {
            try {
                Integer.parseInt(stringValue);
            }
            catch (NumberFormatException numberFormatException) {
                inValidMessage = INVALID_MESSAGE;
                this.controlDecoration.show();
            }
        }
        return inValidMessage;
    }
}

