/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.jrap.grits.stax;

import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.systemsbiology.jrap.grits.stax.Base64;
import org.systemsbiology.jrap.grits.stax.Scan;
import org.systemsbiology.jrap.grits.stax.ScanHeader;

public class MLScanAndHeaderParser {
    public ScanHeader tmpScanHeader;
    public Scan tmpScan;
    FileInputStream fileIN = null;
    boolean isScan = false;

    public void setIsScan(boolean isScan) {
        this.isScan = isScan;
    }

    public void setFileInputStream(FileInputStream in) {
        try {
            this.fileIN = in;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ScanHeader getHeader() {
        return this.tmpScanHeader;
    }

    public Scan getScan() {
        return this.tmpScan;
    }

    protected int parseScanNumberFromSpectrumIdField(String idString) {
        if (idString.contains("scan=")) {
            idString = idString.substring(idString.indexOf("scan=") + "scan=".length());
        }
        if (idString.contains(" ")) {
            idString = idString.substring(0, idString.indexOf(" "));
        }
        return Integer.parseInt(idString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseMLScanAndHeader() {
        XMLStreamReader xmlSR = null;
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            xmlSR = inputFactory.createXMLStreamReader(this.fileIN, "ISO-8859-1");
            this.parseMLScanAndHeader(xmlSR);
        }
        catch (Exception e) {
            String exception1 = e.getMessage();
            if (exception1 != null && !exception1.equals("ScanHeaderEndFoundException") && !exception1.equals("ScanEndFoundException")) {
                e.printStackTrace();
            }
        }
        finally {
            if (xmlSR != null) {
                try {
                    xmlSR.close();
                }
                catch (XMLStreamException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void parseMLScanAndHeader(XMLStreamReader xmlSR) throws XMLStreamException {
        boolean inSpectrum = false;
        boolean inPeaks = false;
        boolean isPeaks = false;
        boolean isPrecursor = false;
        String elementName = null;
        String attriName = null;
        Object attriValue = null;
        StringBuffer peaksBuffer = null;
        int count = 0;
        Map<String, String> mActivationMethods = this.getActivationMethodTypes();
        while (xmlSR.hasNext()) {
            int event = xmlSR.next();
            if (event == 1) {
                elementName = xmlSR.getLocalName();
                if (elementName.equals("spectrum")) {
                    inSpectrum = true;
                    count = 0;
                    this.tmpScanHeader = new ScanHeader();
                    int scan = -1;
                    try {
                        scan = this.parseScanNumberFromSpectrumIdField(this.getStringValue(xmlSR, "id"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (scan < 0) {
                        try {
                            scan = Integer.parseInt(this.getStringValue(xmlSR, "index")) + 1;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.tmpScanHeader.setNum(scan);
                    this.tmpScanHeader.setPeaksCount(this.getIntValue(xmlSR, "defaultArrayLength"));
                }
                if (elementName.equals("precursor")) {
                    int inx;
                    this.tmpScanHeader.setPrecursorScanNum(-1);
                    isPrecursor = true;
                    String sSpectrumRef = xmlSR.getAttributeValue(null, "spectrumRef");
                    if (sSpectrumRef != null && (inx = sSpectrumRef.indexOf("scan=")) > 0) {
                        String sPreScan = sSpectrumRef.substring(inx + 5);
                        try {
                            this.tmpScanHeader.setPrecursorScanNum(Integer.parseInt(sPreScan));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
                if (elementName.equals("cvParam")) {
                    attriName = xmlSR.getAttributeValue(null, "name");
                    String attriAccession = xmlSR.getAttributeValue(null, "accession");
                    if (inSpectrum) {
                        if (attriAccession.equals("MS:1000511")) {
                            this.tmpScanHeader.setMsLevel(this.getIntValue(xmlSR, "value"));
                        }
                        if (attriAccession.equals("MS:1000127")) {
                            this.tmpScanHeader.setCentroided(1);
                        }
                        if (attriAccession.equals("MS:1000504")) {
                            this.tmpScanHeader.setBasePeakMz(this.getFloatValue(xmlSR, "value"));
                        }
                        if (attriAccession.equals("MS:1000505")) {
                            this.tmpScanHeader.setBasePeakIntensity(this.getFloatValue(xmlSR, "value"));
                        }
                        if (attriAccession.equals("MS:1000285")) {
                            this.tmpScanHeader.setTotIonCurrent(this.getFloatValue(xmlSR, "value"));
                        }
                        if (attriAccession.equals("MS:1000528")) {
                            this.tmpScanHeader.setStartMz(this.getFloatValue(xmlSR, "value"));
                        }
                        if (attriAccession.equals("MS:1000527")) {
                            this.tmpScanHeader.setEndMz(this.getFloatValue(xmlSR, "value"));
                        }
                        if (attriAccession.equals("MS:1000501")) {
                            this.tmpScanHeader.setLowMz(this.getFloatValue(xmlSR, "value"));
                        }
                        if (attriAccession.equals("MS:1000500")) {
                            this.tmpScanHeader.setHighMz(this.getFloatValue(xmlSR, "value"));
                        }
                        if (attriAccession.equals("MS:1000512")) {
                            this.tmpScanHeader.setFilterLine(this.getStringValue(xmlSR, "value"));
                        }
                        if (attriAccession.equals("MS:1000498")) {
                            this.tmpScanHeader.setScanType("full scan");
                        }
                        if (attriAccession.equals("MS:1000130")) {
                            this.tmpScanHeader.setPolarity("+");
                        }
                        if (attriAccession.equals("MS:1000016")) {
                            String timeType = xmlSR.getAttributeValue(null, "unitName");
                            double rt = Double.parseDouble(xmlSR.getAttributeValue(null, "value"));
                            if (timeType.equals("minute")) {
                                rt *= 60.0;
                            }
                            this.tmpScanHeader.setRT(rt);
                            this.tmpScanHeader.setRetentionTime("PT" + rt + "S");
                        }
                        if (attriAccession.equals("MS:1000827") || attriAccession.equals("MS:1000744")) {
                            String sVal = xmlSR.getAttributeValue(null, "value");
                            float fVal = -1.0f;
                            if (sVal.contains(" ")) {
                                try {
                                    String[] sToks = sVal.split(" ");
                                    fVal = Float.parseFloat(sToks[0]);
                                }
                                catch (NumberFormatException ex) {
                                    ex.printStackTrace();
                                }
                            } else {
                                fVal = this.getFloatValue(xmlSR, "value");
                            }
                            this.tmpScanHeader.setPrecursorMz(fVal);
                        }
                        if (attriAccession.equals("MS:1000042")) {
                            this.tmpScanHeader.setPrecursorIntensity(this.getFloatValue(xmlSR, "value"));
                        }
                        if (attriAccession.equals("MS:1000041")) {
                            this.tmpScanHeader.setPrecursorCharge(this.getIntValue(xmlSR, "value"));
                        }
                        if (attriAccession.equals("MS:1000045")) {
                            this.tmpScanHeader.setCollisionEnergy(this.getFloatValue(xmlSR, "value"));
                        }
                        if (mActivationMethods.containsKey(attriAccession)) {
                            String sActivationMethod = mActivationMethods.get(attriAccession);
                            this.tmpScanHeader.setActivationMethod(sActivationMethod);
                        }
                    }
                    if (inPeaks) {
                        if (attriAccession.equals("MS:1000523")) {
                            if (count == 1) {
                                this.tmpScanHeader.setMassPrecision(64);
                            }
                            if (count == 2) {
                                this.tmpScanHeader.setIntenPrecision(64);
                            }
                        }
                        if (attriAccession.equals("MS:1000521")) {
                            if (count == 1) {
                                this.tmpScanHeader.setMassPrecision(32);
                            }
                            if (count == 2) {
                                this.tmpScanHeader.setIntenPrecision(32);
                            }
                        }
                        if (attriAccession.equals("MS:1000576")) {
                            if (count == 1) {
                                this.tmpScanHeader.setMassCompressionType("None");
                            }
                            if (count == 2) {
                                this.tmpScanHeader.setIntenCompressionType("None");
                            }
                        }
                        if (attriAccession.equals("MS:1000574")) {
                            if (count == 1) {
                                this.tmpScanHeader.setMassCompressionType("zlib");
                            }
                            if (count == 2) {
                                this.tmpScanHeader.setIntenCompressionType("zlib");
                            }
                        }
                    }
                }
                if (elementName.equals("binaryDataArrayList")) {
                    if (this.isScan) {
                        this.tmpScan = new Scan();
                        this.tmpScan.setHeader(this.tmpScanHeader);
                    } else {
                        throw new XMLStreamException("ScanHeaderEndFoundException");
                    }
                }
                if (elementName.equals("binaryDataArray")) {
                    inPeaks = true;
                    if (++count == 1) {
                        this.tmpScanHeader.setMassCompressedLen(this.getIntValue(xmlSR, "encodedLength"));
                    }
                    if (count == 2) {
                        this.tmpScanHeader.setIntenCompressedLen(this.getIntValue(xmlSR, "encodedLength"));
                    }
                }
                if (elementName.equals("binary")) {
                    inPeaks = false;
                    isPeaks = true;
                    peaksBuffer = new StringBuffer();
                }
            }
            if (event == 4 && isPeaks) {
                peaksBuffer.append(xmlSR.getText());
            }
            if (event != 2) continue;
            elementName = xmlSR.getLocalName();
            if (elementName.equals("spectrumDescription")) {
                inSpectrum = false;
            }
            if (elementName.equals("binary")) {
                this.getPeaks(peaksBuffer.toString(), count);
                isPeaks = false;
                peaksBuffer = null;
            }
            if (!elementName.equals("binaryDataArrayList")) continue;
            throw new XMLStreamException("ScanEndFoundException");
        }
    }

    public String getStringValue(XMLStreamReader xmlSR, String name) {
        String value = "";
        try {
            value = xmlSR.getAttributeValue(null, name) == null ? "" : xmlSR.getAttributeValue(null, name);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    public int getIntValue(XMLStreamReader xmlSR, String name) {
        int value = -1;
        try {
            value = xmlSR.getAttributeValue(null, name) == null ? -1 : Integer.parseInt(xmlSR.getAttributeValue(null, name));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    public float getFloatValue(XMLStreamReader xmlSR, String name) {
        float value = -1.0f;
        try {
            value = xmlSR.getAttributeValue(null, name) == null ? -1.0f : Float.parseFloat(xmlSR.getAttributeValue(null, name));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    public void getPeaks(String peakData, int count) {
        byte[] peakArray;
        int precision = -1;
        if (count == 1) {
            precision = this.tmpScanHeader.getMassPrecision();
        }
        if (count == 2) {
            precision = this.tmpScanHeader.getIntenPrecision();
        }
        byte[] outPeakArray = peakArray = peakData.getBytes();
        int outpos = Base64.decode(peakArray, 0, peakArray.length, outPeakArray);
        double[] doubleMassList = null;
        double[] doubleIntenList = null;
        ByteBuffer peakBuffer = null;
        byte[] result = null;
        int unCompLen = outpos;
        String compressType = "None";
        if (count == 1) {
            compressType = this.tmpScanHeader.getMassCompressionType();
        }
        if (count == 2) {
            compressType = this.tmpScanHeader.getIntenCompressionType();
        }
        if (compressType.equals("zlib")) {
            try {
                Inflater decompresser = new Inflater();
                decompresser.setInput(outPeakArray, 0, outpos);
                unCompLen = this.tmpScanHeader.getPeaksCount() * (precision / 4);
                result = new byte[unCompLen];
                decompresser.inflate(result);
                decompresser.end();
            }
            catch (DataFormatException e) {
                e.printStackTrace();
            }
            peakBuffer = ByteBuffer.wrap(result);
            peakBuffer.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            peakBuffer = ByteBuffer.wrap(outPeakArray, 0, outpos);
            peakBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        if (precision == 64) {
            if (count == 1) {
                doubleMassList = new double[unCompLen / 8];
                int i = 0;
                while (peakBuffer.hasRemaining()) {
                    doubleMassList[i] = peakBuffer.getDouble();
                    ++i;
                }
                this.tmpScan.setDoubleMassList(doubleMassList);
            }
            if (count == 2) {
                doubleIntenList = new double[unCompLen / 8];
                int i = 0;
                while (peakBuffer.hasRemaining()) {
                    doubleIntenList[i] = peakBuffer.getDouble();
                    ++i;
                }
                this.tmpScan.setDoubleIntensityList(doubleIntenList);
            }
        } else {
            if (count == 1) {
                doubleMassList = new double[unCompLen / 4];
                int i = 0;
                while (peakBuffer.hasRemaining()) {
                    doubleMassList[i] = peakBuffer.getFloat();
                    ++i;
                }
                this.tmpScan.setDoubleMassList(doubleMassList);
            }
            if (count == 2) {
                doubleIntenList = new double[unCompLen / 4];
                int i = 0;
                while (peakBuffer.hasRemaining()) {
                    doubleIntenList[i] = peakBuffer.getFloat();
                    ++i;
                }
                this.tmpScan.setDoubleIntensityList(doubleIntenList);
            }
        }
        if (count == 2) {
            double[][] massIntensityList = new double[][]{this.tmpScan.getDoubleMassList(), this.tmpScan.getDoubleIntensityList()};
            this.tmpScan.setMassIntensityList(massIntensityList);
        }
    }

    protected Map<String, String> getActivationMethodTypes() {
        HashMap<String, String> mActivationTypes = new HashMap<String, String>();
        mActivationTypes.put("MS:1000133", "collision-induced dissociation");
        mActivationTypes.put("MS:1000134", "plasma desorption");
        mActivationTypes.put("MS:1000135", "post-source decay");
        mActivationTypes.put("MS:1000136", "surface-induced dissociation");
        mActivationTypes.put("MS:1000242", "blackbody infrared radiative dissociation");
        mActivationTypes.put("MS:1000250", "electron capture dissociation");
        mActivationTypes.put("MS:1000262", "infrared multiphoton dissociation");
        mActivationTypes.put("MS:1000282", "sustained off-resonance irradiation");
        mActivationTypes.put("MS:1000422", "high-energy collision-induced dissociation");
        mActivationTypes.put("MS:1000433", "low-energy collision-induced dissociation");
        return mActivationTypes;
    }
}

