/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.monosaccharide;

import java.util.ArrayList;
import java.util.List;
import org.eurocarbdb.resourcesdb.GlycanNamescheme;
import org.eurocarbdb.resourcesdb.ResourcesDbException;
import org.eurocarbdb.resourcesdb.ResourcesDbObject;
import org.eurocarbdb.resourcesdb.io.MonosaccharideExchangeObject;
import org.eurocarbdb.resourcesdb.io.SubstituentExchangeObject;
import org.eurocarbdb.resourcesdb.monosaccharide.Substitution;

public class MonosaccharideSynonym
extends ResourcesDbObject {
    private int msId;
    private GlycanNamescheme namescheme;
    private String name;
    private boolean isPrimary;
    private boolean isTrivialName;
    private int synonymDbId;
    private List<Substitution> externalSubstList;

    public MonosaccharideSynonym() {
        this.init();
    }

    public MonosaccharideSynonym(GlycanNamescheme scheme) {
        this.init();
        this.setNamescheme(scheme);
    }

    public MonosaccharideSynonym(GlycanNamescheme scheme, String nameStr) {
        this.init();
        this.setNamescheme(scheme);
        this.setName(nameStr);
    }

    public MonosaccharideSynonym(GlycanNamescheme scheme, String nameStr, boolean isPrimary) {
        this.init();
        this.setNamescheme(scheme);
        this.setName(nameStr);
        this.setIsPrimary(isPrimary);
    }

    public MonosaccharideSynonym(MonosaccharideExchangeObject msObj) throws ResourcesDbException {
        this.setConfig(msObj.getConfig());
        this.setTemplateContainer(msObj.getTemplateContainer());
        this.init();
        this.setNamescheme(msObj.getMonosaccharideNamescheme());
        this.setName(msObj.getMonosaccharideName());
        for (SubstituentExchangeObject substEx : msObj.getSubstituents()) {
            Substitution subst = new Substitution(substEx, msObj.getTemplateContainer());
            subst.setNameWithoutTemplateAdjustment(substEx.getName());
            this.addExternalSubst(subst);
        }
    }

    public boolean isPrimary() {
        return this.getIsPrimary();
    }

    public boolean getIsPrimary() {
        return this.isPrimary;
    }

    public void setIsPrimary(boolean isPrimary) {
        this.isPrimary = isPrimary;
    }

    public boolean isTrivialName() {
        return this.getIsTrivialName();
    }

    public boolean getIsTrivialName() {
        return this.isTrivialName;
    }

    public void setIsTrivialName(boolean isTrivialName) {
        this.isTrivialName = isTrivialName;
    }

    public int getMsId() {
        return this.msId;
    }

    public void setMsId(int msId) {
        this.msId = msId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public GlycanNamescheme getNamescheme() {
        return this.namescheme;
    }

    public void setNamescheme(GlycanNamescheme namescheme) {
        this.namescheme = namescheme;
    }

    public String getNameschemeStr() {
        if (this.getNamescheme() == null) {
            return null;
        }
        return this.getNamescheme().name();
    }

    public void setNameschemeStr(String name) {
        if (name == null) {
            this.setNamescheme(null);
        } else {
            this.setNamescheme(GlycanNamescheme.forName(name));
        }
    }

    public int getSynonymDbId() {
        return this.synonymDbId;
    }

    public void setSynonymDbId(int synonymDbId) {
        this.synonymDbId = synonymDbId;
    }

    public List<Substitution> getExternalSubstList() {
        if (this.externalSubstList == null) {
            this.externalSubstList = new ArrayList<Substitution>();
        }
        return this.externalSubstList;
    }

    public void setExternalSubstList(List<Substitution> externalSubstList) {
        this.externalSubstList = externalSubstList;
    }

    public void addExternalSubst(Substitution subst) {
        this.getExternalSubstList().add(subst);
    }

    public void init() {
        this.setMsId(0);
        this.setIsPrimary(true);
        this.setIsTrivialName(false);
        this.setName(null);
        this.setNamescheme(null);
        this.setExternalSubstList(new ArrayList<Substitution>());
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!o.getClass().equals(MonosaccharideSynonym.class)) {
            return false;
        }
        MonosaccharideSynonym testAlias = (MonosaccharideSynonym)o;
        if (testAlias.isPrimary() != this.isPrimary()) {
            return false;
        }
        if (testAlias.isTrivialName() != this.isTrivialName()) {
            return false;
        }
        return this.equalsIgnoreBooleans(testAlias);
    }

    public boolean equalsIgnoreBooleans(Object o) {
        if (o == null) {
            return false;
        }
        if (!o.getClass().equals(MonosaccharideSynonym.class)) {
            return false;
        }
        MonosaccharideSynonym testAlias = (MonosaccharideSynonym)o;
        if (!testAlias.getNamescheme().equals((Object)this.getNamescheme())) {
            return false;
        }
        if (this.getNamescheme().isCaseSensitive() ? !testAlias.getName().equals(this.getName()) : !testAlias.getName().equalsIgnoreCase(this.getName())) {
            return false;
        }
        if (this.getExternalSubstList().size() != testAlias.getExternalSubstList().size()) {
            return false;
        }
        for (int i = 0; i < this.getExternalSubstList().size(); ++i) {
            if (this.getExternalSubstList().get(i).equals(testAlias.getExternalSubstList().get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String outStr = this.getNamescheme().getNameStr() + "::" + this.getName();
        outStr = outStr + " subst ";
        outStr = outStr + this.getExternalSubstList().toString();
        if (this.getIsTrivialName()) {
            outStr = outStr + " (trivial name)";
        }
        if (this.getIsPrimary()) {
            outStr = outStr + " (primary)";
        }
        return outStr;
    }
}

