/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.actions;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;
import org.grits.toolbox.editor.experimentdesigner.actions.AddParameterGroupAction;
import org.grits.toolbox.editor.experimentdesigner.editor.GraphEditor;
import org.grits.toolbox.editor.experimentdesigner.model.EntityWithPosition;
import org.grits.toolbox.editor.experimentdesigner.model.Parameter;
import org.grits.toolbox.editor.experimentdesigner.model.ProtocolNode;
import org.grits.toolbox.editor.experimentdesigner.ontology.ExperimentDesignOntologyAPI;
import org.grits.toolbox.editor.experimentdesigner.views.ParameterView;

public class AddParameterAction {
    private static Logger logger = Logger.getLogger(AddParameterAction.class);
    Parameter parameter;
    boolean isRequired = false;
    @Inject
    IEventBroker eventBroker;
    GraphEditor editor;

    @Execute
    public void run(@Named(value="activeShell") Shell shell, MApplication application, MPart protocolPart) {
        if (protocolPart != null && protocolPart.getObject() != null) {
            ProtocolNode protocol = ((ParameterView)protocolPart.getObject()).getProtocol();
            if (protocol == null) {
                return;
            }
            this.editor = (GraphEditor)((Object)application.getContext().get(GraphEditor.class));
            if (this.editor == null) {
                logger.error((Object)"Cannot get the reference to Graph Editor");
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Update Error", (String)"Cannot get the reference to Graph Editor");
                return;
            }
            TreeViewer treeViewer = ((ParameterView)protocolPart.getObject()).getTreeViewer();
            try {
                ExperimentDesignOntologyAPI ontologyAPI = new ExperimentDesignOntologyAPI();
                List<Parameter> parameters = ontologyAPI.getAllParameters();
                ListDialog dialog = new ListDialog(shell){

                    protected Control createDialogArea(Composite container) {
                        Composite parent = (Composite)super.createDialogArea(container);
                        Composite newContainer = new Composite(parent, 0);
                        newContainer.setLayout((Layout)new GridLayout(2, false));
                        GridData gd = new GridData(4, 0, false, false);
                        Label label = new Label(newContainer, 0);
                        label.setText("Required?");
                        label.setLayoutData((Object)gd);
                        gd = new GridData(4, 0, true, false);
                        final Button required = new Button(newContainer, 32);
                        required.addSelectionListener(new SelectionListener(){

                            public void widgetSelected(SelectionEvent e) {
                                (this).AddParameterAction.this.isRequired = required.getSelection();
                            }

                            public void widgetDefaultSelected(SelectionEvent e) {
                            }
                        });
                        required.setText("");
                        required.setSelection(false);
                        required.setLayoutData((Object)gd);
                        return parent;
                    }
                };
                dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
                dialog.setTitle("Parameter Selection");
                dialog.setLabelProvider((ILabelProvider)new AddParameterGroupAction.ArrayLabelProvider(){

                    @Override
                    public String getText(Object element) {
                        return ((Parameter)element).getName();
                    }

                    @Override
                    public String getColumnText(Object element, int columnIndex) {
                        return ((Parameter)element).getName();
                    }
                });
                dialog.setInput(parameters);
                if (dialog.open() == 0) {
                    Object[] result = dialog.getResult();
                    int i = 0;
                    while (i < result.length) {
                        this.parameter = (Parameter)result[i];
                        this.parameter.setRequired(this.isRequired);
                        ArrayList<EntityWithPosition> paramsAndParamGroups = new ArrayList<EntityWithPosition>();
                        List<Parameter> existingParameters = protocol.getParameters();
                        if (existingParameters != null) {
                            if (existingParameters.contains(this.parameter)) {
                                return;
                            }
                            existingParameters.add(this.parameter);
                            paramsAndParamGroups.addAll(existingParameters);
                        } else {
                            ArrayList<Parameter> newParameters = new ArrayList<Parameter>();
                            newParameters.add(this.parameter);
                            protocol.setParameters(newParameters);
                            paramsAndParamGroups.addAll(newParameters);
                        }
                        if (protocol.getParameterGroups() != null) {
                            paramsAndParamGroups.addAll(protocol.getParameterGroups());
                        }
                        treeViewer.setInput(paramsAndParamGroups);
                        treeViewer.refresh();
                        treeViewer.expandAll();
                        protocol.setTemplateChanged(true);
                        this.eventBroker.post("EventTopic_EventPart_Modified", (Object)protocol);
                        this.editor.refreshProtocolNode(protocol);
                        ++i;
                    }
                }
                this.isRequired = false;
            }
            catch (Exception e) {
                logger.error((Object)"org.grits.toolbox.editor.experimentdesigner Error getting available parameters from the ontology", (Throwable)e);
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)"Error getting available parameters from the ontology");
            }
        }
    }
}

