/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.commands;

import org.eclipse.gef.commands.Command;
import org.grits.toolbox.editor.experimentdesigner.model.Connection;
import org.grits.toolbox.editor.experimentdesigner.model.GraphNode;
import org.grits.toolbox.editor.experimentdesigner.model.InputNode;
import org.grits.toolbox.editor.experimentdesigner.model.OutputNode;

public class ConnectionReconnectCommand
extends Command {
    private Connection connection;
    private GraphNode newSource;
    private GraphNode newTarget;
    private final GraphNode oldSource;
    private final GraphNode oldTarget;

    public ConnectionReconnectCommand(Connection conn) {
        if (conn == null) {
            throw new IllegalArgumentException();
        }
        this.connection = conn;
        this.oldSource = conn.getSource();
        this.oldTarget = conn.getTarget();
    }

    public boolean canExecute() {
        if (this.newSource != null) {
            if (this.newSource instanceof OutputNode) {
                return false;
            }
            return this.checkSourceReconnection();
        }
        if (this.newTarget != null) {
            if (this.newTarget instanceof InputNode) {
                return false;
            }
            return this.checkTargetReconnection();
        }
        return false;
    }

    boolean isConnected(GraphNode t, GraphNode s) {
        boolean connected = false;
        if (t != null && t.getSourceConnections() != null) {
            for (Connection conn : t.getSourceConnections()) {
                if (conn.getTarget().equals(s)) {
                    return true;
                }
                if (conn.getTarget() != null && (connected = this.isConnected(conn.getTarget(), s))) break;
            }
        }
        return connected;
    }

    private boolean checkSourceReconnection() {
        if (this.newSource.equals(this.oldTarget)) {
            return false;
        }
        for (Connection conn : this.newSource.getSourceConnections()) {
            if (!conn.getTarget().equals(this.oldTarget) || conn.equals(this.connection)) continue;
            return false;
        }
        return !this.isConnected(this.oldTarget, this.newSource);
    }

    private boolean checkTargetReconnection() {
        if (this.newTarget.equals(this.oldSource)) {
            return false;
        }
        for (Connection conn : this.newTarget.getTargetConnections()) {
            if (!conn.getSource().equals(this.oldSource) || conn.equals(this.connection)) continue;
            return false;
        }
        return !this.isConnected(this.newTarget, this.oldSource);
    }

    public void execute() {
        if (this.newSource != null) {
            this.connection.reconnect(this.newSource, this.oldTarget);
        } else if (this.newTarget != null) {
            this.connection.reconnect(this.oldSource, this.newTarget);
        } else {
            throw new IllegalStateException("Should not happen");
        }
    }

    public void setNewSource(GraphNode connectionSource) {
        if (connectionSource == null) {
            throw new IllegalArgumentException();
        }
        this.setLabel("move connection startpoint");
        this.newSource = connectionSource;
        this.newTarget = null;
    }

    public void setNewTarget(GraphNode connectionTarget) {
        if (connectionTarget == null) {
            throw new IllegalArgumentException();
        }
        this.setLabel("move connection endpoint");
        this.newSource = null;
        this.newTarget = connectionTarget;
    }

    public void undo() {
        this.connection.reconnect(this.oldSource, this.oldTarget);
    }
}

