/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.mem.HashCommon;
import com.hp.hpl.jena.mem.TripleBunch;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import java.util.ConcurrentModificationException;

public class ArrayBunch
implements TripleBunch {
    protected int size = 0;
    protected Triple[] elements = new Triple[5];
    protected volatile int changes = 0;

    @Override
    public boolean containsBySameValueAs(Triple t) {
        int i = this.size;
        while (i > 0) {
            if (!t.matches(this.elements[--i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Triple t) {
        int i = this.size;
        while (i > 0) {
            if (!t.equals(this.elements[--i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void add(Triple t) {
        if (this.size == this.elements.length) {
            this.grow();
        }
        this.elements[this.size++] = t;
        ++this.changes;
    }

    protected void grow() {
        Triple[] newElements = new Triple[this.size + 4];
        System.arraycopy(this.elements, 0, newElements, 0, this.size);
        this.elements = newElements;
    }

    @Override
    public void remove(Triple t) {
        ++this.changes;
        for (int i = 0; i < this.size; ++i) {
            if (!t.equals(this.elements[i])) continue;
            this.elements[i] = this.elements[--this.size];
            return;
        }
    }

    @Override
    public ExtendedIterator<Triple> iterator() {
        return this.iterator(new HashCommon.NotifyEmpty(){

            @Override
            public void emptied() {
            }
        });
    }

    @Override
    public ExtendedIterator<Triple> iterator(final HashCommon.NotifyEmpty container) {
        return new NiceIterator<Triple>(){
            protected final int initialChanges;
            protected int i;
            protected final Triple[] e;
            {
                this.initialChanges = ArrayBunch.this.changes;
                this.i = ArrayBunch.this.size;
                this.e = ArrayBunch.this.elements;
            }

            @Override
            public boolean hasNext() {
                if (ArrayBunch.this.changes > this.initialChanges) {
                    throw new ConcurrentModificationException();
                }
                return this.i > 0;
            }

            @Override
            public Triple next() {
                if (ArrayBunch.this.changes > this.initialChanges) {
                    throw new ConcurrentModificationException();
                }
                if (this.i == 0) {
                    this.noElements("no elements left in ArrayBunch iteration");
                }
                return this.e[--this.i];
            }

            @Override
            public void remove() {
                if (ArrayBunch.this.changes > this.initialChanges) {
                    throw new ConcurrentModificationException();
                }
                int last = --ArrayBunch.this.size;
                this.e[this.i] = this.e[last];
                this.e[last] = null;
                if (ArrayBunch.this.size == 0) {
                    container.emptied();
                }
            }
        };
    }
}

