/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import org.eurocarbdb.application.glycanbuilder.CoreType;
import org.eurocarbdb.application.glycanbuilder.GWSParser;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.MassOptions;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.ResidueDictionary;
import org.eurocarbdb.application.glycanbuilder.TextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreDictionary {
    private static TreeMap<String, CoreType> dictionary = new TreeMap();
    private static Vector<String> superclasses = new Vector();
    private static Vector<CoreType> all_cores = new Vector();
    private static HashMap<String, Vector<CoreType>> all_cores_map = new HashMap();

    public static CoreType getCoreType(String type_name) throws Exception {
        if (dictionary.containsKey(type_name)) {
            return dictionary.get(type_name);
        }
        throw new Exception("Invalid type: <" + type_name + ">");
    }

    public static Iterator<CoreType> iterator() {
        return all_cores.iterator();
    }

    public static Collection<String> getSuperclasses() {
        return superclasses;
    }

    public static Collection<CoreType> getCores() {
        return all_cores;
    }

    public static Collection<CoreType> getCores(String superclass) {
        return all_cores_map.get(superclass);
    }

    public static Residue newCore(String type_name) throws Exception {
        return CoreDictionary.getCoreType(type_name).newCore();
    }

    public static Glycan newStructure(String type_name, MassOptions mass_opt) throws Exception {
        return new GWSParser().readGlycan(CoreDictionary.getCoreType(type_name).getStructure(), mass_opt);
    }

    private CoreDictionary() {
    }

    public static void loadDictionary(String filename) {
        dictionary.clear();
        superclasses.clear();
        all_cores.clear();
        all_cores_map.clear();
        try {
            String line;
            BufferedReader is;
            if (filename.startsWith("http")) {
                URLConnection conn = new URL(filename).openConnection();
                is = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            } else {
                URL file_url = ResidueDictionary.class.getResource(filename);
                if (file_url == null) {
                    File file = new File(filename);
                    if (!file.exists()) {
                        throw new FileNotFoundException(filename);
                    }
                    is = new BufferedReader(new FileReader(file));
                } else {
                    is = new BufferedReader(new InputStreamReader(file_url.openStream()));
                }
            }
            while ((line = is.readLine()) != null) {
                if ((line = TextUtils.trim(line)).length() <= 0 || line.startsWith("%")) continue;
                CoreType type = new CoreType(line);
                dictionary.put(type.getName(), type);
                CoreDictionary.addSuperclass(type.getSuperclass());
                all_cores.add(type);
                all_cores_map.get(type.getSuperclass()).add(type);
            }
            is.close();
        }
        catch (Exception e) {
            LogUtils.report(e);
            dictionary.clear();
        }
    }

    private static void addSuperclass(String superclass) {
        Iterator<String> i = superclasses.iterator();
        while (i.hasNext()) {
            if (!i.next().equals(superclass)) continue;
            return;
        }
        superclasses.add(superclass);
        all_cores_map.put(superclass, new Vector());
    }
}

