/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;

public class GraphicUtils {
    private GraphicUtils() {
    }

    public static BufferedImage createCompatibleImage(int width, int height, boolean opaque) {
        if (GraphicsEnvironment.isHeadless()) {
            if (opaque) {
                return new BufferedImage(width, height, 1);
            }
            return new BufferedImage(width, height, 2);
        }
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gs = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gs.getDefaultConfiguration();
        if (opaque) {
            return gc.createCompatibleImage(width, height);
        }
        return gc.createCompatibleImage(width, height, 2);
    }

    public static BufferedImage createImage(int width, int height, boolean opaque) {
        if (opaque) {
            return new BufferedImage(width, height, 1);
        }
        return new BufferedImage(width, height, 2);
    }

    public static BufferedImage createImage(Dimension d, boolean opaque) {
        return GraphicUtils.createImage(d.width, d.height, opaque);
    }
}

