/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.awt.Rectangle;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import org.eurocarbdb.application.glycanbuilder.Bond;
import org.eurocarbdb.application.glycanbuilder.Linkage;
import org.eurocarbdb.application.glycanbuilder.ResidueHolder;
import org.eurocarbdb.application.glycanbuilder.ResiduePlacement;
import org.eurocarbdb.application.glycanbuilder.ResidueType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Residue {
    private static int class_id = 0;
    public final int id = class_id++;
    private ResidueType type;
    private char anomeric_state;
    private char anomeric_carbon;
    private char chirality;
    private char ring_size;
    private boolean alditol;
    private Linkage parent_linkage;
    private Vector<Linkage> children_linkages;
    private Residue cleaved_residue = null;
    private ResiduePlacement preferred_placement = null;
    private boolean was_sticky = false;
    private Residue endRepetitionResidue;
    private Residue startRepititionResidue;
    private Rectangle centerPos;

    public Residue() {
        this.type = new ResidueType();
        this.anomeric_state = (char)63;
        this.anomeric_carbon = (char)63;
        this.chirality = (char)63;
        this.ring_size = (char)63;
        this.alditol = false;
        this.parent_linkage = null;
        this.children_linkages = new Vector(0, 1);
    }

    public Residue(ResidueType _type) {
        this.type = _type;
        this.anomeric_state = (char)63;
        this.anomeric_carbon = this.type.getAnomericCarbon();
        this.chirality = this.type.getChirality();
        this.ring_size = this.type.getRingSize();
        this.alditol = false;
        this.parent_linkage = null;
        this.children_linkages = new Vector(0, 1);
    }

    public Residue(ResidueType _type, char _anomeric_state, char _anomeric_carbon, char _chirality, char _ring_size) {
        this.type = _type;
        this.anomeric_state = _anomeric_state;
        this.anomeric_carbon = _anomeric_carbon;
        this.chirality = _chirality;
        this.ring_size = _ring_size;
        this.parent_linkage = null;
        this.children_linkages = new Vector(0, 1);
    }

    public String getTypeName() {
        return this.type.getName();
    }

    public String getResidueName() {
        return this.type.getResidueName();
    }

    public ResidueType getType() {
        return this.type;
    }

    public void setType(ResidueType _type) {
        this.type = _type;
    }

    public String getCleavageType() {
        return this.type.getCleavageType();
    }

    public char getAnomericState() {
        return this.anomeric_state;
    }

    public void setAnomericState(char _anomeric_state) {
        this.anomeric_state = _anomeric_state;
    }

    public boolean hasAnomericState() {
        return this.anomeric_state != '?';
    }

    public char getAnomericCarbon() {
        return this.anomeric_carbon;
    }

    public void setAnomericCarbon(char _anomeric_carbon) {
        this.anomeric_carbon = _anomeric_carbon;
        if (this.parent_linkage != null) {
            this.parent_linkage.setAnomericCarbon(this.anomeric_carbon);
        }
    }

    public boolean hasAnomericCarbon() {
        return this.anomeric_carbon != '?';
    }

    public char getChirality() {
        return this.chirality;
    }

    public void setChirality(char _chirality) {
        this.chirality = _chirality;
    }

    public boolean hasChirality() {
        return this.chirality != '?';
    }

    public char getRingSize() {
        return this.ring_size;
    }

    public void setRingSize(char _ring_size) {
        this.ring_size = _ring_size;
    }

    public boolean hasRingSize() {
        return this.ring_size != '?';
    }

    public void setAlditol(boolean a) {
        this.alditol = a;
    }

    public boolean isAlditol() {
        return this.alditol;
    }

    public int getMaxLinkages() {
        return this.type.getMaxLinkages();
    }

    public boolean isSaccharide() {
        return this.type.isSaccharide();
    }

    public boolean isSubstituent() {
        return this.type.isSubstituent();
    }

    public boolean isCleavable() {
        return this.type.isCleavable();
    }

    public boolean isSpecial() {
        return this.type.isSpecial();
    }

    public boolean isLabile() {
        return this.type.isLabile() && !this.hasChildren();
    }

    public boolean canHaveParent() {
        return this.type.canHaveParent();
    }

    public boolean canHaveChildren() {
        return this.type.canHaveChildren();
    }

    public boolean canBeReducingEnd() {
        return this.type.canBeReducingEnd();
    }

    public boolean isFreeReducingEnd() {
        return this.type.isFreeReducingEnd();
    }

    public boolean isReducingEnd() {
        return this.parent_linkage == null && this.type.canBeReducingEnd();
    }

    public boolean isRepetition() {
        return this.type.isRepetition();
    }

    public boolean isStartRepetition() {
        return this.type.isStartRepetition();
    }

    public boolean isEndRepetition() {
        return this.type.isEndRepetition();
    }

    public int getMinRepetitions() {
        return this.type.getMinRepetitions();
    }

    public void setMinRepetitions(String min) {
        this.type.setMinRepetitions(min);
    }

    public int getMaxRepetitions() {
        return this.type.getMaxRepetitions();
    }

    public void setMaxRepetitions(String max) {
        this.type.setMaxRepetitions(max);
    }

    public boolean isBracket() {
        return this.type.isBracket();
    }

    public boolean isAntenna() {
        if (this.parent_linkage == null) {
            return false;
        }
        if (this.parent_linkage.getParentResidue().isBracket()) {
            return true;
        }
        return this.parent_linkage.getParentResidue().isAntenna();
    }

    public boolean isAttachPoint() {
        return this.type.isAttachPoint();
    }

    public boolean isGlycosidicCleavage() {
        return this.type.isGlycosidicCleavage();
    }

    public boolean isCleavage() {
        return this.type.isCleavage();
    }

    public boolean isLCleavage() {
        return this.type.isLCleavage();
    }

    public boolean isRingFragment() {
        return this.type.isRingFragment();
    }

    public Residue getCleavedResidue() {
        return this.cleaved_residue;
    }

    public void setCleavedResidue(Residue _cleaved_residue) {
        this.cleaved_residue = _cleaved_residue;
    }

    public boolean hasGlycosidicCleavages() {
        for (Linkage l : this.children_linkages) {
            if (!l.getChildResidue().isGlycosidicCleavage()) continue;
            return true;
        }
        Residue parent = this.getParent();
        return parent != null && parent.isGlycosidicCleavage();
    }

    public boolean hasRingFragments() {
        for (Linkage l : this.children_linkages) {
            if (!l.getChildResidue().isRingFragment()) continue;
            return true;
        }
        Residue parent = this.getParent();
        return parent != null && parent.isRingFragment();
    }

    public boolean hasSaccharideChildren() {
        for (Linkage l : this.children_linkages) {
            if (!l.getChildResidue().isSaccharide()) continue;
            return true;
        }
        return false;
    }

    public boolean hasPreferredPlacement() {
        return this.preferred_placement != null;
    }

    public void resetPreferredPlacement() {
        this.preferred_placement = null;
    }

    public void setPreferredPlacement(ResiduePlacement new_place) {
        this.preferred_placement = new_place;
    }

    public ResiduePlacement getPreferredPlacement() {
        return this.preferred_placement;
    }

    public void setWasSticky(boolean flag) {
        this.was_sticky = flag;
    }

    public boolean getWasSticky() {
        return this.was_sticky;
    }

    public void setParentLinkage(Linkage _parent_linkage) {
        this.parent_linkage = _parent_linkage;
    }

    public Linkage getParentLinkage() {
        return this.parent_linkage;
    }

    public Residue getParent() {
        if (this.parent_linkage != null) {
            return this.parent_linkage.getParentResidue();
        }
        return null;
    }

    public Vector<Linkage> getChildrenLinkages() {
        return this.children_linkages;
    }

    public Iterator<Linkage> iterator() {
        return this.children_linkages.iterator();
    }

    public Linkage firstLinkage() {
        return this.children_linkages.size() > 0 ? this.children_linkages.get(0) : null;
    }

    public Residue firstChild() {
        return this.children_linkages.size() > 0 ? this.children_linkages.get(0).getChildResidue() : null;
    }

    public Residue lastChild() {
        return this.children_linkages.size() > 0 ? this.children_linkages.get(this.children_linkages.size() - 1).getChildResidue() : null;
    }

    public Residue firstSaccharideChild() {
        for (Linkage l : this.children_linkages) {
            if (!l.getChildResidue().isSaccharide()) continue;
            return l.getChildResidue();
        }
        return null;
    }

    public Residue getChildAt(int ind) {
        return this.children_linkages.get(ind).getChildResidue();
    }

    public Linkage getLinkageAt(int ind) {
        return this.children_linkages.get(ind);
    }

    public int indexOf(Residue child) {
        if (child == null) {
            return -1;
        }
        for (int i = 0; i < this.children_linkages.size(); ++i) {
            if (this.getChildAt(i) != child) continue;
            return i;
        }
        return -1;
    }

    public boolean hasParent() {
        return this.parent_linkage != null && this.parent_linkage.getParentResidue() != null;
    }

    public boolean hasChildren() {
        return !this.children_linkages.isEmpty();
    }

    public int getNoChildren() {
        return this.children_linkages.size();
    }

    public int getNoSaccharideChildren() {
        int count = 0;
        for (Linkage l : this.children_linkages) {
            if (!l.getChildResidue().isSaccharide()) continue;
            ++count;
        }
        return count;
    }

    public int getNoLinkages() {
        if (this.parent_linkage == null) {
            return this.children_linkages.size();
        }
        return this.children_linkages.size() + 1;
    }

    public int getNoBonds() {
        int ret = 0;
        if (this.parent_linkage != null) {
            ret += this.parent_linkage.getNoBonds();
        }
        for (Linkage l : this.children_linkages) {
            ret += l.getNoBonds();
        }
        return ret;
    }

    protected int countLeftBrothers(Residue sub_root, int depth) {
        Residue parent = this.getParent();
        if (parent == null || this == sub_root) {
            return 0;
        }
        int ret = 0;
        int ind = parent.indexOf(this);
        for (int i = 0; i < ind; ++i) {
            ret += parent.getChildAt(i).countLeafs(depth);
        }
        return ret + parent.countLeftBrothers(sub_root, depth + 1);
    }

    protected int countRightBrothers(Residue sub_root, int depth) {
        Residue parent = this.getParent();
        if (parent == null || this == sub_root) {
            return 0;
        }
        int ret = 0;
        int ind = parent.indexOf(this);
        for (int i = ind + 1; i < parent.getNoChildren(); ++i) {
            ret += parent.getChildAt(i).countLeafs(depth);
        }
        return ret += parent.countRightBrothers(sub_root, depth + 1);
    }

    protected int countLeafs(int max_depth) {
        if (max_depth == 0 || this.getNoChildren() == 0) {
            return 1;
        }
        int ret = 0;
        Iterator<Linkage> i = this.children_linkages.iterator();
        while (i.hasNext()) {
            ret += i.next().getChildResidue().countLeafs(max_depth - 1);
        }
        return ret;
    }

    protected boolean hasLinkedParent() {
        return this.parent_linkage != null && this.parent_linkage.getParentResidue() != null && (this.parent_linkage.getParentResidue().getTypeName().equals("freeEnd") || this.parent_linkage.getParentResidue().getTypeName().equals("redEnd"));
    }

    public boolean checkLinkages() {
        block9: {
            block8: {
                if (!this.isBracket()) break block8;
                for (Linkage l : this.children_linkages) {
                    if (!l.hasUncertainParentPositions()) continue;
                    return false;
                }
                break block9;
            }
            if (!this.isSaccharide()) break block9;
            Vector<Character> all_pos = new Vector<Character>(0, 1);
            if (this.hasLinkedParent()) {
                if (this.parent_linkage.hasUncertainChildPositions()) {
                    return false;
                }
                all_pos.addAll(this.parent_linkage.getChildPositions());
            }
            for (Linkage l : this.children_linkages) {
                if (l.hasUncertainParentPositions()) {
                    return false;
                }
                all_pos.addAll(l.getParentPositions());
            }
            HashSet<Character> set = new HashSet<Character>();
            for (Character c : all_pos) {
                char pos = c.charValue();
                if (set.contains(Character.valueOf(pos))) {
                    return false;
                }
                set.add(Character.valueOf(pos));
            }
            for (Character pos : all_pos) {
                if (this.type.isValidPosition(pos.charValue())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean checkLinkagesSubtree() {
        if (!this.checkLinkages()) {
            return false;
        }
        for (Linkage l : this.children_linkages) {
            if (l.getChildResidue().checkLinkagesSubtree()) continue;
            return false;
        }
        return true;
    }

    public boolean isFullySpecified() {
        if (this.isBracket()) {
            return false;
        }
        if (this.hasLinkedParent() && this.parent_linkage.hasUncertainChildPositions()) {
            return false;
        }
        for (Linkage l : this.children_linkages) {
            if (!l.hasUncertainParentPositions()) continue;
            return false;
        }
        return true;
    }

    public boolean isFullySpecifiedSubtree() {
        if (!this.isFullySpecified()) {
            return false;
        }
        Iterator<Linkage> i = this.children_linkages.iterator();
        while (i.hasNext()) {
            if (i.next().getChildResidue().isFullySpecified()) continue;
            return false;
        }
        return true;
    }

    private boolean fuzzyMatch(char c1, char c2) {
        return this.match(c1, c2, true);
    }

    private boolean match(char c1, char c2, boolean fuzzy) {
        return c1 == c2 || fuzzy && (c1 == '?' || c2 == '?');
    }

    private boolean fuzzyMatch(ResidueType rt1, ResidueType rt2) {
        return this.match(rt1, rt2, true);
    }

    private boolean match(ResidueType rt1, ResidueType rt2, boolean fuzzy) {
        return rt1.getName().equals(rt2.getName()) || fuzzy && (rt1.getCompositionClass().equals(rt2.getName()) || rt1.getName().equals(rt2.getCompositionClass()));
    }

    public boolean fuzzyMatch(Residue other) {
        return this.match(other, true);
    }

    public boolean match(Residue other, boolean fuzzy) {
        if (other == null) {
            return false;
        }
        if (!this.match(this.getType(), other.getType(), fuzzy)) {
            return false;
        }
        if (!this.match(this.anomeric_state, other.anomeric_state, fuzzy)) {
            return false;
        }
        if (!this.match(this.anomeric_carbon, other.anomeric_carbon, fuzzy)) {
            return false;
        }
        return this.match(this.chirality, other.chirality, fuzzy);
    }

    public boolean subtreeContains(Residue node) {
        if (this == node) {
            return true;
        }
        for (Linkage l : this.children_linkages) {
            if (!l.getChildResidue().subtreeContains(node)) continue;
            return true;
        }
        return false;
    }

    public boolean typeEquals(Residue other) {
        if (other == null) {
            return false;
        }
        if (!this.getTypeName().equals(other.getTypeName())) {
            return false;
        }
        if (this.anomeric_state != other.anomeric_state) {
            return false;
        }
        if (this.anomeric_carbon != other.anomeric_carbon) {
            return false;
        }
        if (this.chirality != other.chirality) {
            return false;
        }
        return this.ring_size == other.ring_size;
    }

    public boolean subtreeEquals(Residue other) {
        if (!this.typeEquals(other)) {
            return false;
        }
        if (this.getNoChildren() != other.getNoChildren()) {
            return false;
        }
        for (int i = 0; i < this.children_linkages.size(); ++i) {
            if (this.getLinkageAt(i).subtreeEquals(other.getLinkageAt(i))) continue;
            return false;
        }
        return true;
    }

    public Residue getTreeRoot() {
        if (this.parent_linkage == null) {
            return this;
        }
        return this.parent_linkage.getParentResidue().getTreeRoot();
    }

    public boolean isInRepetition() {
        return this.findStartRepetition() != null;
    }

    public Residue findStartRepetition() {
        return this.findStartRepetition(false);
    }

    private Residue findStartRepetition(boolean stop_at_end) {
        if (this.isStartRepetition()) {
            return this;
        }
        if (stop_at_end && this.isEndRepetition()) {
            return null;
        }
        if (this.getParent() == null) {
            return null;
        }
        return this.getParent().findStartRepetition(true);
    }

    public Residue findEndRepetition() {
        return this.findEndRepetition(false);
    }

    private Residue findEndRepetition(boolean stop_at_start) {
        if (this.isEndRepetition()) {
            return this;
        }
        if (stop_at_start && this.isStartRepetition()) {
            return null;
        }
        for (Linkage l : this.children_linkages) {
            Residue ret = l.getChildResidue().findEndRepetition(true);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public boolean addChild(Residue child) {
        return this.addChild(child, Bond.single());
    }

    public boolean canAddChild(Residue child) {
        return this.canAddChild(child, Bond.single());
    }

    public boolean addChild(Residue child, char parent_link_pos) {
        return this.addChild(child, Bond.single(parent_link_pos));
    }

    public boolean canAddChild(Residue child, char parent_link_pos) {
        return this.canAddChild(child, Bond.single(parent_link_pos));
    }

    public boolean addChild(Residue child, Collection<Bond> bonds) {
        if (child == null) {
            return false;
        }
        if (child.isAttachPoint()) {
            if (!child.hasChildren()) {
                return false;
            }
            Linkage link = child.children_linkages.get(0);
            return this.addChild(link.getChildResidue(), link.getBonds());
        }
        if (this.isStartRepetition() && this.getChildrenLinkages().size() > 0) {
            return false;
        }
        if (child.isReducingEnd() && !child.canHaveParent()) {
            return this.addChild(child.firstChild(), bonds);
        }
        if (this.isLCleavage() && this.cleaved_residue.getTypeName().equals(child.getTypeName())) {
            this.copyResidue(this.cleaved_residue);
            return true;
        }
        Linkage link = new Linkage(this, child, bonds);
        this.children_linkages.add(link);
        child.parent_linkage = link;
        return true;
    }

    public boolean canAddChild(Residue child, Collection<Bond> bonds) {
        if (child == null) {
            return false;
        }
        if (child.isAttachPoint()) {
            if (!child.hasChildren()) {
                return false;
            }
            Linkage link = child.children_linkages.get(0);
            return this.canAddChild(link.getChildResidue(), link.getBonds());
        }
        if (this.isRepetition() && this.getNoChildren() != 0) {
            return false;
        }
        if (child.isReducingEnd() && !child.canHaveParent()) {
            return this.canAddChild(child.firstChild(), bonds);
        }
        if (this.isLCleavage() && this.cleaved_residue.getTypeName().equals(child.getTypeName())) {
            return true;
        }
        return true;
    }

    public boolean moveChildBefore(Residue child, Residue other) {
        if (child == null || other == null || child.getParent() != this || other.getParent() != this) {
            return false;
        }
        int child_ind = this.indexOf(child);
        this.children_linkages.remove(child_ind);
        int other_ind = this.indexOf(other);
        this.children_linkages.add(other_ind, child.getParentLinkage());
        return true;
    }

    public boolean moveChildAfter(Residue child, Residue other) {
        if (child == null || other == null || child.getParent() != this || other.getParent() != this) {
            return false;
        }
        int child_ind = this.indexOf(child);
        this.children_linkages.remove(child_ind);
        int other_ind = this.indexOf(other);
        this.children_linkages.add(other_ind + 1, child.getParentLinkage());
        return true;
    }

    public boolean insertChildAt(Residue child, int ind) {
        return this.insertChildAt(child, Bond.single(), ind);
    }

    public boolean insertChildAt(Residue child, char parent_link_pos, int ind) {
        return this.insertChildAt(child, Bond.single(parent_link_pos), ind);
    }

    public boolean insertChildAt(Residue child, Collection<Bond> bonds, int ind) {
        if (child == null) {
            return false;
        }
        if (child.isReducingEnd() && !child.canHaveParent()) {
            return this.insertChildAt(child.firstChild(), ind);
        }
        Linkage link = new Linkage(this, child, bonds);
        this.children_linkages.add(ind, link);
        child.parent_linkage = link;
        return true;
    }

    public boolean removeChild(Residue toremove) {
        if (toremove == null) {
            return false;
        }
        int ind = this.indexOf(toremove);
        if (ind != -1) {
            Residue start;
            this.children_linkages.remove(ind);
            toremove.parent_linkage = null;
            if (this.isStartRepetition() && !toremove.isEndRepetition()) {
                Residue newchild = null;
                for (Linkage l : toremove.children_linkages) {
                    if (l.getChildResidue().findEndRepetition() == null) continue;
                    newchild = l.getChildResidue();
                }
                this.children_linkages.add(newchild.getParentLinkage());
                newchild.getParentLinkage().setParentResidue(this);
                for (Linkage l : toremove.children_linkages) {
                    if (l.getChildResidue() == newchild) continue;
                    newchild.children_linkages.add(l);
                    l.setParentResidue(newchild);
                }
            } else {
                for (int l = 0; l < toremove.getNoChildren(); ++l) {
                    Linkage grand_child_link = toremove.children_linkages.get(l);
                    this.children_linkages.add(ind + l, grand_child_link);
                    grand_child_link.setParentResidue(this);
                }
            }
            if (toremove.isStartRepetition()) {
                this.removeChild(this.findEndRepetition());
            } else if (toremove.isEndRepetition() && (start = this.findStartRepetition()) != null) {
                start.getParent().removeChild(start);
            }
            if (this.isStartRepetition()) {
                boolean removed = false;
                for (int l = 0; l < this.getNoChildren(); ++l) {
                    if (!this.getChildAt(l).isEndRepetition()) continue;
                    removed = true;
                    this.removeChild(this.getChildAt(l));
                }
            }
            return true;
        }
        for (Linkage l : this.children_linkages) {
            if (!l.getChildResidue().removeChild(toremove)) continue;
            return true;
        }
        return false;
    }

    public boolean insertParent(Residue toinsert) {
        return this.insertParent(toinsert, Bond.single());
    }

    public boolean insertParent(Residue toinsert, char parent_link_pos) {
        return this.insertParent(toinsert, Bond.single(parent_link_pos));
    }

    public boolean insertParent(Residue toinsert, Collection<Bond> bonds) {
        if (this.parent_linkage == null) {
            return false;
        }
        if (!toinsert.canHaveParent() || !toinsert.canHaveChildren() || toinsert.getMaxLinkages() < 2) {
            return false;
        }
        Residue grand_parent = this.parent_linkage.getParentResidue();
        int ind = grand_parent.indexOf(this);
        grand_parent.children_linkages.remove(ind);
        this.parent_linkage.setParentResidue(toinsert);
        toinsert.children_linkages.add(this.parent_linkage);
        grand_parent.insertChildAt(toinsert, bonds, ind);
        return true;
    }

    public boolean swapChildren(Residue child1, Residue child2) {
        if (child1 == null || child2 == null) {
            return false;
        }
        int ind1 = this.indexOf(child1);
        int ind2 = this.indexOf(child2);
        if (ind1 == -1 || ind2 == -1) {
            return false;
        }
        Linkage link1 = this.children_linkages.get(ind1);
        Linkage link2 = this.children_linkages.get(ind2);
        this.children_linkages.set(ind2, link1);
        this.children_linkages.set(ind1, link2);
        return true;
    }

    public Residue cloneResidue() {
        Residue ret = new Residue(this.type);
        ret.anomeric_state = this.anomeric_state;
        ret.anomeric_carbon = this.anomeric_carbon;
        ret.chirality = this.chirality;
        ret.ring_size = this.ring_size;
        ret.cleaved_residue = this.cleaved_residue != null ? this.cleaved_residue.cloneResidue() : null;
        ret.preferred_placement = this.preferred_placement != null ? this.preferred_placement.clone() : null;
        ret.was_sticky = this.was_sticky;
        return ret;
    }

    public void copyResidue(Residue other) {
        this.type = other.type;
        this.anomeric_state = other.anomeric_state;
        this.anomeric_carbon = other.anomeric_carbon;
        this.chirality = other.chirality;
        this.ring_size = other.ring_size;
        this.cleaved_residue = other.cleaved_residue != null ? other.cleaved_residue.cloneResidue() : null;
        this.preferred_placement = other.preferred_placement != null ? other.preferred_placement.clone() : null;
        this.was_sticky = other.was_sticky;
    }

    public Residue cloneSubtree() {
        return this.cloneSubtree(null, null, new ResidueHolder());
    }

    protected Residue cloneSubtree(Residue stop_el, ResidueType stop_type) {
        Residue stop = new Residue(stop_type);
        if (stop.isCleavage() && stop_el != null) {
            stop.setCleavedResidue(stop_el.cloneResidue());
        }
        return this.cloneSubtree(stop_el, stop, new ResidueHolder());
    }

    protected Residue cloneSubtree(Residue stop_el, Residue stop) {
        return this.cloneSubtree(stop_el, stop, new ResidueHolder());
    }

    protected Residue cloneSubtree(Residue stop_el, Residue stop, ResidueHolder startRep) {
        if (this == stop_el) {
            return stop;
        }
        Residue clone = this.cloneResidue();
        if (clone.isStartRepetition()) {
            startRep.res = clone;
        } else if (clone.isEndRepetition()) {
            startRep.res.setEndRepitionResidue(clone);
            startRep.res = null;
        }
        for (Linkage l : this.children_linkages) {
            clone.addChild(l.getChildResidue().cloneSubtree(stop_el, stop, startRep), l.getBonds());
        }
        return clone;
    }

    protected Residue cloneSubtreeAdd(Residue add_el, Residue toadd, char toadd_link, ResidueHolder startRep) {
        return this.cloneSubtreeAdd(add_el, toadd, Bond.single(toadd_link), startRep);
    }

    protected Residue cloneSubtreeAdd(Residue add_el, Residue toadd, Collection<Bond> toadd_bonds, ResidueHolder startRep) {
        Residue clone = this.cloneResidue();
        if (clone.isStartRepetition()) {
            startRep.res = clone;
        } else if (clone.isEndRepetition()) {
            startRep.res.setEndRepitionResidue(clone);
            startRep.res = null;
        }
        for (Linkage l : this.children_linkages) {
            clone.addChild(l.getChildResidue().cloneSubtreeAdd(add_el, toadd, toadd_bonds, startRep), l.getBonds());
        }
        if (this == add_el && toadd != null) {
            Linkage link = new Linkage(clone, toadd, toadd_bonds);
            clone.children_linkages.add(link);
            toadd.parent_linkage = link;
        }
        return clone;
    }

    public void setEndRepitionResidue(Residue end) {
        this.endRepetitionResidue = end;
        end.setStartRepetiionResidue(this);
    }

    public Residue getEndRepitionResidue() {
        return this.endRepetitionResidue;
    }

    public void setStartRepetiionResidue(Residue start) {
        this.startRepititionResidue = start;
    }

    public Residue getStartRepetitionResidue() {
        return this.startRepititionResidue;
    }

    public void setCenterPosition(Rectangle rectangle) {
        this.centerPos = rectangle;
    }

    public Rectangle getCenterPosition() {
        return this.centerPos;
    }
}

