/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.contentmodel.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceAttributeVisitor;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceInfo;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NamespaceTable
extends NamespaceAttributeVisitor {
    public Hashtable hashtable = new Hashtable();

    public NamespaceTable(Document document) {
        this();
    }

    private NamespaceTable() {
    }

    public boolean isNamespaceEncountered() {
        return this.hashtable.values().size() > 0;
    }

    public String getPrefixForURI(String uri) {
        String result = null;
        NamespaceInfo entry = this.getNamespaceInfoForURI(uri, true);
        if (entry != null) {
            result = entry.prefix;
        }
        return result;
    }

    public String getURIForPrefix(String prefix) {
        String result = null;
        NamespaceInfo info = this.getNamespaceInfoForPrefix(prefix);
        if (info != null) {
            result = info.uri;
        }
        return result;
    }

    protected boolean isMatchingString(String a, String b) {
        return a == null && b == null || a != null && b != null && a.equals(b);
    }

    public NamespaceInfo getNamespaceInfoForURI(String uri) {
        return this.getNamespaceInfoForURI(uri, false);
    }

    public NamespaceInfo getNamespaceInfoForURI(String uri, boolean testImplied) {
        NamespaceInfo result = null;
        Iterator i = this.hashtable.values().iterator();
        while (i.hasNext()) {
            NamespaceInfo nsInfo = (NamespaceInfo)i.next();
            if (!this.isMatchingString(nsInfo.uri, uri)) continue;
            result = nsInfo;
            if (!testImplied || nsInfo.getProperty("isImplied") == null) break;
        }
        return result;
    }

    public void setLocationHintForURI(String uri, String locationHint) {
        Iterator i = this.hashtable.values().iterator();
        while (i.hasNext()) {
            NamespaceInfo nsInfo = (NamespaceInfo)i.next();
            if (!this.isMatchingString(nsInfo.uri, uri)) continue;
            nsInfo.locationHint = locationHint;
        }
    }

    public NamespaceInfo getNamespaceInfoForPrefix(String prefix) {
        prefix = prefix != null ? prefix : "";
        return (NamespaceInfo)this.hashtable.get(prefix);
    }

    public void visitXMLNamespaceAttribute(Attr attr, String namespacePrefix, String namespaceURI) {
        NamespaceInfo nsInfo = new NamespaceInfo();
        nsInfo.prefix = namespacePrefix;
        nsInfo.uri = namespaceURI;
        NamespaceInfo matchingNamespaceInfo = this.getNamespaceInfoForURI(namespaceURI);
        if (matchingNamespaceInfo != null) {
            nsInfo.locationHint = matchingNamespaceInfo.locationHint;
        }
        this.internalAddNamespaceInfo(namespacePrefix, nsInfo);
        super.visitXMLNamespaceAttribute(attr, namespacePrefix, namespaceURI);
    }

    public void visitXSISchemaLocationValuePair(String uri, String locationHint) {
        this.setLocationHintForURI(uri, locationHint);
    }

    public void addNamespaceInfo(NamespaceInfo info) {
        String key = info.prefix != null ? info.prefix : "";
        this.internalAddNamespaceInfo(key, info);
    }

    protected void internalAddNamespaceInfo(String key, NamespaceInfo info) {
        this.hashtable.put(key, info);
    }

    protected void addNamespaceInfoList(List list, boolean isImplied) {
        if (list != null) {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                NamespaceInfo info = (NamespaceInfo)i.next();
                NamespaceInfo clone = new NamespaceInfo(info);
                if (isImplied) {
                    clone.setProperty("isImplied", "true");
                }
                this.addNamespaceInfo(clone);
            }
        }
    }

    public void addNamespaceInfoList(List list) {
        this.addNamespaceInfoList(list, false);
    }

    public void visitXSINoNamespaceSchemaLocationAttribute(Attr attr, String locationHint) {
        this.addNoNamespaceSchemaLocation(locationHint);
    }

    public void addNoNamespaceSchemaLocation(String locationHint) {
        NamespaceInfo nsInfo = new NamespaceInfo();
        nsInfo.prefix = null;
        nsInfo.uri = "";
        nsInfo.locationHint = locationHint;
        this.internalAddNamespaceInfo("", nsInfo);
    }

    public void addNamespaceInfo(String prefix, String uri, String locationHint) {
        NamespaceInfo nsInfo = new NamespaceInfo();
        nsInfo.prefix = prefix;
        nsInfo.uri = uri;
        nsInfo.locationHint = locationHint;
        this.internalAddNamespaceInfo(prefix != null ? prefix : "", nsInfo);
    }

    public void addElement(Element element) {
        this.visitElement(element);
    }

    public void addElementLineage(Element targetElement) {
        List list = NamespaceTable.getElementLineage(targetElement);
        Iterator i = list.iterator();
        while (i.hasNext()) {
            Element element = (Element)i.next();
            this.addElement(element);
        }
    }

    public static List getElementLineage(Element element) {
        ArrayList<Element> result = new ArrayList<Element>();
        Node node = element;
        while (node != null) {
            if (node.getNodeType() != 1) break;
            result.add(0, (Element)node);
            node = node.getParentNode();
        }
        return result;
    }

    public Collection getNamespaceInfoCollection() {
        return this.hashtable.values();
    }

    public List getNamespaceInfoList() {
        Vector list = new Vector();
        list.addAll(this.hashtable.values());
        return list;
    }
}

