/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.filechooser.FileFilter;
import javax.xml.transform.sax.TransformerHandler;
import org.eurocarbdb.application.glycanbuilder.BaseDocument;
import org.eurocarbdb.application.glycanbuilder.BaseWorkspace;
import org.eurocarbdb.application.glycanbuilder.BuilderWorkspace;
import org.eurocarbdb.application.glycanbuilder.Configuration;
import org.eurocarbdb.application.glycanbuilder.ExtensionFileFilter;
import org.eurocarbdb.application.glycanbuilder.FragmentDocument;
import org.eurocarbdb.application.glycanbuilder.FragmentOptions;
import org.eurocarbdb.application.glycanbuilder.GlycanDocument;
import org.eurocarbdb.application.glycanbuilder.GlycanRenderer;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.SAXUtils;
import org.eurocarbdb.application.glycanbuilder.XMLUtils;
import org.eurocarbdb.application.glycoworkbench.AnnotatedPeakList;
import org.eurocarbdb.application.glycoworkbench.Annotation;
import org.eurocarbdb.application.glycoworkbench.AnnotationOptions;
import org.eurocarbdb.application.glycoworkbench.NotesDocument;
import org.eurocarbdb.application.glycoworkbench.Peak;
import org.eurocarbdb.application.glycoworkbench.PeakAnnotationMultiple;
import org.eurocarbdb.application.glycoworkbench.PeakList;
import org.eurocarbdb.application.glycoworkbench.Scan;
import org.eurocarbdb.application.glycoworkbench.SpectraDocument;
import org.eurocarbdb.application.glycoworkbench.plugin.Plugin;
import org.eurocarbdb.application.glycoworkbench.plugin.reporting.AnnotationReportDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class GlycanWorkspace
extends BuilderWorkspace
implements SAXUtils.SAXWriter {
    protected FragmentOptions theFragmentOptions;
    protected AnnotationOptions theAnnotationOptions;
    protected Plugin theSearchGenerator;
    protected AnnotatedPeakList theSearchResults;
    protected Vector<Scan> theScanList;
    protected Scan currentScan;
    protected Double recent_mz_value = null;
    protected Vector<Listener> gw_listeners = new Vector();

    public GlycanWorkspace(GlycanRenderer glycanRenderer) {
        super(glycanRenderer);
    }

    public GlycanWorkspace(String config_file, boolean create, GlycanRenderer glycanRenderer) {
        super(config_file, create, glycanRenderer);
    }

    public Collection<FileFilter> getFileFormats() {
        Vector<FileFilter> filters = new Vector<FileFilter>();
        filters.add((FileFilter)new ExtensionFileFilter("gwp", "GlycoWorkbench workspace file"));
        return filters;
    }

    public FileFilter getAllFileFormats() {
        return new ExtensionFileFilter("gwp", "Workspace files");
    }

    protected void createConfiguration() {
        super.createConfiguration();
        this.theFragmentOptions = new FragmentOptions();
        this.theAnnotationOptions = new AnnotationOptions();
    }

    public void init(String config_file, boolean create, boolean keep_configuration) {
        super.init(config_file, create, keep_configuration);
        this.theSearchResults = new AnnotatedPeakList();
        this.theScanList = new Vector();
        this.currentScan = new Scan(this);
        this.theScanList.add(this.currentScan);
        this.registerListeners(this.currentScan);
    }

    protected void retrieveFromConfiguration() {
        super.retrieveFromConfiguration();
        this.theFragmentOptions.retrieve(this.theConfiguration);
        this.theAnnotationOptions.retrieve(this.theConfiguration);
    }

    protected void storeToConfiguration(boolean save_options) {
        super.storeToConfiguration(save_options);
        if (save_options) {
            this.theFragmentOptions.store(this.theConfiguration);
            this.theAnnotationOptions.store(this.theConfiguration);
        }
    }

    public Double getRecentMZValue() {
        return this.recent_mz_value;
    }

    public void setRecentMZValue(Double v) {
        this.recent_mz_value = v;
    }

    public FragmentOptions getFragmentOptions() {
        return this.theFragmentOptions;
    }

    public void storeFragmentOptions() {
        this.theFragmentOptions.store(this.theConfiguration);
    }

    public AnnotationOptions getAnnotationOptions() {
        return this.theAnnotationOptions;
    }

    public void storeAnnotationOptions() {
        this.theAnnotationOptions.store(this.theConfiguration);
    }

    public Scan scanAt(int ind) {
        return this.theScanList.elementAt(ind);
    }

    public int indexOf(Scan s) {
        return this.theScanList.indexOf(s);
    }

    public int getNoScans() {
        return this.theScanList.size();
    }

    public Collection<Scan> getScanList() {
        return this.theScanList;
    }

    public Scan getFirstScan() {
        return this.theScanList.firstElement();
    }

    public Scan getNextScan(Scan s) {
        if (s == null) {
            return null;
        }
        int index = this.theScanList.indexOf(s);
        if (index == -1) {
            return null;
        }
        if (index == this.theScanList.size() - 1) {
            if (index > 0) {
                return this.theScanList.elementAt(index - 1);
            }
            return null;
        }
        return this.theScanList.elementAt(index + 1);
    }

    public Scan getCurrentScan() {
        return this.currentScan;
    }

    public boolean setCurrentScan(Scan s) {
        if (s != null) {
            if (s != this.currentScan) {
                Scan old = this.currentScan;
                Scan parent = old.getParent();
                int index = parent != null ? parent.indexOf(old) : -1;
                this.currentScan = s;
                this.fireCurrentScanChanged(new Event(this, parent, old, index, s));
            }
            return true;
        }
        return false;
    }

    public boolean addScan(Scan parent, Scan toadd) {
        if (toadd == null) {
            return false;
        }
        int index = -1;
        if (parent == null) {
            this.theScanList.add(toadd);
            index = this.theScanList.indexOf(toadd);
        } else {
            parent.add(toadd);
            index = parent.indexOf(toadd);
        }
        this.registerListeners(toadd);
        this.fireScanAdded(new Event(this, parent, toadd, index, this.currentScan));
        this.fireDocumentChanged((BaseDocument)this);
        return true;
    }

    public boolean removeScan(Scan parent, Scan toremove) {
        if (toremove == null) {
            return false;
        }
        int index = -1;
        if (parent == null) {
            index = this.theScanList.indexOf(toremove);
            if (index == -1) {
                return false;
            }
            if (this.theScanList.size() == 1) {
                this.addScan(null, new Scan(this));
            }
            if (toremove.containsSubTree(this.currentScan)) {
                this.setCurrentScan(this.getNextScan(this.currentScan));
            }
            this.theScanList.remove(toremove);
        } else {
            index = parent.indexOf(toremove);
            if (index == -1) {
                return false;
            }
            if (toremove.containsSubTree(this.currentScan)) {
                this.setCurrentScan(parent);
            }
            parent.remove(toremove);
        }
        this.deregisterListeners(toremove);
        this.fireScanRemoved(new Event(this, parent, toremove, index, this.currentScan));
        this.fireDocumentChanged((BaseDocument)this);
        return true;
    }

    public boolean syncScan(Scan scan) {
        AnnotatedPeakList annotatedPeakList;
        PeakAnnotationMultiple peakAnnotations;
        boolean matchFound = false;
        Scan parentScan = scan.getParent();
        if (parentScan != null && (peakAnnotations = (annotatedPeakList = parentScan.getAnnotatedPeakList()).getAnnotations(new Peak(scan.getPrecursorMZ(), 0.0))) != null) {
            for (Vector<Annotation> structureToAnnotations : peakAnnotations.getAnnotations()) {
                for (Annotation annotation : structureToAnnotations) {
                    scan.getStructures().addStructure(annotation.getFragmentEntry().fragment);
                }
                if (structureToAnnotations.size() <= 0) continue;
                matchFound = true;
            }
        }
        this.fireDocumentChanged((BaseDocument)this);
        return matchFound;
    }

    public Vector<Scan> getAllScans() {
        Vector<Scan> ret = new Vector<Scan>();
        for (Scan s : this.theScanList) {
            this.getAllScans(s, ret);
        }
        return ret;
    }

    public Vector<Scan> getAllParentScans() {
        Vector<Scan> ret = new Vector<Scan>();
        ret.addAll(this.theScanList);
        return ret;
    }

    private void getAllScans(Scan s, Vector<Scan> dst) {
        dst.add(s);
        for (Scan c : s.getChildren()) {
            this.getAllScans(c, dst);
        }
    }

    public Scan findInternalDocument(BaseDocument doc) {
        if (doc != null) {
            for (Scan s : this.theScanList) {
                Scan ret = s.findInternalDocument(doc);
                if (ret == null) continue;
                return ret;
            }
        }
        return null;
    }

    public boolean addAnnotationReport(AnnotationReportDocument ard) {
        if (ard == null || this.currentScan == null) {
            return false;
        }
        this.currentScan.getAnnotationReports().add(ard);
        ard.addDocumentChangeListener((BaseDocument.DocumentChangeListener)this);
        this.fireDocumentChanged();
        return true;
    }

    public boolean removeAnnotationReport(AnnotationReportDocument ard) {
        if (ard == null || this.currentScan == null) {
            return false;
        }
        if (!this.currentScan.getAnnotationReports().contains((Object)ard)) {
            return false;
        }
        this.currentScan.getAnnotationReports().remove((Object)ard);
        ard.addDocumentChangeListener((BaseDocument.DocumentChangeListener)this);
        this.fireDocumentChanged();
        return true;
    }

    private void registerListeners(Scan s) {
        if (s != null) {
            s.getStructures().addDocumentChangeListener((BaseDocument.DocumentChangeListener)this);
            s.getFragments().addDocumentChangeListener((BaseDocument.DocumentChangeListener)this);
            s.getSpectra().addDocumentChangeListener((BaseDocument.DocumentChangeListener)this);
            s.getPeakList().addDocumentChangeListener((BaseDocument.DocumentChangeListener)this);
            s.getAnnotatedPeakList().addDocumentChangeListener((BaseDocument.DocumentChangeListener)this);
            s.getNotes().addDocumentChangeListener((BaseDocument.DocumentChangeListener)this);
            for (AnnotationReportDocument ard : s.getAnnotationReports()) {
                ard.addDocumentChangeListener((BaseDocument.DocumentChangeListener)this);
            }
        }
    }

    private void deregisterListeners(Scan s) {
        if (s != null) {
            s.getStructures().removeDocumentChangeListener((BaseDocument.DocumentChangeListener)this);
            s.getFragments().removeDocumentChangeListener((BaseDocument.DocumentChangeListener)this);
            s.getSpectra().removeDocumentChangeListener((BaseDocument.DocumentChangeListener)this);
            s.getPeakList().removeDocumentChangeListener((BaseDocument.DocumentChangeListener)this);
            s.getAnnotatedPeakList().removeDocumentChangeListener((BaseDocument.DocumentChangeListener)this);
            s.getNotes().removeDocumentChangeListener((BaseDocument.DocumentChangeListener)this);
            for (AnnotationReportDocument ard : s.getAnnotationReports()) {
                ard.removeDocumentChangeListener((BaseDocument.DocumentChangeListener)this);
            }
        }
    }

    private void addListeners(Scan node) {
        if (node == null) {
            return;
        }
        this.registerListeners(node);
        for (Scan s : node.getChildren()) {
            this.addListeners(s);
        }
    }

    private void removeListeners(Scan node) {
        if (node == null) {
            return;
        }
        this.deregisterListeners(node);
        for (Scan s : node.getChildren()) {
            this.removeListeners(s);
        }
    }

    public void setPrecursorMZ(Scan s, Double mz) {
        if (s != null) {
            s.setPrecursorMZ(mz);
            this.setChanged(true);
            this.fireInternalDocumentChanged(s);
        }
    }

    public void setMsMs(Scan s, boolean f) {
        if (s != null) {
            s.setMsMs(f);
            this.setChanged(true);
            this.fireInternalDocumentChanged(s);
        }
    }

    public boolean isCurrent(Scan s) {
        return this.currentScan == s;
    }

    public Plugin getSearchGenerator() {
        return this.theSearchGenerator;
    }

    public void setSearchGenerator(Plugin p) {
        this.theSearchGenerator = p;
    }

    public AnnotatedPeakList getSearchResults() {
        return this.theSearchResults;
    }

    public GlycanDocument getStructures() {
        return this.currentScan.getStructures();
    }

    public FragmentDocument getFragments() {
        return this.currentScan.getFragments();
    }

    public SpectraDocument getSpectra() {
        return this.currentScan.getSpectra();
    }

    public PeakList getPeakList() {
        return this.currentScan.getPeakList();
    }

    public AnnotatedPeakList getAnnotatedPeakList() {
        return this.currentScan.getAnnotatedPeakList();
    }

    public NotesDocument getNotes() {
        return this.currentScan.getNotes();
    }

    public Collection<AnnotationReportDocument> getAnnotationReports() {
        return this.currentScan.getAnnotationReports();
    }

    public Collection<BaseDocument> getAllDocuments() {
        Vector<BaseDocument> ret = new Vector<BaseDocument>();
        ret.add((BaseDocument)this);
        ret.add(new AnnotationReportDocument());
        ret.add(this.currentScan.getNotes());
        ret.add(this.currentScan.getSpectra());
        ret.add(this.currentScan.getAnnotatedPeakList());
        ret.add(this.currentScan.getPeakList());
        ret.add((BaseDocument)this.currentScan.getFragments());
        ret.add((BaseDocument)this.currentScan.getStructures());
        return ret;
    }

    public Collection<BaseDocument> getUnsavedDocuments() {
        Vector<BaseDocument> ret = new Vector<BaseDocument>();
        for (Scan s : this.theScanList) {
            this.getUnsavedDocuments(ret, s);
        }
        return ret;
    }

    private void getUnsavedDocuments(Vector<BaseDocument> buffer, Scan scan) {
        if (scan.getStructures().hasChanged()) {
            buffer.add((BaseDocument)scan.getStructures());
        }
        if (scan.getFragments().hasChanged()) {
            buffer.add((BaseDocument)scan.getFragments());
        }
        if (scan.getSpectra().hasChanged()) {
            buffer.add(scan.getSpectra());
        }
        if (scan.getPeakList().hasChanged()) {
            buffer.add(scan.getPeakList());
        }
        if (scan.getAnnotatedPeakList().hasChanged()) {
            buffer.add(scan.getAnnotatedPeakList());
        }
        if (scan.getNotes().hasChanged()) {
            buffer.add(scan.getNotes());
        }
        for (AnnotationReportDocument ard : scan.getAnnotationReports()) {
            if (!ard.hasChanged()) continue;
            buffer.add(ard);
        }
        for (Scan c : scan.getChildren()) {
            this.getUnsavedDocuments(buffer, c);
        }
    }

    public void resetChanges() {
        this.resetStatus();
        for (Scan s : this.theScanList) {
            this.resetChanges(s);
        }
        this.fireDocumentInit();
    }

    private void resetChanges(Scan s) {
        s.getStructures().resetStatus();
        s.getFragments().resetStatus();
        s.getSpectra().resetStatus();
        s.getPeakList().resetStatus();
        s.getAnnotatedPeakList().resetStatus();
        s.getNotes().resetStatus();
        for (AnnotationReportDocument ard : s.getAnnotationReports()) {
            ard.resetStatus();
        }
        for (Scan c : s.getChildren()) {
            this.resetChanges(c);
        }
    }

    public void addWorkspaceListener(Listener l) {
        if (l != null) {
            this.gw_listeners.add(l);
        }
    }

    public void removeWorkspaceListener(Listener l) {
        this.gw_listeners.remove(l);
    }

    public void fireCurrentScanChanged(Event e) {
        for (Listener l : this.gw_listeners) {
            l.currentScanChanged(e);
        }
    }

    public void fireScanAdded(Event e) {
        for (Listener l : this.gw_listeners) {
            l.scanAdded(e);
        }
    }

    public void fireScanRemoved(Event e) {
        for (Listener l : this.gw_listeners) {
            l.scanRemoved(e);
        }
    }

    public void fireInternalDocumentChanged(BaseDocument doc) {
        Scan s = this.findInternalDocument(doc);
        this.fireInternalDocumentChanged(s);
    }

    public void fireInternalDocumentChanged(Scan s) {
        if (s == null || this.gw_listeners == null) {
            return;
        }
        Event e = new Event(this, s, null, -1, this.currentScan);
        for (Listener l : this.gw_listeners) {
            l.internalDocumentChanged(e);
        }
    }

    public void fireDocumentInit() {
        for (Scan s : this.theScanList) {
            this.fireDocumentInit(s);
        }
        super.fireDocumentInit();
    }

    private void fireDocumentInit(Scan s) {
        s.getStructures().fireDocumentInit();
        s.getFragments().fireDocumentInit();
        s.getSpectra().fireDocumentInit();
        s.getPeakList().fireDocumentInit();
        s.getAnnotatedPeakList().fireDocumentInit();
        s.getNotes().fireDocumentInit();
        for (AnnotationReportDocument ard : s.getAnnotationReports()) {
            ard.fireDocumentInit();
        }
        for (Scan c : s.getChildren()) {
            this.fireDocumentInit(c);
        }
    }

    public void documentInit(BaseDocument.DocumentChangeEvent e) {
        this.setChanged(true);
        this.fireInternalDocumentChanged((BaseDocument)e.getSource());
    }

    public void documentChanged(BaseDocument.DocumentChangeEvent e) {
        this.setChanged(true);
        this.fireInternalDocumentChanged((BaseDocument)e.getSource());
    }

    protected void read(InputStream is, boolean merge) throws Exception {
        SAXUtils.read((InputStream)is, (DefaultHandler)((Object)new SAXHandler(this, merge)));
    }

    public void write(OutputStream os) throws Exception {
        SAXUtils.write((OutputStream)os, (SAXUtils.SAXWriter)this);
    }

    public String toString() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            this.write(bos);
            return bos.toString();
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
            return "";
        }
    }

    public void fromString(String str, boolean merge) throws Exception {
        ByteArrayInputStream bis = new ByteArrayInputStream(str.getBytes());
        this.read(bis, merge);
    }

    public void fromXML(Node w_node, boolean merge) throws Exception {
        this.resetStatus();
        if (!merge) {
            this.theScanList = new Vector();
        }
        Vector s_nodes = XMLUtils.findAllChildren((Node)w_node, (String)"Scan");
        for (Node s_node : s_nodes) {
            Scan read = Scan.fromXML(this, s_node);
            this.theScanList.add(read);
            this.addListeners(read);
        }
        this.currentScan = this.getFirstScan();
        Node gd_node = XMLUtils.findChild((Node)w_node, (String)"Structures");
        if (gd_node != null) {
            this.currentScan.getStructures().fromXML(gd_node, merge);
        }
    }

    public Element toXML(Document document) {
        if (document == null) {
            return null;
        }
        Element w_node = document.createElement("GlycanWorkspace");
        this.storeToConfiguration(true);
        w_node.appendChild(this.theConfiguration.toXML(document));
        for (Scan s : this.theScanList) {
            w_node.appendChild(s.toXML(document));
        }
        return w_node;
    }

    public void write(TransformerHandler th) throws SAXException {
        th.startElement("", "", "GlycanWorkspace", new AttributesImpl());
        this.storeToConfiguration(true);
        this.theConfiguration.write(th);
        for (Scan s : this.theScanList) {
            s.write(th, this.getGraphicOptions().SAVE_SPECTRA_CUSTOM);
        }
        th.endElement("", "", "GlycanWorkspace");
    }

    public Configuration getConfiguration() {
        return this.theConfiguration;
    }

    public static class SAXHandler
    extends SAXUtils.ObjectTreeHandler {
        private GlycanWorkspace theDocument;
        private boolean merge;

        public SAXHandler(GlycanWorkspace _doc, boolean _merge) {
            this.theDocument = _doc;
            this.merge = _merge;
        }

        public boolean isElement(String namespaceURI, String localName, String qName) {
            return qName.equals(SAXHandler.getNodeElementName());
        }

        public static String getNodeElementName() {
            return "GlycanWorkspace";
        }

        protected SAXUtils.ObjectTreeHandler getHandler(String namespaceURI, String localName, String qName) {
            if (qName.equals(GlycanDocument.SAXHandler.getNodeElementName())) {
                return new GlycanDocument.SAXHandler(new GlycanDocument((BaseWorkspace)this.theDocument), this.merge);
            }
            if (qName.equals(Scan.SAXHandler.getNodeElementName())) {
                return new Scan.SAXHandler(this.theDocument);
            }
            return null;
        }

        protected Object finalizeContent(String namespaceURI, String localName, String qName) throws SAXException {
            if (!this.merge) {
                this.theDocument.resetStatus();
                for (Scan s : this.theDocument.theScanList) {
                    this.theDocument.removeListeners(s);
                }
                this.theDocument.theScanList = new Vector();
            } else {
                this.theDocument.setChanged(true);
            }
            for (Scan o : this.getSubObjects(Scan.SAXHandler.getNodeElementName())) {
                this.theDocument.theScanList.add(o);
                this.theDocument.addListeners(o);
            }
            this.theDocument.currentScan = this.theDocument.getFirstScan();
            GlycanDocument gd = (GlycanDocument)this.getSubObject(GlycanDocument.SAXHandler.getNodeElementName(), false);
            if (gd != null) {
                this.theDocument.currentScan.getStructures().setStructures((Collection)gd.getStructures());
            }
            this.object = this.theDocument;
            return this.object;
        }
    }

    public static interface Listener {
        public void currentScanChanged(Event var1);

        public void scanAdded(Event var1);

        public void scanRemoved(Event var1);

        public void internalDocumentChanged(Event var1);
    }

    public static class Event
    extends EventObject {
        protected Scan parent;
        protected Scan child;
        protected Scan current;
        protected int index;

        public Event(GlycanWorkspace _source, Scan _parent, Scan _child, int _index, Scan _current) {
            super((Object)_source);
            this.parent = _parent;
            this.child = _child;
            this.index = _index;
            this.current = _current;
        }

        public Scan getParentScan() {
            return this.parent;
        }

        public Scan getChildScan() {
            return this.child;
        }

        public int getIndex() {
            return this.index;
        }

        public Scan getCurrentScan() {
            return this.current;
        }
    }
}

