/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.util.ArrayList;
import java.util.List;
import org.eurocarbdb.application.glycanbuilder.Configuration;
import org.eurocarbdb.application.glycanbuilder.MassOptions;
import org.eurocarbdb.application.glycanbuilder.ResidueType;

public class ProfilerOptions {
    public String[] DICTIONARIES = new String[]{"Carbbank"};
    public String DERIVATIZATION = "Und";
    public String REDUCING_END = "freeEnd";
    public String OTHER_REDEND_NAME = "";
    public double OTHER_REDEND_MASS = 0.0;
    public boolean CLEAR_EXISTING_ANNOTATIONS = false;
    public String LAST_DICT_NAME = "";
    public String LAST_TYPE = "";
    public String LAST_SOURCE = "";
    public List<String> USER_DICTIONARIES_FILENAME = new ArrayList<String>();

    public MassOptions getMassOptions() {
        if (this.REDUCING_END.equals("XXX")) {
            ResidueType re_type = ResidueType.createOtherReducingEnd((String)this.OTHER_REDEND_NAME, (double)this.OTHER_REDEND_MASS);
            return new MassOptions(this.DERIVATIZATION, re_type.getName());
        }
        return new MassOptions(this.DERIVATIZATION, this.REDUCING_END);
    }

    public void store(Configuration config) {
        config.put("ProfilerOptions", "dictionaries", this.DICTIONARIES, ',');
        config.put("ProfilerOptions", "derivatization", this.DERIVATIZATION);
        config.put("ProfilerOptions", "reducing_end", this.REDUCING_END);
        config.put("ProfilerOptions", "other_redend_name", this.OTHER_REDEND_NAME);
        config.put("ProfilerOptions", "other_redend_mass", this.OTHER_REDEND_MASS);
        config.put("ProfilerOptions", "last_dict_name", this.LAST_DICT_NAME);
        config.put("ProfilerOptions", "last_type", this.LAST_TYPE);
        config.put("ProfilerOptions", "last_source", this.LAST_SOURCE);
        config.put("ProfilerOptions", "user_dictionaries_filename", this.USER_DICTIONARIES_FILENAME, ',');
        config.put("ProfilerOptions", "clear_existing_annotations", this.CLEAR_EXISTING_ANNOTATIONS);
    }

    public void retrieve(Configuration config) {
        this.DICTIONARIES = config.get("ProfilerOptions", "dictionaries", this.DICTIONARIES, ',');
        this.DERIVATIZATION = config.get("ProfilerOptions", "derivatization", this.DERIVATIZATION);
        this.REDUCING_END = config.get("ProfilerOptions", "reducing_end", this.REDUCING_END);
        this.OTHER_REDEND_NAME = config.get("ProfilerOptions", "other_redend_name", this.OTHER_REDEND_NAME);
        this.OTHER_REDEND_MASS = config.get("ProfilerOptions", "other_redend_mass", this.OTHER_REDEND_MASS);
        this.LAST_DICT_NAME = config.get("ProfilerOptions", "last_dict_name", this.LAST_DICT_NAME);
        this.LAST_TYPE = config.get("ProfilerOptions", "last_type", this.LAST_TYPE);
        this.LAST_SOURCE = config.get("ProfilerOptions", "last_source", this.LAST_SOURCE);
        this.USER_DICTIONARIES_FILENAME = config.get("ProfilerOptions", "user_dictionaries_filename", this.USER_DICTIONARIES_FILENAME, ',');
        this.CLEAR_EXISTING_ANNOTATIONS = config.get("ProfilerOptions", "clear_existing_annotations", this.CLEAR_EXISTING_ANNOTATIONS);
    }
}

