/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.commands;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.grits.toolbox.editor.experimentdesigner.model.GraphNode;

public class GraphNodeSetConstraintCommand
extends Command {
    private final Rectangle newBounds;
    private Rectangle oldBounds;
    private final ChangeBoundsRequest request;
    private final GraphNode node;

    public GraphNodeSetConstraintCommand(GraphNode node, ChangeBoundsRequest req, Rectangle newBounds) {
        if (node == null || req == null || newBounds == null) {
            throw new IllegalArgumentException();
        }
        this.node = node;
        this.request = req;
        this.newBounds = newBounds.getCopy();
        this.setLabel("move / resize");
    }

    public boolean canExecute() {
        Object type = this.request.getType();
        return "move".equals(type) || "move children".equals(type) || "resize".equals(type) || "resize children".equals(type);
    }

    public void execute() {
        this.oldBounds = new Rectangle(this.node.getLocation(), this.node.getSize());
        this.redo();
    }

    public void redo() {
        this.node.setSize(this.newBounds.getSize());
        this.node.setLocation(this.newBounds.getLocation());
    }

    public void undo() {
        this.node.setSize(this.oldBounds.getSize());
        this.node.setLocation(this.oldBounds.getLocation());
    }
}

