/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.dialog;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.dialog.ModalDialog;
import org.grits.toolbox.core.datamodel.dialog.ProjectExplorerDialog;
import org.grits.toolbox.editor.experimentdesigner.ontology.ExperimentDesignOntologyAPI;
import org.grits.toolbox.editor.experimentdesigner.ontology.ExperimentTemplateEntry;

public class NewExperimentDialog
extends ModalDialog {
    private static final Logger logger = Logger.getLogger(NewExperimentDialog.class);
    private Text sampleNameText;
    private Label sampleNameLabel;
    private Entry sampleEntry = null;
    private Entry experimentSelected = null;
    private ExperimentTemplateEntry templateFile = null;
    private Entry toBeRemoved = null;
    protected Composite parent = null;
    Button copyFromButton = null;
    Button OKbutton;
    ComboViewer selectedTemplateCombo;
    Button fromTemplateRadio;
    Text existingDesignText;

    public NewExperimentDialog(Shell parentShell) {
        super(parentShell);
    }

    public void create() {
        super.create();
        this.setTitle("New Experiment Design");
        this.setMessage("To create a new experiment design");
    }

    protected Control createDialogArea(final Composite parent) {
        this.parent = parent;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.verticalSpacing = 10;
        parent.setLayout((Layout)gridLayout);
        GridData sampleNameData = new GridData();
        this.sampleNameLabel = new Label(parent, 0);
        this.sampleNameLabel.setText("Sample");
        this.sampleNameLabel = this.setMandatoryLabel(this.sampleNameLabel);
        this.sampleNameLabel.setLayoutData((Object)sampleNameData);
        GridData projectnameTextData = new GridData();
        projectnameTextData.grabExcessHorizontalSpace = true;
        projectnameTextData.horizontalAlignment = 4;
        projectnameTextData.horizontalSpan = 1;
        this.sampleNameText = new Text(parent, 2048);
        this.sampleNameText.setTextLimit(80);
        this.sampleNameText.setLayoutData((Object)projectnameTextData);
        if (this.sampleEntry != null) {
            this.sampleNameText.setText(this.sampleEntry.getDisplayName());
        }
        this.sampleNameText.setEditable(false);
        GridData browseButtonData = new GridData();
        Button button = new Button(parent, 8);
        button.setText("Browse");
        button.setLayoutData((Object)browseButtonData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Entry selected;
                Shell newShell = new Shell(parent.getShell(), 0x10008000);
                ProjectExplorerDialog dlg = new ProjectExplorerDialog(newShell);
                dlg.addFilter("org.grits.toolbox.property.sample");
                dlg.setTitle("Sample Selection");
                dlg.setMessage("Choose a sample");
                if (dlg.open() == 0 && (selected = dlg.getEntry()) != null) {
                    NewExperimentDialog.this.sampleEntry = selected;
                    NewExperimentDialog.this.sampleNameText.setText(NewExperimentDialog.this.sampleEntry.getDisplayName());
                    if (NewExperimentDialog.this.copyFromButton != null) {
                        NewExperimentDialog.this.copyFromButton.setEnabled(true);
                    }
                }
            }
        });
        this.createSeparator(4);
        Label label1 = new Label(parent, 0);
        label1.setText("Create Experiment Design: ");
        GridData gd = new GridData();
        gd.horizontalSpan = 4;
        label1.setLayoutData((Object)gd);
        Label emptyLabel0 = new Label(parent, 0);
        emptyLabel0.setText("");
        gd = new GridData();
        gd.horizontalSpan = 1;
        emptyLabel0.setLayoutData((Object)gd);
        Button radioButton1 = new Button(parent, 16);
        radioButton1.setSelection(true);
        radioButton1.setText("New Design");
        radioButton1.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                if (button.getSelection()) {
                    NewExperimentDialog.this.OKbutton.setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                if (button.getSelection()) {
                    NewExperimentDialog.this.OKbutton.setEnabled(true);
                }
            }
        });
        Label emptyLabel = new Label(parent, 0);
        emptyLabel.setText("");
        gd = new GridData();
        gd.horizontalSpan = 2;
        emptyLabel.setLayoutData((Object)gd);
        Label emptyLabel1 = new Label(parent, 0);
        emptyLabel1.setText("");
        gd = new GridData();
        gd.horizontalSpan = 1;
        emptyLabel1.setLayoutData((Object)gd);
        this.fromTemplateRadio = new Button(parent, 16);
        this.fromTemplateRadio.setSelection(false);
        this.fromTemplateRadio.setText("From Template");
        this.fromTemplateRadio.setEnabled(false);
        this.fromTemplateRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                if (!button.getSelection()) {
                    return;
                }
                if (NewExperimentDialog.this.selectedTemplateCombo != null) {
                    ISelection selection = NewExperimentDialog.this.selectedTemplateCombo.getSelection();
                    if (selection instanceof IStructuredSelection) {
                        Object s = ((IStructuredSelection)selection).getFirstElement();
                        if (s instanceof ExperimentTemplateEntry) {
                            NewExperimentDialog.this.templateFile = (ExperimentTemplateEntry)s;
                            NewExperimentDialog.this.setReturnCode(5);
                            NewExperimentDialog.this.OKbutton.setEnabled(true);
                        }
                    } else {
                        NewExperimentDialog.this.OKbutton.setEnabled(false);
                    }
                }
            }
        });
        this.selectedTemplateCombo = new ComboViewer(parent, 8);
        this.selectedTemplateCombo.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof List) {
                    return ((List)inputElement).toArray();
                }
                return null;
            }
        });
        this.selectedTemplateCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ExperimentTemplateEntry)element).getName();
            }
        });
        this.selectedTemplateCombo.getCombo().setLayoutData((Object)new GridData(4, 4, true, true));
        try {
            List<ExperimentTemplateEntry> templates = new ExperimentDesignOntologyAPI().getAllExperimentTemplateEntries();
            if (templates == null || templates.isEmpty()) {
                this.selectedTemplateCombo.getCombo().setEnabled(false);
                this.fromTemplateRadio.setEnabled(false);
            } else {
                this.selectedTemplateCombo.setInput(templates);
                this.selectedTemplateCombo.getCombo().setEnabled(true);
                this.selectedTemplateCombo.getCombo().select(0);
                this.fromTemplateRadio.setEnabled(true);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("org.grits.toolbox.editor.experimentdesigner Cannot load the existing templates! " + e));
            MessageDialog.openInformation((Shell)parent.getShell(), (String)"Warning", (String)("Cannot retrieve experiment design templates: " + e.getMessage()));
            this.selectedTemplateCombo.getCombo().setEnabled(false);
        }
        this.selectedTemplateCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object s;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (s = ((IStructuredSelection)selection).getFirstElement()) instanceof ExperimentTemplateEntry) {
                    NewExperimentDialog.this.templateFile = (ExperimentTemplateEntry)s;
                    if (NewExperimentDialog.this.fromTemplateRadio.getSelection()) {
                        NewExperimentDialog.this.setReturnCode(5);
                    }
                }
            }
        });
        Label emptyLabel2 = new Label(parent, 0);
        emptyLabel2.setText("");
        gd = new GridData();
        gd.horizontalSpan = 1;
        emptyLabel2.setLayoutData((Object)gd);
        Label emptyLabel3 = new Label(parent, 0);
        emptyLabel3.setText("");
        gd = new GridData();
        gd.horizontalSpan = 1;
        emptyLabel3.setLayoutData((Object)gd);
        this.copyFromButton = new Button(parent, 16);
        this.copyFromButton.setSelection(false);
        this.copyFromButton.setText("Copy existing design");
        this.copyFromButton.setToolTipText("Copy from an existing experiment design");
        this.copyFromButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.getSource();
                if (!button.getSelection()) {
                    return;
                }
                NewExperimentDialog.this.OKbutton.setEnabled(false);
                Shell newShell = new Shell(parent.getShell(), 0x10008000);
                ProjectExplorerDialog dlg = new ProjectExplorerDialog(newShell){
                    Entry selectedEntry;
                    {
                        this.selectedEntry = null;
                    }

                    protected void okPressed() {
                        NewExperimentDialog.this.experimentSelected = this.selectedEntry;
                        super.okPressed();
                    }

                    public Control createDialogArea(Composite parent) {
                        super.createDialogArea(parent);
                        this.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

                            public void selectionChanged(SelectionChangedEvent event) {
                                ISelection selection = event.getSelection();
                                if (selection.isEmpty()) {
                                    return;
                                }
                                TreeSelection to = (TreeSelection)selection;
                                if (to.size() == 1) {
                                    Entry node = (Entry)to.getFirstElement();
                                    boolean match = false;
                                    if (node.getProperty().getType().equals("org.grits.toolbox.property.sample") && !node.equals(NewExperimentDialog.this.sampleEntry)) {
                                        List children = node.getChildren();
                                        for (Entry entry : children) {
                                            if (!entry.getProperty().getType().equals("org.grits.toolbox.property.experiment")) continue;
                                            match = true;
                                            selectedEntry = entry;
                                            break;
                                        }
                                    }
                                    if (match) {
                                        this.setEnabledOKbutton(true);
                                    } else {
                                        this.setEnabledOKbutton(false);
                                    }
                                } else {
                                    this.setEnabledOKbutton(false);
                                }
                            }
                        });
                        return parent;
                    }

                    public void setEnabledOKbutton(boolean enabled) {
                        this.getButton(0).setEnabled(enabled);
                    }
                };
                dlg.setTitle("Experiment Design Selection");
                dlg.setMessage("Choose an experiment design");
                dlg.open();
                if (NewExperimentDialog.this.experimentSelected != null) {
                    NewExperimentDialog.this.setReturnCode(2);
                    NewExperimentDialog.this.existingDesignText.setText(NewExperimentDialog.this.experimentSelected.getDisplayName());
                    NewExperimentDialog.this.OKbutton.setEnabled(true);
                }
            }
        });
        this.existingDesignText = new Text(parent, 132);
        this.existingDesignText.setEditable(false);
        this.existingDesignText.setText("");
        gd = new GridData();
        gd.horizontalSpan = 1;
        gd.widthHint = 100;
        this.existingDesignText.setLayoutData((Object)gd);
        Label designLabel = new Label(parent, 4);
        designLabel.setText("");
        gd = new GridData();
        gd.horizontalSpan = 1;
        designLabel.setLayoutData((Object)gd);
        if (this.sampleEntry == null) {
            this.copyFromButton.setEnabled(false);
        }
        new Label(parent, 0);
        new Label(parent, 0);
        this.createCANCELButton(parent);
        this.createOKButton(parent);
        return parent;
    }

    protected Button createCANCELButton(Composite parent2) {
        GridData cancelData = new GridData();
        cancelData.horizontalAlignment = 0x1000008;
        cancelData.grabExcessHorizontalSpace = true;
        cancelData.horizontalSpan = 1;
        Button CancelButton = new Button(parent2, 8);
        CancelButton.setText("Cancel");
        CancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NewExperimentDialog.this.setReturnCode(1);
                NewExperimentDialog.this.close();
            }
        });
        CancelButton.setLayoutData((Object)cancelData);
        return CancelButton;
    }

    protected Button createOKButton(Composite parent2) {
        GridData okData = new GridData();
        okData.horizontalAlignment = 0x1000008;
        okData.horizontalSpan = 1;
        this.OKbutton = new Button(parent2, 8);
        this.OKbutton.setText("   OK   ");
        this.OKbutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (NewExperimentDialog.this.isValidInput()) {
                    NewExperimentDialog.this.okPressed();
                    NewExperimentDialog.this.close();
                }
            }
        });
        this.OKbutton.setLayoutData((Object)okData);
        return this.OKbutton;
    }

    public Entry createEntry() {
        return null;
    }

    public Entry getSampleEntry() {
        return this.sampleEntry;
    }

    public void setSampleEntry(Entry sampleEntry) {
        if (sampleEntry != null) {
            this.sampleEntry = sampleEntry;
        }
    }

    protected boolean isValidInput() {
        return this.checkBasicLengthCheck(this.sampleNameLabel, this.sampleNameText, 0, 80);
    }

    public Entry getToBeRemoved() {
        return this.toBeRemoved;
    }

    protected void okPressed() {
        if (this.sampleEntry == null) {
            return;
        }
        List children = this.sampleEntry.getChildren();
        this.toBeRemoved = null;
        for (Entry entry : children) {
            if (entry.getProperty().getType() != "org.grits.toolbox.property.experiment") continue;
            String[] dialogButtonLabels = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, "Open Existing Design"};
            MessageDialog questionWithViewOption = new MessageDialog(this.getShell(), "Existing Experiment Design", null, "Experiment design already exists! Do you want to overwrite it?", 6, dialogButtonLabels, 0);
            int returnCode = questionWithViewOption.open();
            if (returnCode == 0) {
                this.toBeRemoved = entry;
                this.close();
                questionWithViewOption.close();
                if (this.getReturnCode() == 2) {
                    this.setReturnCode(4);
                    break;
                }
                if (this.getReturnCode() == 5) {
                    this.setReturnCode(6);
                    break;
                }
                this.setReturnCode(3);
                break;
            }
            if (returnCode == 1) {
                questionWithViewOption.close();
                this.open();
                break;
            }
            if (returnCode != 2) break;
            this.close();
            questionWithViewOption.close();
            this.setReturnCode(0);
            break;
        }
    }

    public Entry getSelectedExperiment() {
        return this.experimentSelected;
    }

    public ExperimentTemplateEntry getTemplateFile() {
        return this.templateFile;
    }
}

