/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.dialog;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.utilShare.FileSelectionAdapter;
import org.grits.toolbox.entry.ms.property.datamodel.MSPropertyDataFile;
import org.grits.toolbox.ms.file.FileCategory;

public class MassSpecFileAddDialog
extends TitleAreaDialog {
    private Text fileNameText;
    private Combo categoryCombo;
    private ComboViewer parentComboViewer;
    private String fileName;
    private FileCategory fileCategory;
    MSPropertyDataFile parentFile;
    MSPropertyDataFile existingFile;
    boolean editingMode = false;
    private Label parentLabel;
    boolean instrumentFile = false;
    private List<MSPropertyDataFile> fileList;

    public MassSpecFileAddDialog(Shell shell, List<MSPropertyDataFile> fileList, MSPropertyDataFile parent) {
        super(shell);
        this.fileList = fileList;
        this.parentFile = parent;
        this.editingMode = false;
    }

    public MassSpecFileAddDialog(Shell shell, List<MSPropertyDataFile> fileList, MSPropertyDataFile parent, MSPropertyDataFile editing, boolean edit) {
        this(shell, fileList, parent);
        this.editingMode = edit;
        this.existingFile = editing;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Upload a new MS file");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        Monitor primary = this.getShell().getDisplay().getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = this.getShell().getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        this.getShell().setLocation(x, y);
        GridLayout gd = new GridLayout(4, false);
        container.setLayout((Layout)gd);
        container.setLayoutData((Object)new GridData(1808));
        Group qLabel = new Group(container, 4);
        qLabel.setText("Is this an instrument file?");
        qLabel.setLayout((Layout)new RowLayout(256));
        qLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        final Button yesOption = new Button((Composite)qLabel, 16);
        yesOption.setText("Yes");
        yesOption.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (yesOption.getSelection()) {
                    if (MassSpecFileAddDialog.this.parentComboViewer != null) {
                        MassSpecFileAddDialog.this.parentComboViewer.getCombo().setEnabled(false);
                        MassSpecFileAddDialog.this.parentComboViewer.getCombo().select(0);
                    }
                    if (MassSpecFileAddDialog.this.parentLabel != null) {
                        MassSpecFileAddDialog.this.parentLabel.setEnabled(false);
                    }
                    MassSpecFileAddDialog.this.instrumentFile = true;
                    MassSpecFileAddDialog.this.parentFile = null;
                    MassSpecFileAddDialog.this.categoryCombo.setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        final Button noOption = new Button((Composite)qLabel, 16);
        noOption.setText("No");
        noOption.setSelection(true);
        noOption.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (noOption.getSelection()) {
                    MassSpecFileAddDialog.this.instrumentFile = false;
                    if (!MassSpecFileAddDialog.this.editingMode || MassSpecFileAddDialog.this.existingFile == null) {
                        if (MassSpecFileAddDialog.this.parentComboViewer != null) {
                            MassSpecFileAddDialog.this.parentComboViewer.getCombo().setEnabled(true);
                        }
                        if (MassSpecFileAddDialog.this.parentLabel != null) {
                            MassSpecFileAddDialog.this.parentLabel.setEnabled(true);
                        }
                    }
                    MassSpecFileAddDialog.this.categoryCombo.setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (this.editingMode && this.existingFile != null) {
            yesOption.setSelection(this.existingFile.getIsParent().booleanValue());
            yesOption.setEnabled(false);
            noOption.setEnabled(false);
        }
        if (this.fileList != null && !this.fileList.isEmpty()) {
            this.parentLabel = new Label(container, 0);
            this.parentLabel.setText("Instrument File");
            this.parentComboViewer = new ComboViewer(container, 0);
            this.parentComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.parentComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof MSPropertyDataFile) {
                        if (((MSPropertyDataFile)((Object)element)).getOriginalFileName().isEmpty()) {
                            if (((MSPropertyDataFile)((Object)element)).getCategory() == null) {
                                return "";
                            }
                            if (((MSPropertyDataFile)((Object)element)).getCategory().equals((Object)FileCategory.ANNOTATION_CATEGORY)) {
                                return String.valueOf(FileCategory.ANNOTATION_CATEGORY.getLabel()) + ": ";
                            }
                            if (((MSPropertyDataFile)((Object)element)).getCategory().equals((Object)FileCategory.EXTERNAL_QUANTIFICATION_CATEGORY)) {
                                return String.valueOf(FileCategory.EXTERNAL_QUANTIFICATION_CATEGORY.getLabel()) + ": ";
                            }
                        } else {
                            return ((MSPropertyDataFile)((Object)element)).getOriginalFileName();
                        }
                    }
                    return "";
                }
            });
            if (this.fileList != null) {
                ArrayList<MSPropertyDataFile> comboFileList = new ArrayList<MSPropertyDataFile>(this.fileList);
                comboFileList.add(0, new MSPropertyDataFile("", "0", null, null, null, "", null, true));
                this.parentComboViewer.setInput(comboFileList);
            }
            this.parentComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = MassSpecFileAddDialog.this.parentComboViewer.getStructuredSelection();
                    if (selection != null && !selection.isEmpty()) {
                        MSPropertyDataFile parent = (MSPropertyDataFile)((Object)selection.getFirstElement());
                        MassSpecFileAddDialog.this.categoryCombo.select(MassSpecFileAddDialog.this.categoryCombo.indexOf(FileCategory.lookUp((String)parent.getCategory().name()).getLabel()));
                        MassSpecFileAddDialog.this.categoryCombo.setEnabled(false);
                    }
                }
            });
            if (this.editingMode && this.existingFile != null) {
                this.parentComboViewer.getCombo().setEnabled(false);
            }
            new Label(container, 0);
            new Label(container, 0);
        }
        Label fileNameLabel = new Label(container, 0);
        fileNameLabel.setText("File");
        this.fileNameText = new Text(container, 2056);
        this.fileNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Button browseButton = new Button(container, 8);
        browseButton.setText("Browse");
        FileSelectionAdapter fileBrowserSelectionAdapter = new FileSelectionAdapter();
        fileBrowserSelectionAdapter.setShell(container.getShell());
        fileBrowserSelectionAdapter.setText(this.fileNameText);
        fileBrowserSelectionAdapter.setFilterExtensions(new String[]{"*.*"});
        fileBrowserSelectionAdapter.setFilterNames(new String[]{"All files"});
        browseButton.addSelectionListener((SelectionListener)fileBrowserSelectionAdapter);
        if (this.editingMode && this.existingFile != null && this.existingFile.getName() != null && !this.existingFile.getName().isEmpty()) {
            this.fileNameText.setText(this.existingFile.getName());
            browseButton.setEnabled(false);
            this.fileNameText.setEnabled(false);
        }
        this.fileNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!MassSpecFileAddDialog.this.fileNameText.getText().isEmpty()) {
                    MassSpecFileAddDialog.this.setMessage(null);
                }
                MassSpecFileAddDialog.this.getButton(0).setEnabled(true);
            }
        });
        Label categoryLabel = new Label(container, 0);
        categoryLabel.setText("Category");
        this.categoryCombo = new Combo(container, 8);
        this.categoryCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.categoryCombo.setItems(FileCategory.toList());
        this.categoryCombo.select(0);
        if (this.editingMode && this.existingFile != null) {
            int i = 0;
            String[] stringArray = this.categoryCombo.getItems();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                if (item.equals(this.existingFile.getCategory())) {
                    this.categoryCombo.select(i);
                }
                ++i;
                ++n2;
            }
        }
        new Label(container, 0);
        new Label(container, 0);
        if (this.parentFile != null) {
            this.parentComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.parentFile));
        }
        return area;
    }

    protected void okPressed() {
        boolean alreadyExists = false;
        this.fileName = this.fileNameText.getText();
        if (this.parentComboViewer != null) {
            StructuredSelection select = (StructuredSelection)this.parentComboViewer.getSelection();
            if (select != null && !select.isEmpty()) {
                this.parentFile = (MSPropertyDataFile)((Object)select.getFirstElement());
                if (this.parentFile.getCategory() == null) {
                    this.parentFile = null;
                }
            } else {
                this.parentFile = null;
            }
        }
        if (this.parentFile != null && (this.fileName == null || this.fileName.trim().isEmpty())) {
            this.setMessage("File name cannot be left empty");
            return;
        }
        int s = this.categoryCombo.getSelectionIndex() == -1 ? 0 : this.categoryCombo.getSelectionIndex();
        this.fileCategory = FileCategory.findByLabel((String)this.categoryCombo.getItem(s));
        if ((!this.editingMode || this.editingMode && (this.existingFile.getName() == null || this.existingFile.getName().isEmpty())) && this.fileList != null) {
            for (MSPropertyDataFile propertyDataFile : this.fileList) {
                if (this.fileName == null || this.fileName.isEmpty() || !propertyDataFile.getName().equals(this.fileName)) continue;
                alreadyExists = true;
                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Warning", (String)"This file already exists for this entry");
                break;
            }
        }
        this.setMessage(null);
        if (!alreadyExists) {
            super.okPressed();
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public FileCategory getFileCategory() {
        return this.fileCategory;
    }

    public MSPropertyDataFile getParentFile() {
        return this.parentFile;
    }

    public boolean isInstrumentFile() {
        return this.instrumentFile;
    }
}

