/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.preference;

import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.utilShare.ComboPopupSelectionListener;
import org.grits.toolbox.entry.ms.preference.MassSpecPreference;
import org.grits.toolbox.entry.ms.preference.MassSpecSettingPreferenceUI;

public class MassSpecPreferencePage
extends PreferencePage
implements IPropertyChangeListener {
    private static final Logger logger = Logger.getLogger(MassSpecPreferencePage.class);
    private static final Font boldFont = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
    private MassSpecSettingPreferenceUI settingsPreference = null;
    protected MassSpecPreference preferences = (MassSpecPreference)MassSpecPreference.loadWorkspacePreferences();

    protected Control createContents(Composite parent) {
        this.settingsPreference = new MassSpecSettingPreferenceUI(parent, 0, this);
        this.settingsPreference.setPreferences(this.preferences);
        this.settingsPreference.setbAddExperimentType(true);
        this.settingsPreference.initComponents();
        return parent;
    }

    public boolean isValid() {
        if (!this.settingsPreference.isPageCompete()) {
            this.setErrorMessage(this.settingsPreference.getErrorMessage());
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.setValid(this.isValid());
    }

    protected void performApply() {
        this.save();
    }

    public boolean performOk() {
        this.save();
        return true;
    }

    protected void save() {
        try {
            this.settingsPreference.updateSettings();
            this.settingsPreference.updatePreferences();
            logger.debug((Object)"Time to save values!");
            this.preferences.saveValues();
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public static void setMandatoryLabel(Label label) {
        label.setText(String.valueOf(label.getText()) + "*");
        label.setFont(boldFont);
    }

    public static boolean hasChanged(String newVal, String prefVal, Set<String> prefVals) {
        return newVal != null && !newVal.equals("") && !newVal.equals("other") && !newVal.equals(prefVal) && (prefVals == null || prefVals.contains(newVal));
    }

    public static Label createLabel(Composite container, String labelName) {
        Label label = new Label(container, 0);
        label.setText(labelName);
        return label;
    }

    public static Text createText(Composite container, Label label, String selected) {
        GridData nameData = new GridData();
        label.setLayoutData((Object)nameData);
        GridData nameTextData = new GridData();
        nameTextData.grabExcessHorizontalSpace = true;
        nameTextData.horizontalAlignment = 4;
        nameTextData.horizontalSpan = 3;
        Text text = new Text(container, 2048);
        text.setText(selected != null ? selected : "");
        text.setLayoutData((Object)nameTextData);
        return text;
    }

    public static Label createSeparator(Composite parent, int span) {
        GridData separatorData = new GridData();
        separatorData.grabExcessHorizontalSpace = true;
        separatorData.horizontalAlignment = 4;
        separatorData.horizontalSpan = span;
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)separatorData);
        return separator;
    }

    public static Combo createCombo(Composite container, Label label, Set<String> values, String selected, boolean addEmpty, boolean addOther) {
        GridData derivatizationLabelData = new GridData();
        label.setLayoutData((Object)derivatizationLabelData);
        Combo combo = new Combo(container, 0x800008);
        GridData comboData = new GridData();
        comboData.grabExcessHorizontalSpace = true;
        comboData.horizontalAlignment = 4;
        comboData.horizontalSpan = 3;
        combo.setLayoutData((Object)comboData);
        int count = 0;
        if (addEmpty) {
            combo.add("");
            ++count;
        }
        int sel = -1;
        if (values != null) {
            for (String tt : values) {
                if (selected != null && tt.toString().equals(selected)) {
                    sel = count;
                }
                combo.add(tt);
                ++count;
            }
        }
        if (addOther) {
            combo.add("other");
        }
        if (sel != -1) {
            combo.select(sel);
        }
        ComboPopupSelectionListener comboListener = new ComboPopupSelectionListener();
        comboListener.setParent(container);
        combo.addSelectionListener((SelectionListener)comboListener);
        return combo;
    }
}

