/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.property;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.io.PropertyWriter;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.datamodel.property.PropertyDataFile;
import org.grits.toolbox.core.datamodel.util.DataModelSearch;
import org.grits.toolbox.core.utilShare.DeleteUtils;
import org.grits.toolbox.core.utilShare.XMLUtils;
import org.grits.toolbox.entry.ms.ImageRegistry;
import org.grits.toolbox.entry.ms.property.CopyFilesRunnableWithProgress;
import org.grits.toolbox.entry.ms.property.FileLockManager;
import org.grits.toolbox.entry.ms.property.FileLockingUtils;
import org.grits.toolbox.entry.ms.property.LockEntry;
import org.grits.toolbox.entry.ms.property.datamodel.MSPropertyDataFile;
import org.grits.toolbox.entry.ms.property.datamodel.MassSpecMetaData;
import org.grits.toolbox.entry.ms.property.io.MassSpecPropertyWriter;

public class MassSpecProperty
extends Property {
    public static final String CURRENT_VERSION = "1.3";
    private static final Logger logger = Logger.getLogger(MassSpecProperty.class);
    public static final String TYPE = "org.grits.toolbox.property.ms";
    protected static MassSpecPropertyWriter writer = new MassSpecPropertyWriter();
    private static final String folderName = "ms";
    protected static ImageDescriptor imageDescriptor = ImageRegistry.getImageDescriptor("org.grits.toolbox.entry.ms", ImageRegistry.MSImage.MASSSPEC_ICON);
    public static String CONVERT_RAW = "<to be generated by GRITS>";
    private MassSpecMetaData msSettings = null;

    public PropertyDataFile getMSSettingsFile() {
        for (PropertyDataFile file : this.getDataFiles()) {
            if (!file.getType().equals("details")) continue;
            return file;
        }
        return null;
    }

    public void adjustPropertyFilePaths() {
        for (PropertyDataFile file : this.getDataFiles()) {
            if (file.getName().contains("\\") && !File.separator.equals("\\")) {
                file.setName(file.getName().replace("\\", File.separator));
                continue;
            }
            if (!file.getName().contains("/") || File.separator.equals("/")) continue;
            file.setName(file.getName().replace("/", File.separator));
        }
    }

    public static MassSpecMetaData unmarshallSettingsFile(String sFileName) {
        MassSpecMetaData metaData = null;
        try {
            metaData = (MassSpecMetaData)XMLUtils.unmarshalObjectXML((String)sFileName, MassSpecMetaData.class);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return metaData;
    }

    public static void marshallSettingsFile(String sFileName, MassSpecMetaData metaData) {
        try {
            String xmlString = XMLUtils.marshalObjectXML((Object)metaData);
            FileWriter fileWriter = new FileWriter(sFileName);
            fileWriter.write(xmlString);
            fileWriter.close();
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public String getType() {
        return TYPE;
    }

    public PropertyWriter getWriter() {
        return writer;
    }

    public ImageDescriptor getImage() {
        return imageDescriptor;
    }

    public static String getFoldername() {
        return folderName;
    }

    public MassSpecMetaData getMassSpecMetaData() {
        return this.msSettings;
    }

    public void setMassSpecMetaData(MassSpecMetaData msSettings) {
        this.msSettings = msSettings;
    }

    public static String getFullyQualifiedFolderName(Entry entry) {
        String workspaceLocation = PropertyHandler.getVariable((String)"workspace_location");
        String projectName = DataModelSearch.findParentByType((Entry)entry, (String)"org.grits.toolbox.property.project").getDisplayName();
        String folderName = String.valueOf(workspaceLocation) + projectName + File.separator + MassSpecProperty.getFoldername();
        return folderName;
    }

    public String getFullyQualifiedMetaDataFileName(Entry entry) {
        String msSettings = this.getMSSettingsFile().getName();
        if (msSettings == null) {
            return null;
        }
        String workspaceLocation = PropertyHandler.getVariable((String)"workspace_location");
        String projectName = DataModelSearch.findParentByType((Entry)entry, (String)"org.grits.toolbox.property.project").getDisplayName();
        String mzXML = String.valueOf(workspaceLocation) + projectName + File.separator + MassSpecProperty.getFoldername() + File.separator + msSettings;
        return mzXML;
    }

    public void delete(Entry entry) throws IOException {
        String workspaceLocation = PropertyHandler.getVariable((String)"workspace_location");
        String projectName = DataModelSearch.findParentByType((Entry)entry, (String)"org.grits.toolbox.property.project").getDisplayName();
        String msPath = String.valueOf(workspaceLocation) + projectName + File.separator + MassSpecProperty.getFoldername();
        String sEntryPath = null;
        if (this.getMassSpecMetaData() != null) {
            sEntryPath = this.deleteSettings(entry, msPath);
        }
        for (PropertyDataFile file : this.getDataFiles()) {
            if (file.getName().trim().equals("")) continue;
            DeleteUtils.delete((File)new File(String.valueOf(msPath) + File.separator + file.getName()));
        }
        if (sEntryPath != null) {
            DeleteUtils.delete((File)new File(String.valueOf(msPath) + File.separator + sEntryPath));
        }
    }

    public String deleteSettings(Entry entry, String msPath) throws IOException {
        String sEntryPath = null;
        if (this.getMassSpecMetaData().getFileList() == null) {
            return sEntryPath;
        }
        for (MSPropertyDataFile file : this.getMassSpecMetaData().getFileList()) {
            if (file.getName() != null && !file.getName().trim().isEmpty()) {
                if (sEntryPath == null && file.getName().contains(File.separator)) {
                    sEntryPath = file.getName().substring(0, file.getName().indexOf(File.separator));
                }
                DeleteUtils.delete((File)new File(String.valueOf(msPath) + File.separator + file.getName()));
                try {
                    this.deleteFileFromLockFile(entry, file.getName());
                }
                catch (JAXBException e) {
                    throw new IOException("Could not remove from the lock file", e);
                }
            }
            if (file.getChildren() == null) continue;
            for (MSPropertyDataFile child : file.getChildren()) {
                if (child.getName().trim().equals("")) continue;
                if (sEntryPath == null && child.getName().contains(File.separator)) {
                    sEntryPath = child.getName().substring(0, child.getName().indexOf(File.separator));
                }
                DeleteUtils.delete((File)new File(String.valueOf(msPath) + File.separator + child.getName()));
                try {
                    this.deleteFileFromLockFile(entry, child.getName());
                }
                catch (JAXBException e) {
                    throw new IOException("Could not remove from the lock file", e);
                }
            }
        }
        return sEntryPath;
    }

    public String getLockFilePath(Entry entry) {
        PropertyDataFile msSettings = this.getMSSettingsFile();
        if (msSettings == null || msSettings.getName().indexOf(File.separator) == -1) {
            return String.valueOf(MassSpecProperty.getFullyQualifiedFolderName(entry)) + File.separator + ".lockFile";
        }
        String path = msSettings.getName().substring(0, msSettings.getName().lastIndexOf(File.separator));
        return String.valueOf(MassSpecProperty.getFullyQualifiedFolderName(entry)) + File.separator + path + File.separator + ".lockFile";
    }

    public void deleteFileFromLockFile(Entry entry, String filename) throws IOException, JAXBException {
        String path = this.getLockFilePath(entry);
        FileLockManager mng = FileLockingUtils.readLockFile(path);
        mng.deleteFile(filename);
        FileLockingUtils.writeLockFile(mng, path);
    }

    public void removeLockForFile(Entry msEntry, Entry usedBy, String filename) throws IOException, JAXBException {
        String path = this.getLockFilePath(msEntry);
        FileLockManager mng = FileLockingUtils.readLockFile(path);
        LockEntry lockEntry = new LockEntry();
        lockEntry.setEntryId(usedBy.getId());
        lockEntry.setEntryName(usedBy.getDisplayName());
        mng.removeLock(filename, lockEntry);
        FileLockingUtils.writeLockFile(mng, path);
    }

    public static Entry getMSParentEntry(Entry entry) {
        if (entry.getProperty() instanceof MassSpecProperty) {
            return entry;
        }
        if (entry.getParent() != null) {
            return MassSpecProperty.getMSParentEntry(entry.getParent());
        }
        return null;
    }

    public static boolean updateMSSettings(MassSpecMetaData metaData, String sSettingsFIle) {
        try {
            MassSpecProperty.marshallSettingsFile(sSettingsFIle, metaData);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            return false;
        }
        return true;
    }

    public static boolean copyMSFilesIntoWorkspace(List<MSPropertyDataFile> allFiles, String sMsPath, Entry newMSEntry) {
        try {
            SimpleDateFormat formater = new SimpleDateFormat("yyyy.MM.dd-HH.mm.ss.SSSS");
            Date date = new Date();
            String entryPath = formater.format(date);
            File destMSPath = new File(String.valueOf(sMsPath) + File.separator + entryPath);
            destMSPath.mkdirs();
            CopyFilesRunnableWithProgress runner = new CopyFilesRunnableWithProgress(allFiles, newMSEntry, sMsPath, entryPath);
            runner.run(null);
            if (!runner.isSuccessful()) {
                throw new Exception("Error occurred while copying files into workspace.");
            }
            if (!runner.iCanceled()) {
                String msDetails = "msMetaData.xml";
                MassSpecProperty property = (MassSpecProperty)newMSEntry.getProperty();
                MassSpecMetaData metaData = property.getMassSpecMetaData();
                String sSettingsFile = destMSPath + File.separator + msDetails;
                MassSpecProperty.updateMSSettings(metaData, sSettingsFile);
                PropertyDataFile msMetaData = MassSpecMetaData.getNewSettingsFile(String.valueOf(entryPath) + File.separator + msDetails, metaData);
                property.getDataFiles().add(msMetaData);
                return true;
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return false;
    }

    public Object clone() {
        MassSpecProperty newProp = new MassSpecProperty();
        if (this.getMassSpecMetaData() != null) {
            MassSpecMetaData settings = (MassSpecMetaData)this.getMassSpecMetaData().clone();
            newProp.setDataFiles(this.getDataFiles());
            newProp.setMassSpecMetaData(settings);
        }
        return newProp;
    }

    public Property getParentProperty() {
        return null;
    }
}

