/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.property.datamodel;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import org.apache.log4j.Logger;
import org.grits.toolbox.core.datamodel.property.PropertyDataFile;
import org.grits.toolbox.ms.file.FileCategory;
import org.grits.toolbox.ms.file.MSFile;
import org.grits.toolbox.ms.file.MSFileInfo;
import org.grits.toolbox.ms.file.reader.IMSFileReader;
import org.grits.toolbox.ms.file.reader.impl.ExtractReader;
import org.grits.toolbox.ms.file.reader.impl.MSXMLReader;
import org.grits.toolbox.ms.file.reader.impl.MzXmlReader;

public class MSPropertyDataFile
extends PropertyDataFile {
    private static final Logger logger = Logger.getLogger(MSPropertyDataFile.class);
    FileCategory category;
    String msFileType;
    List<String> purpose;
    List<MSPropertyDataFile> children;
    Boolean isParent = false;
    String originalFileName;

    public MSPropertyDataFile() {
    }

    public MSPropertyDataFile(String name, String version, String type, FileCategory category, String msFileType, String originalFile, List<String> purpose) {
        this(name, version, type, category, msFileType, originalFile, purpose, false);
    }

    public MSPropertyDataFile(String name, String version, String type, FileCategory category, String msFileType, String originalFile, List<String> purpose, boolean isParent) {
        super(name, version, type);
        this.category = category;
        this.msFileType = msFileType;
        this.purpose = purpose;
        this.isParent = isParent;
        this.originalFileName = originalFile;
    }

    public MSPropertyDataFile(String name, String version, String type) {
        super(name, version, type);
    }

    public static MSPropertyDataFile getCurrentVersionFileFromLegacyVersion(String name, String version, String type) {
        MSPropertyDataFile pdf = new MSPropertyDataFile(name, version, type);
        if (pdf.getType().equals("TabDelimited") || pdf.getType().equals("ThermoExtract") || pdf.getType().equals("MascotGeneric")) {
            pdf.setCategory(FileCategory.EXTERNAL_QUANTIFICATION_CATEGORY);
            pdf.setMSFileType("Processed");
        } else if (pdf.getType().equals(MSFileInfo.getType((String)"MSFULL", (String)"mzXML"))) {
            pdf.setCategory(FileCategory.EXTERNAL_QUANTIFICATION_CATEGORY);
            pdf.setMSFileType("Converted");
            pdf.setType("mzXML");
        } else if (pdf.getType().equals(MSFileInfo.getType((String)"MSFULL", (String)"mzML"))) {
            pdf.setCategory(FileCategory.EXTERNAL_QUANTIFICATION_CATEGORY);
            pdf.setMSFileType("Converted");
            pdf.setType("mzML");
        } else if (pdf.getType().equals(MSFileInfo.getType((String)"MS", (String)"mzXML"))) {
            pdf.setCategory(FileCategory.ANNOTATION_CATEGORY);
            pdf.setMSFileType("Converted");
            pdf.setType("mzXML");
        } else if (pdf.getType().equals(MSFileInfo.getType((String)"MS", (String)"mzML"))) {
            pdf.setCategory(FileCategory.ANNOTATION_CATEGORY);
            pdf.setMSFileType("Converted");
            pdf.setType("mzML");
        } else if (pdf.getType().equals(MSFileInfo.getType((String)"MSFULL", (String)"RAW"))) {
            pdf.setCategory(FileCategory.EXTERNAL_QUANTIFICATION_CATEGORY);
            pdf.setMSFileType("Instrument");
            pdf.setType("RAW");
        } else if (pdf.getType().equals(MSFileInfo.getType((String)"MS", (String)"RAW"))) {
            pdf.setCategory(FileCategory.ANNOTATION_CATEGORY);
            pdf.setMSFileType("Instrument");
            pdf.setType("RAW");
        }
        ArrayList<String> purposes = new ArrayList<String>();
        if (type != null && MSFileInfo.getMSType((String)type).equals("MS")) {
            purposes.add(FileCategory.ANNOTATION_CATEGORY.getLabel());
        } else {
            purposes.add(FileCategory.EXTERNAL_QUANTIFICATION_CATEGORY.getLabel());
        }
        pdf.setPurpose(purposes);
        pdf.setOriginalFileName(name);
        return pdf;
    }

    public void setOriginalFileName(String originalFileName) {
        this.originalFileName = originalFileName;
    }

    @XmlAttribute
    public String getOriginalFileName() {
        return this.originalFileName;
    }

    @XmlAttribute
    public FileCategory getCategory() {
        return this.category;
    }

    public void setCategory(FileCategory category) {
        this.category = category;
    }

    public List<String> getPurpose() {
        return this.purpose;
    }

    public void setPurpose(List<String> purpose) {
        this.purpose = purpose;
    }

    public String getPurposeString() {
        if (this.purpose == null) {
            return "default";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String string : this.purpose) {
            if (first) {
                sb.append(string);
                first = false;
                continue;
            }
            sb.append("," + string);
        }
        return sb.toString();
    }

    public List<MSPropertyDataFile> getChildren() {
        return this.children;
    }

    public void setChildren(List<MSPropertyDataFile> children) {
        this.children = children;
    }

    public void addChild(MSPropertyDataFile file) {
        if (this.children == null) {
            this.children = new ArrayList<MSPropertyDataFile>();
        }
        this.children.add(file);
    }

    public boolean containsChild(MSPropertyDataFile file) {
        if (this.children == null) {
            return false;
        }
        for (MSPropertyDataFile msPropertyDataFile : this.children) {
            if (!msPropertyDataFile.getName().equals(file.getName())) continue;
            return true;
        }
        return false;
    }

    public void setIsParent(Boolean isParent) {
        this.isParent = isParent;
    }

    @XmlAttribute
    public Boolean getIsParent() {
        return this.isParent;
    }

    public void setMSFileType(String msFileType) {
        this.msFileType = msFileType;
    }

    @XmlAttribute
    public String getMSFileType() {
        return this.msFileType;
    }

    public MSFile getMSFileWithReader(String pathToFile, String experimentType) {
        MSFile msFile = new MSFile();
        msFile.setFileName(String.valueOf(pathToFile) + File.separator + this.getName());
        msFile.setExperimentType(experimentType);
        msFile.setCategory(this.getCategory());
        msFile.setVersion(this.getVersion());
        msFile.setReader(this.getReaderForFile());
        return msFile;
    }

    public IMSFileReader getReaderForFile() {
        switch (this.getCategory()) {
            case ANNOTATION_CATEGORY: {
                if (!this.getType().equals("mzML") && !this.getType().equals("mzXML")) break;
                return new MzXmlReader();
            }
            case EXTERNAL_QUANTIFICATION_CATEGORY: {
                if (this.getType().equals("ThermoExtract")) {
                    return new ExtractReader();
                }
                if (!this.getType().equals("mzML") && !this.getType().equals("mzXML")) break;
                return new MSXMLReader();
            }
        }
        return null;
    }

    public static String getFormattedName(MSPropertyDataFile mspdf) {
        String sFilePath = mspdf.getName();
        int inx = sFilePath.lastIndexOf(File.separator);
        String sFileName = sFilePath;
        if (inx >= 0) {
            sFileName = sFilePath.substring(inx + 1);
        }
        return sFileName;
    }

    public static String getLegacyExternalQuantAlias(MSPropertyDataFile mspdf) {
        if (mspdf.getType().equals("mzXML") || mspdf.getType().equals("mzML")) {
            return "Full MS";
        }
        return "Extract";
    }

    public MSFile getMSFileWithReader(String msPath, String msExperimentType, boolean displayOnly) {
        MSFile msFile = this.getMSFileWithReader(msPath, msExperimentType);
        if (this.getType().equals("mzML") || this.getType().equals("mzXML")) {
            msFile.setReader((IMSFileReader)new MzXmlReader());
        }
        return msFile;
    }

    public Object clone() {
        MSPropertyDataFile clonePdf = new MSPropertyDataFile();
        clonePdf.setCategory(this.getCategory());
        clonePdf.setIsParent(this.isParent);
        clonePdf.setMSFileType(this.getMSFileType());
        clonePdf.setName(this.getName());
        clonePdf.setOriginalFileName(this.getOriginalFileName());
        clonePdf.setPurpose(this.getPurpose());
        clonePdf.setType(this.getType());
        clonePdf.setVersion(this.getVersion());
        if (this.getChildren() != null) {
            for (MSPropertyDataFile child : this.getChildren()) {
                clonePdf.addChild((MSPropertyDataFile)((Object)child.clone()));
            }
        }
        return clonePdf;
    }
}

