/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.editor;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.dnd.TemplateTransferDragSourceListener;
import org.eclipse.gef.dnd.TemplateTransferDropTargetListener;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.PrintAction;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.DataModelHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.io.ProjectFileHandler;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.editor.ViewInput;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.editor.experimentdesigner.actions.InsertExperimentDesignAction;
import org.grits.toolbox.editor.experimentdesigner.actions.SaveExperimentTemplateAction;
import org.grits.toolbox.editor.experimentdesigner.actions.SelectProtocolAction;
import org.grits.toolbox.editor.experimentdesigner.commands.ResizeAllNodesCommand;
import org.grits.toolbox.editor.experimentdesigner.config.ImageRegistry;
import org.grits.toolbox.editor.experimentdesigner.editor.GraphEditorContextMenuProvider;
import org.grits.toolbox.editor.experimentdesigner.editor.GraphEditorPaletteFactory;
import org.grits.toolbox.editor.experimentdesigner.model.Connection;
import org.grits.toolbox.editor.experimentdesigner.model.ExperimentGraph;
import org.grits.toolbox.editor.experimentdesigner.model.GraphNode;
import org.grits.toolbox.editor.experimentdesigner.model.InputNode;
import org.grits.toolbox.editor.experimentdesigner.model.OutputNode;
import org.grits.toolbox.editor.experimentdesigner.model.Parameter;
import org.grits.toolbox.editor.experimentdesigner.model.ProtocolNode;
import org.grits.toolbox.editor.experimentdesigner.parts.GraphNodeEditPart;
import org.grits.toolbox.editor.experimentdesigner.parts.GraphNodeEditPartFactory;
import org.grits.toolbox.editor.experimentdesigner.print.PrintExperimentGraph;
import org.grits.toolbox.editor.experimentdesigner.property.ExperimentProperty;
import org.grits.toolbox.entry.sample.model.Component;
import org.grits.toolbox.entry.sample.model.Sample;
import org.grits.toolbox.entry.sample.property.SampleProperty;

public class GraphEditor
extends GraphicalEditorWithFlyoutPalette {
    private static final Logger logger = Logger.getLogger(GraphEditor.class);
    public static final String SAVE_AS_TEMPLATE = "SaveAsTemplate";
    public static final String INSERT_DESIGN = "InsertDesign";
    public static final String RESIZE_ALL = "ResizeAllNodes";
    private ExperimentGraph graph;
    @Inject
    ESelectionService selectionService;
    boolean graphModelChanged = false;
    private static PaletteRoot PALETTE_MODEL;

    public GraphEditor() {
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
    }

    public DefaultEditDomain getEditDomain() {
        return super.getEditDomain();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        super.selectionChanged(part, selection);
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setEditPartFactory((EditPartFactory)new GraphNodeEditPartFactory());
        viewer.setRootEditPart((RootEditPart)new ScalableFreeformRootEditPart());
        GraphicalViewerKeyHandler keyHandler = new GraphicalViewerKeyHandler(viewer);
        keyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
        keyHandler.put(KeyStroke.getPressed((char)'\b', (int)8, (int)0), this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
        viewer.setKeyHandler((KeyHandler)keyHandler);
        GraphEditorContextMenuProvider cmProvider = new GraphEditorContextMenuProvider((EditPartViewer)viewer, this.getActionRegistry());
        viewer.setContextMenu((MenuManager)cmProvider);
        this.getSite().registerContextMenu((MenuManager)cmProvider, (ISelectionProvider)viewer);
    }

    public GraphicalViewer getViewer() {
        return this.getGraphicalViewer();
    }

    protected void createActions() {
        super.createActions();
        ActionRegistry actionRegistry = this.getActionRegistry();
        SelectProtocolAction protocolCopyAction = new SelectProtocolAction(this);
        actionRegistry.registerAction((IAction)protocolCopyAction);
        SaveExperimentTemplateAction saveTemplateAction = new SaveExperimentTemplateAction(this);
        saveTemplateAction.setText("Save as Template");
        actionRegistry.registerAction((IAction)saveTemplateAction);
        InsertExperimentDesignAction insertTemplateAction = new InsertExperimentDesignAction(this);
        insertTemplateAction.setText("Insert from Template");
        actionRegistry.registerAction((IAction)insertTemplateAction);
        actionRegistry.registerAction((IAction)new PrintAction((IWorkbenchPart)this){

            public void run() {
                logger.info((Object)"Print action starts");
                GraphicalViewer viewer = (GraphicalViewer)this.getWorkbenchPart().getAdapter(GraphicalViewer.class);
                PrintDialog dialog = new PrintDialog(viewer.getControl().getShell(), 0);
                PrinterData data = dialog.open();
                if (data != null) {
                    PrintExperimentGraph op = new PrintExperimentGraph(new Printer(data), viewer, GraphEditor.this.graph);
                    op.run(this.getWorkbenchPart().getTitle());
                }
                logger.info((Object)"Done printing");
            }

            public String getId() {
                return ActionFactory.PRINT.getId();
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageRegistry.getImageDescriptor(ImageRegistry.ExperimentDesignerImage.PRINTICON);
            }
        });
        actionRegistry.registerAction((IAction)new Action("Resize All Nodes"){

            public void run() {
                logger.info((Object)"Resizing nodes");
                if (GraphEditor.this.graph != null) {
                    ResizeAllNodesCommand resize = new ResizeAllNodesCommand(GraphEditor.this.graph);
                    GraphEditor.this.getEditDomain().getCommandStack().execute((Command)resize);
                }
                logger.info((Object)"Done resizing");
            }

            public String getId() {
                return GraphEditor.RESIZE_ALL;
            }

            public String getToolTipText() {
                return "Make all nodes the same size (as the largest node)";
            }
        });
    }

    public void commandStackChanged(EventObject event) {
        this.firePropertyChange(257);
        super.commandStackChanged(event);
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        return new PaletteViewerProvider((EditDomain)this.getEditDomain()){

            protected void configurePaletteViewer(PaletteViewer viewer) {
                super.configurePaletteViewer(viewer);
                viewer.addDragSourceListener((TransferDragSourceListener)new TemplateTransferDragSourceListener((EditPartViewer)viewer));
            }
        };
    }

    private TransferDropTargetListener createTransferDropTargetListener() {
        return new TemplateTransferDropTargetListener((EditPartViewer)this.getGraphicalViewer()){

            protected CreationFactory getFactory(Object template) {
                if (template instanceof CreationFactory) {
                    return (CreationFactory)template;
                }
                return new SimpleFactory((Class)template);
            }
        };
    }

    public void doSave(IProgressMonitor monitor) {
        IEditorInput input = this.getEditorInput();
        if (input instanceof ViewInput) {
            Entry entry = ((ViewInput)input).getEntry();
            String exampleFolderLocation = ExperimentProperty.getExperimentDesignLocation(entry);
            ExperimentProperty experimentProperty = (ExperimentProperty)entry.getProperty();
            String fileName = experimentProperty.getExperimentFile().getName();
            String fileLocation = String.valueOf(exampleFolderLocation) + File.separator + fileName;
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ExperimentGraph.class});
                Marshaller marshaller = context.createMarshaller();
                marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
                marshaller.setProperty("jaxb.formatted.output", (Object)true);
                marshaller.marshal((Object)this.graph, (OutputStream)os);
                FileWriter fileWriter = new FileWriter(fileLocation);
                fileWriter.write(os.toString((String)marshaller.getProperty("jaxb.encoding")));
                fileWriter.close();
                os.close();
                this.getCommandStack().markSaveLocation();
                this.graphModelChanged = false;
                this.firePropertyChange(257);
            }
            catch (IOException | JAXBException e) {
                ErrorUtils.createErrorMessageBox((Shell)Display.getCurrent().getActiveShell(), (String)"Cannot save the Experiment", (Exception)e);
                logger.error((Object)"org.grits.toolbox.editor.experimentdesigner Cannot save the Experiment", e);
            }
        } else {
            ErrorUtils.createErrorMessageBox((Shell)Display.getCurrent().getActiveShell(), (String)"Cannot save the Experiment. Internal Error!");
            logger.error((Object)"org.grits.toolbox.editor.experimentdesigner Cannot save the Experiment - Internal Error");
        }
    }

    public void doSaveAs() {
    }

    protected void setInput(IEditorInput input) {
        block8: {
            super.setInput(input);
            try {
                if (!(input instanceof ViewInput)) break block8;
                Entry entry = ((ViewInput)input).getEntry();
                String exampleFolderLocation = ExperimentProperty.getExperimentDesignLocation(entry);
                ExperimentProperty experimentProperty = (ExperimentProperty)entry.getProperty();
                String fileName = experimentProperty.getExperimentFile().getName();
                String fileLocation = String.valueOf(exampleFolderLocation) + File.separator + fileName;
                File experimentFile = new File(fileLocation);
                FileInputStream inputStream = new FileInputStream(experimentFile.getAbsolutePath());
                InputStreamReader reader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ExperimentGraph.class});
                Unmarshaller unmarshaller = context.createUnmarshaller();
                this.graph = (ExperimentGraph)unmarshaller.unmarshal((Reader)reader);
                this.graph.setProjectEntry(entry.getParent().getParent());
                this.graph.setConnectionsToNodes();
                List children = this.graph.getChildren();
                Point location = new Point(50, 100);
                int locationY = 100;
                for (Object node : children) {
                    if (!(node instanceof GraphNode)) continue;
                    if (((GraphNode)node).getLocation() == null) {
                        ((GraphNode)node).setLocation(location);
                        location = location.translate(100, 0);
                        continue;
                    }
                    locationY = Math.max(locationY, ((GraphNode)node).getLocation().y);
                }
                reader.close();
                inputStream.close();
                if (!entry.getParent().getDisplayName().equals(entry.getDisplayName())) {
                    try {
                        ProjectFileHandler.renameEntryInProject((Entry)entry, (String)entry.getParent().getDisplayName());
                        DataModelHandler dm = PropertyHandler.getDataModel();
                        dm.renameEntry(entry, entry.getParent().getDisplayName());
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        ErrorUtils.createErrorMessageBox((Shell)Display.getCurrent().getActiveShell(), (String)"Unable to update project xml", (Exception)e);
                    }
                }
                this.setPartName(entry.getDisplayName());
                this.reloadInputOutputNodes(entry, locationY);
            }
            catch (IOException e) {
                ErrorUtils.createErrorMessageBox((Shell)Display.getCurrent().getActiveShell(), (String)"Cannot create the Experiment. Using default model", (Exception)e);
                logger.error((Object)"org.grits.toolbox.editor.experimentdesigner Cannot create the Experiment. Using default model", (Throwable)e);
                this.graph = new ExperimentGraph();
            }
            catch (JAXBException e) {
                ErrorUtils.createErrorMessageBox((Shell)Display.getCurrent().getActiveShell(), (String)"Cannot Load the Experiment. Using default model", (Exception)((Object)e));
                logger.warn((Object)"org.grits.toolbox.editor.experimentdesigner Cannot Load the Experiment. Using default model", (Throwable)e);
                this.graph = new ExperimentGraph();
            }
        }
    }

    private void reloadInputOutputNodes(Entry entry, int lastYIndex) throws FileNotFoundException, JAXBException, UnsupportedEncodingException {
        Entry sampleEntry = entry.getParent();
        if (sampleEntry != null) {
            Sample sample = SampleProperty.loadAnalyte((Entry)sampleEntry);
            List components = sample.getComponents();
            Point originalLocation = new Point(50, 10);
            ArrayList<Component> missingComponents = new ArrayList<Component>();
            HashMap<InputNode, Boolean> inputNodeMap = new HashMap<InputNode, Boolean>();
            for (Component component : components) {
                boolean compFound = false;
                List existingNodes = this.graph.getChildren();
                for (Object object : existingNodes) {
                    InputNode inputNode;
                    Boolean matchedAlready;
                    if (!(object instanceof InputNode) || (matchedAlready = (Boolean)inputNodeMap.get(inputNode = (InputNode)object)) != null && matchedAlready.booleanValue()) continue;
                    inputNodeMap.put(inputNode, new Boolean(false));
                    if (inputNode.getComponentId() != component.getComponentId()) continue;
                    compFound = true;
                    inputNodeMap.remove(inputNode);
                    inputNodeMap.put(inputNode, new Boolean(true));
                    if (inputNode.getLabel().equals(component.getLabel())) break;
                    inputNode.setLabelModify(component.getLabel());
                    break;
                }
                if (compFound) continue;
                missingComponents.add(component);
            }
            for (InputNode node : inputNodeMap.keySet()) {
                Boolean exists = (Boolean)inputNodeMap.get(node);
                if (exists != null && exists.booleanValue()) {
                    originalLocation = node.getLocation();
                    continue;
                }
                originalLocation = originalLocation.translate(-100, 0);
                List<Connection> sourceConnections = node.getSourceConnections();
                boolean wasRemoved = this.graph.removeChild(node);
                if (!wasRemoved) continue;
                for (Connection conn : sourceConnections) {
                    conn.disconnect();
                }
            }
            for (Component component : missingComponents) {
                InputNode newNode = new InputNode();
                newNode.setLabel(component.getLabel());
                newNode.setColor(ColorConstants.red);
                newNode.setUri(component.getUri());
                newNode.setComponentId(component.getComponentId());
                newNode.setDescription(component.getDescription());
                originalLocation = originalLocation.translate(100, 0);
                newNode.setLocation(originalLocation);
                this.graph.addChild(newNode);
            }
            List children = sampleEntry.getChildren();
            ArrayList<Entry> missingOutput = new ArrayList<Entry>();
            originalLocation = new Point(50, lastYIndex + 100);
            HashMap<OutputNode, Boolean> outputNodeMap = new HashMap<OutputNode, Boolean>();
            for (Entry outputEntry : children) {
                Property prop = outputEntry.getProperty();
                if (prop.getType() == "org.grits.toolbox.property.experiment") continue;
                boolean entryFound = false;
                List existingNodes = this.graph.getChildren();
                for (Object object : existingNodes) {
                    OutputNode outputNode;
                    Boolean matchedAlready;
                    if (!(object instanceof OutputNode) || (matchedAlready = (Boolean)outputNodeMap.get(outputNode = (OutputNode)object)) != null && matchedAlready.booleanValue()) continue;
                    outputNodeMap.put(outputNode, new Boolean(false));
                    if (!outputNode.getLabel().equalsIgnoreCase(outputEntry.getDisplayName())) continue;
                    entryFound = true;
                    outputNodeMap.remove(outputNode);
                    outputNodeMap.put(outputNode, new Boolean(true));
                    break;
                }
                if (entryFound) continue;
                missingOutput.add(outputEntry);
            }
            for (OutputNode node : outputNodeMap.keySet()) {
                Boolean exists = (Boolean)outputNodeMap.get(node);
                if (exists != null && exists.booleanValue()) {
                    originalLocation = node.getLocation();
                    continue;
                }
                originalLocation = originalLocation.translate(-100, 0);
                List<Connection> targetConnections = node.getTargetConnections();
                boolean wasRemoved = this.graph.removeChild(node);
                if (!wasRemoved) continue;
                for (Connection conn : targetConnections) {
                    conn.disconnect();
                }
            }
            for (Entry entry2 : missingOutput) {
                OutputNode newNode = new OutputNode();
                newNode.setLabel(entry2.getDisplayName());
                newNode.setLocation(originalLocation.translate(100, 0));
                newNode.setColor(ColorConstants.lightGreen);
                this.graph.addChild(newNode);
            }
        } else {
            throw new RuntimeException("Internal Error! Experiment design does not have the connection to its input!");
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected PaletteRoot getPaletteRoot() {
        if (PALETTE_MODEL == null) {
            PALETTE_MODEL = GraphEditorPaletteFactory.createPalette();
        }
        return PALETTE_MODEL;
    }

    public ExperimentGraph getModel() {
        return this.graph;
    }

    protected void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setContents((Object)this.getModel());
        viewer.addDropTargetListener(this.createTransferDropTargetListener());
        EditPart root = viewer.getContents();
        for (Object node : root.getChildren()) {
            if (!(node instanceof GraphNodeEditPart)) continue;
            ((GraphNodeEditPart)node).updateBoundsForModel();
        }
    }

    public boolean isDirty() {
        if (this.graphModelChanged) {
            return true;
        }
        return super.isDirty();
    }

    public void refreshProtocolNode(ProtocolNode protocol) {
        if (protocol != null) {
            this.graphModelChanged = true;
            this.firePropertyChange(257);
        }
    }

    public void refreshParameter(Parameter parameter) {
        if (parameter != null) {
            this.graphModelChanged = true;
            this.firePropertyChange(257);
        }
    }

    public void refreshPalette(String newTemplate) {
        if (newTemplate != null) {
            PALETTE_MODEL = GraphEditorPaletteFactory.createPalette();
            this.getEditDomain().setPaletteRoot(this.getPaletteRoot());
        }
    }

    public void setGraphModelChanged(boolean b) {
        this.graphModelChanged = true;
        this.firePropertyChange(257);
    }
}

