/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.io.ms.annotation.process.export;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.grits.toolbox.datamodel.ms.annotation.tablemodel.MSAnnotationTableDataObject;
import org.grits.toolbox.display.control.table.datamodel.GRITSColumnHeader;
import org.grits.toolbox.display.control.table.datamodel.GRITSListDataRow;
import org.grits.toolbox.io.ms.annotation.listener.ExcelListener;

public class MSAnnotationWriterExcel {
    protected Workbook m_objWorkbook = null;
    protected Sheet m_objSheet = null;
    protected int m_iRowCounter = 0;
    protected String m_file = null;
    protected ExcelListener m_listener = null;
    protected MSAnnotationTableDataObject m_msAnnotationDataObject = null;
    protected int m_lastVisibleColInx = -1;
    protected Map<Integer, Integer> dataToPrefColumn = null;
    protected int iSheetCount = 1;
    public static final int EXCEL_DEFAULT_COLUMN_WIDTH = 3500;
    public static final int EXCEL_MAX_NUM_ROWS = 20000;

    public void createNewFile(String a_sOutputFile, MSAnnotationTableDataObject a_msAnnotationDataObject, int m_lastVisibleColInx, ExcelListener a_listener) {
        this.m_objWorkbook = new HSSFWorkbook();
        this.m_msAnnotationDataObject = a_msAnnotationDataObject;
        this.m_listener = a_listener;
        this.m_file = a_sOutputFile;
        this.m_lastVisibleColInx = m_lastVisibleColInx;
    }

    public void createSheet() {
        this.m_objSheet = this.m_objWorkbook.createSheet(this.m_msAnnotationDataObject.getAnalysisName() != null ? String.valueOf(this.m_msAnnotationDataObject.getAnalysisName()) + "_" + this.iSheetCount : "MS Annotation Results_" + this.iSheetCount);
        if (this.iSheetCount == 1) {
            this.determineCollapsedColumnPositions();
        }
        this.m_iRowCounter = 0;
        this.writeHeadline();
        ++this.iSheetCount;
    }

    public void close() throws IOException {
        FileOutputStream t_fos = new FileOutputStream(this.m_file);
        this.m_objWorkbook.write((OutputStream)t_fos);
        t_fos.close();
    }

    public void writeEmptyLine() {
        ++this.m_iRowCounter;
    }

    public MSAnnotationTableDataObject getAnnotationDataObject() {
        return this.m_msAnnotationDataObject;
    }

    protected void determineCollapsedColumnPositions() {
        int iColNum;
        GRITSColumnHeader header;
        ArrayList<Integer> alPrefColNums = new ArrayList<Integer>();
        ArrayList headerRow = (ArrayList)this.getAnnotationDataObject().getLastHeader();
        int i = 0;
        while (i < headerRow.size()) {
            header = (GRITSColumnHeader)headerRow.get(i);
            iColNum = this.getAnnotationDataObject().getTablePreferences().getPreferenceSettings().getColumnPosition(header);
            if (iColNum != -1) {
                alPrefColNums.add(iColNum);
            }
            ++i;
        }
        Collections.sort(alPrefColNums);
        this.dataToPrefColumn = new HashMap<Integer, Integer>();
        i = 0;
        while (i < headerRow.size()) {
            header = (GRITSColumnHeader)headerRow.get(i);
            iColNum = this.getAnnotationDataObject().getTablePreferences().getPreferenceSettings().getColumnPosition(header);
            if (iColNum != -1) {
                int iCollapsedColNum = alPrefColNums.indexOf(iColNum);
                this.dataToPrefColumn.put(i, iCollapsedColNum);
            }
            ++i;
        }
    }

    public void writeHeadline() {
        Row t_row = this.m_objSheet.createRow(this.m_iRowCounter);
        ArrayList headerRow = (ArrayList)this.getAnnotationDataObject().getLastHeader();
        int i = 0;
        while (i < headerRow.size()) {
            GRITSColumnHeader header = (GRITSColumnHeader)headerRow.get(i);
            int iColNum = this.getPreferredCellNumber(i);
            if (iColNum != -1) {
                Cell t_cell = t_row.createCell(iColNum);
                t_cell.setCellValue(header.getLabel());
                t_cell.setCellType(1);
                this.m_objSheet.setColumnWidth(iColNum, 3500);
            }
            ++i;
        }
        this.writeEmptyLine();
    }

    public void writeFileName() {
        Row t_row = this.m_objSheet.createRow(this.m_iRowCounter);
        Cell t_cell = t_row.createCell(0);
        t_cell.setCellValue("Project file");
        t_cell.setCellType(1);
        t_cell = t_row.createCell(2);
        t_cell.setCellValue(this.m_msAnnotationDataObject.getAnalysisName());
        t_cell.setCellType(1);
        ++this.m_iRowCounter;
    }

    protected void performPreWriteInits() {
        if (this.m_objSheet == null || this.m_iRowCounter == 19999) {
            this.createSheet();
        }
    }

    public void writeRow(int _iRow, boolean bInvisible) {
        this.performPreWriteInits();
        GRITSListDataRow alRow = (GRITSListDataRow)this.getAnnotationDataObject().getTableData().get(_iRow);
        Row excelRow = this.m_objSheet.createRow(this.m_iRowCounter);
        int iColNum = 0;
        while (iColNum < alRow.getDataRow().size()) {
            this.writeCell(excelRow, alRow.getDataRow(), iColNum, this.getPreferredCellNumber(iColNum), bInvisible);
            ++iColNum;
        }
        this.writeEmptyLine();
    }

    protected int getPreferredCellNumber(int _iColNum) {
        if (this.dataToPrefColumn.containsKey(_iColNum)) {
            return this.dataToPrefColumn.get(_iColNum);
        }
        return -1;
    }

    protected void writeCell(Row _excelRow, ArrayList<Object> _tableRow, int _iDataColNum, int _iPrefColNum, boolean bInvisible) {
        if (_iPrefColNum < 0) {
            return;
        }
        if (bInvisible && _iDataColNum > this.m_lastVisibleColInx) {
            return;
        }
        Object oVal = _tableRow.get(_iDataColNum);
        if (oVal == null) {
            return;
        }
        Cell t_cell = _excelRow.createCell(_iPrefColNum);
        if (oVal instanceof Number) {
            if (oVal instanceof Integer) {
                t_cell.setCellValue((double)((Integer)oVal).intValue());
            } else {
                t_cell.setCellValue(new Double(oVal.toString()).doubleValue());
            }
            t_cell.setCellType(0);
        } else if (oVal instanceof Boolean) {
            t_cell.setCellValue(((Boolean)oVal).booleanValue());
            t_cell.setCellType(4);
        } else {
            t_cell.setCellValue(oVal.toString());
            t_cell.setCellType(1);
        }
        this.m_objSheet.setColumnWidth(_iPrefColNum, 3500);
    }

    protected void errorMessage(String a_message) {
        if (this.m_listener != null) {
            this.m_listener.message(a_message);
        }
    }
}

