/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.views.tabbed;

import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.editor.IEntryEditorPart;
import org.grits.toolbox.core.preference.share.PreferenceEntity;
import org.grits.toolbox.datamodel.ms.annotation.glycan.preference.MSGlycanAnnotationSummaryViewerPreference;
import org.grits.toolbox.datamodel.ms.annotation.glycan.preference.MSGlycanAnnotationViewerPreference;
import org.grits.toolbox.datamodel.ms.annotation.glycan.preference.cartoon.MSGlycanAnnotationCartoonPreferences;
import org.grits.toolbox.datamodel.ms.annotation.glycan.preference.cartoon.MSGlycanAnnotationCartoonPreferencesLoader;
import org.grits.toolbox.datamodel.ms.preference.MassSpecViewerPreference;
import org.grits.toolbox.datamodel.ms.tablemodel.FillTypes;
import org.grits.toolbox.display.control.table.preference.TableViewerPreference;
import org.grits.toolbox.entry.ms.annotation.command.ViewRowChooserInTabCommandExecutor;
import org.grits.toolbox.entry.ms.annotation.glycan.dialog.MSGlycanAnnotationCustomAnnotationDialog;
import org.grits.toolbox.entry.ms.annotation.glycan.dialog.MSGlycanAnnotationPeakIntensityApplyDialog;
import org.grits.toolbox.entry.ms.annotation.glycan.dialog.MSGlycanAnnotationStandardQuantApplyDialog;
import org.grits.toolbox.entry.ms.annotation.glycan.process.loader.MSGlycanAnnotationTableDataProcessor;
import org.grits.toolbox.entry.ms.annotation.glycan.property.MSGlycanAnnotationEntityProperty;
import org.grits.toolbox.entry.ms.annotation.glycan.tablehelpers.MSGlycanAnnotationSummaryTable;
import org.grits.toolbox.entry.ms.annotation.glycan.tablehelpers.MSGlycanAnnotationTable;
import org.grits.toolbox.entry.ms.annotation.glycan.views.tabbed.MSGlycanAnnotationDetails;
import org.grits.toolbox.entry.ms.annotation.glycan.views.tabbed.MSGlycanAnnotationFilterView;
import org.grits.toolbox.entry.ms.annotation.glycan.views.tabbed.MSGlycanAnnotationMultiPageViewerWorker;
import org.grits.toolbox.entry.ms.annotation.glycan.views.tabbed.MSGlycanAnnotationOtherSettingsView;
import org.grits.toolbox.entry.ms.annotation.glycan.views.tabbed.MSGlycanAnnotationPeaksView;
import org.grits.toolbox.entry.ms.annotation.glycan.views.tabbed.MSGlycanAnnotationPropertyView;
import org.grits.toolbox.entry.ms.annotation.glycan.views.tabbed.MSGlycanAnnotationQuantificationView;
import org.grits.toolbox.entry.ms.annotation.glycan.views.tabbed.MSGlycanAnnotationScansView;
import org.grits.toolbox.entry.ms.annotation.glycan.views.tabbed.MSGlycanAnnotationSpectraView;
import org.grits.toolbox.entry.ms.annotation.glycan.views.tabbed.MSGlycanAnnotationSummary;
import org.grits.toolbox.entry.ms.annotation.property.MSAnnotationEntityProperty;
import org.grits.toolbox.entry.ms.annotation.tablehelpers.MSAnnotationTable;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.IMSAnnotationPeaksViewer;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationDetails;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationFilterView;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationMultiPageViewer;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationOtherSettingsView;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationPropertyView;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationQuantificationView;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationSelectionView;
import org.grits.toolbox.entry.ms.process.loader.MassSpecTableDataProcessor;
import org.grits.toolbox.entry.ms.property.MassSpecEntityProperty;
import org.grits.toolbox.entry.ms.tablehelpers.MassSpecTable;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecMultiPageViewer;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecPeaksView;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecSpectraView;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecTableBase;
import org.grits.toolbox.ms.om.data.AnnotationFilter;
import org.grits.toolbox.util.structure.glycan.filter.om.FilterSetting;
import org.grits.toolbox.utils.data.CartoonOptions;
import org.grits.toolbox.widgets.processDialog.GRITSProgressDialog;
import org.grits.toolbox.widgets.progress.CancelableThread;
import org.grits.toolbox.widgets.progress.IProgressListener;
import org.grits.toolbox.widgets.progress.IProgressThreadHandler;
import org.grits.toolbox.widgets.tools.GRITSProcessStatus;
import org.grits.toolbox.widgets.tools.GRITSWorker;

public class MSGlycanAnnotationMultiPageViewer
extends MSAnnotationMultiPageViewer {
    public static String VIEW_ID = "plugin.ms.annotation.glycan.views.MSGlycanAnnotationMultiPageViewer";
    private static final Logger logger = Logger.getLogger(MSAnnotationMultiPageViewer.class);
    protected MSGlycanAnnotationSummary summaryView = null;
    protected int summaryViewTabIndex = -1;
    private AnnotationFilter filter;
    boolean dirtyVal = false;
    @Inject
    IEventBroker eventBroker;
    public static final String EVENT_TOPIC_FILTER_CHANGED = "FilterChanged";
    public static MSGlycanAnnotationCustomAnnotationDialog msGlycanAnnotationCustomAnnotationDialog = null;
    public static MSGlycanAnnotationStandardQuantApplyDialog msGlycanAnnotationStandardQuantApplyDialog = null;
    public static MSGlycanAnnotationPeakIntensityApplyDialog msGlycanAnnotationPeakIntensityApplyDialog = null;

    @Inject
    public MSGlycanAnnotationMultiPageViewer(Entry entry) {
        super(entry);
    }

    @Inject
    public MSGlycanAnnotationMultiPageViewer(MPart part) {
        super(part);
    }

    public String toString() {
        return "MSGlycanAnnotationMultiPageViewer (" + this.entry + ")";
    }

    protected Object getDesiredActivePage() {
        if (this.summaryView == null) {
            return super.getDesiredActivePage();
        }
        return this.summaryView;
    }

    public int getSummaryViewTabIndex() {
        return this.summaryViewTabIndex;
    }

    public void setSummaryViewTabIndex(int summaryViewTabIndex) {
        this.summaryViewTabIndex = summaryViewTabIndex;
    }

    public MSGlycanAnnotationSummary getSummaryView() {
        return this.summaryView;
    }

    protected MassSpecSpectraView getNewSpectraView() {
        this.getPart().getContext().set(Entry.class, (Object)this.entry);
        return (MassSpecSpectraView)ContextInjectionFactory.make(MSGlycanAnnotationSpectraView.class, (IEclipseContext)this.getPart().getContext());
    }

    protected int addPages(int _iMajorCount, MassSpecEntityProperty prop) {
        this.dtpdThreadedDialog = new GRITSProgressDialog(new Shell(), 1, false);
        this.dtpdThreadedDialog.open();
        this.dtpdThreadedDialog.getMajorProgressBarListener().setMaxValue(_iMajorCount);
        MSGlycanAnnotationMultiPageViewerWorker msmpvw = new MSGlycanAnnotationMultiPageViewerWorker((MassSpecMultiPageViewer)this, prop);
        this.dtpdThreadedDialog.setGritsWorker((GRITSWorker)msmpvw);
        int iSuccess = this.dtpdThreadedDialog.startWorker();
        this.getFilter();
        this.sendFilterChanged();
        return iSuccess;
    }

    protected int getNumMajorSteps(MassSpecEntityProperty prop) {
        int iNumPages = super.getNumMajorSteps(prop);
        if (this.needsSummaryView(prop)) {
            iNumPages += 2;
            this.setSummaryViewTabIndex(this.getAnnotDetailsTabIndex() + 1);
        }
        return iNumPages;
    }

    public int addSummaryPage_Step1(MassSpecEntityProperty prop) {
        try {
            int iSuccess = this.initSummaryView(prop);
            this.dtpdThreadedDialog.setMinorStatus(iSuccess);
            if (iSuccess == GRITSProcessStatus.CANCEL) {
                this.setStatus(GRITSProcessStatus.CANCEL);
                return GRITSProcessStatus.CANCEL;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to open Summary view", (Throwable)ex);
            this.setStatus(GRITSProcessStatus.ERROR);
        }
        if (this.getStatus() == GRITSProcessStatus.ERROR) {
            String sMessage = "An error occurred creating the Summary tab.";
            this.dtpdThreadedDialog.getMajorProgressBarListener().setError(sMessage);
        }
        return this.getStatus();
    }

    public int addSummaryPage_Step2() {
        try {
            boolean success = true;
            int iPageCount = this.getPageCount();
            try {
                int inx = this.getSummaryViewTabIndex();
                if (inx >= this.getPageCount()) {
                    inx = this.addPage((IEntryEditorPart)this.getSummaryView(), this.entry);
                    this.setSummaryViewTabIndex(inx);
                } else {
                    this.addPage(inx, (IEntryEditorPart)this.getSummaryView(), this.entry);
                }
                this.setPageText(inx, "Summary");
                this.setActivePage(inx);
                int iSuccess = this.summaryView.getStatus();
                this.setStatus(iSuccess);
                this.dtpdThreadedDialog.setMinorStatus(iSuccess);
            }
            catch (Exception ex) {
                logger.error((Object)"Error adding Peaks List tab.", (Throwable)ex);
                this.setStatus(GRITSProcessStatus.ERROR);
            }
            boolean bl = success = this.getStatus() != GRITSProcessStatus.ERROR;
            if (!success) {
                if (this.getPageCount() != iPageCount) {
                    this.removePage(this.getPageCount() - 1);
                }
                this.summaryView = null;
            } else {
                this.setSummaryViewTabIndex(this.getPageCount() - 1);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to open Summary view", (Throwable)ex);
            this.setStatus(GRITSProcessStatus.ERROR);
        }
        if (this.getStatus() == GRITSProcessStatus.ERROR) {
            String sMessage = "An error occurred creating the Summary tab.";
            this.dtpdThreadedDialog.getMajorProgressBarListener().setError(sMessage);
        }
        return this.getStatus();
    }

    protected boolean initMSAnnotationPropertyView() {
        try {
            this.getPart().getContext().set(Entry.class, (Object)this.entry);
            this.msAnnotPropertyView = (MSAnnotationPropertyView)ContextInjectionFactory.make(MSGlycanAnnotationPropertyView.class, (IEclipseContext)this.getPart().getContext());
            return true;
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to open property view", (Throwable)ex);
            return false;
        }
    }

    protected boolean initMsAnnotationFilterView() {
        try {
            this.getPart().getContext().set(Entry.class, (Object)this.entry);
            this.msAnnotFilterView = (MSAnnotationFilterView)ContextInjectionFactory.make(MSGlycanAnnotationFilterView.class, (IEclipseContext)this.getPart().getContext());
            return true;
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to open interactive settings view", (Throwable)ex);
            return false;
        }
    }

    protected boolean initOtherSettingsView() {
        try {
            this.getPart().getContext().set(Entry.class, (Object)this.entry);
            this.msAnnotOtherView = (MSAnnotationOtherSettingsView)ContextInjectionFactory.make(MSGlycanAnnotationOtherSettingsView.class, (IEclipseContext)this.getPart().getContext());
            return true;
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to open interactive settings view", (Throwable)ex);
            return false;
        }
    }

    protected boolean initQuantificationView() {
        try {
            this.getPart().getContext().set(Entry.class, (Object)this.entry);
            this.msAnnotQuantView = (MSAnnotationQuantificationView)ContextInjectionFactory.make(MSGlycanAnnotationQuantificationView.class, (IEclipseContext)this.getPart().getContext());
            return true;
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to open interactive settings view", (Throwable)ex);
            return false;
        }
    }

    public boolean needsSpectraView(MassSpecEntityProperty entityProperty) {
        if (entityProperty.getMsLevel() > 2 && entityProperty.getMassSpecParentProperty().getMassSpecMetaData().getMsExperimentType().equals("MS Profile")) {
            return false;
        }
        return super.needsSpectraView(entityProperty);
    }

    protected boolean needsSummaryView(MassSpecEntityProperty entityProperty) {
        if (entityProperty.getParentScanNum() == null || entityProperty.getParentScanNum() < 0) {
            return false;
        }
        if (entityProperty.getMsLevel() < 3) {
            return false;
        }
        return ((MSAnnotationEntityProperty)entityProperty).getAnnotationId() != null && ((MSAnnotationEntityProperty)entityProperty).getAnnotationId() >= 0;
    }

    protected int initSummaryView(MassSpecEntityProperty entityProperty) {
        try {
            this.summaryView = this.getNewSummaryView(this.entry, entityProperty);
            return GRITSProcessStatus.OK;
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to open peaks view", (Throwable)ex);
            return GRITSProcessStatus.ERROR;
        }
    }

    protected MSGlycanAnnotationSummary getNewSummaryView(Entry entry, MassSpecEntityProperty entityProperty) {
        MSGlycanAnnotationMultiPageViewer parent = MSGlycanAnnotationMultiPageViewer.getActiveViewerForEntry(this.getContext(), entry.getParent());
        if (parent != null) {
            this.getPart().getContext().set(MSAnnotationDetails.class, (Object)this.getDetailsView());
            MSGlycanAnnotationSummary view = (MSGlycanAnnotationSummary)((Object)ContextInjectionFactory.make(MSGlycanAnnotationSummary.class, (IEclipseContext)this.getPart().getContext()));
            view.setDtpdThreadedDialog(this.getThreadedDialog());
            return view;
        }
        return null;
    }

    protected boolean initSpectraView(MassSpecEntityProperty prop) {
        try {
            int iMSLevelForSpectrum = 1;
            if (prop.getMsLevel() != null && this.entry.getParent().getProperty() instanceof MSAnnotationEntityProperty) {
                MSAnnotationEntityProperty parentProp = (MSAnnotationEntityProperty)this.entry.getParent().getProperty();
                iMSLevelForSpectrum = parentProp.getMsLevel();
            }
            this.spectraView = this.getNewSpectraView();
            if (this.getScansView() != null) {
                MSGlycanAnnotationTableDataProcessor scansTableProcessor = (MSGlycanAnnotationTableDataProcessor)this.getScansView().getTableDataProcessor();
                ((MSGlycanAnnotationSpectraView)this.spectraView).setScanListTableProcessor((MassSpecTableDataProcessor)scansTableProcessor);
            }
            if (!this.getPeaksView().isEmpty() && this.getPeaksView().get(0) != null) {
                MSGlycanAnnotationDetails msdv = (MSGlycanAnnotationDetails)this.getDetailsView();
                if (msdv != null) {
                    ((MSGlycanAnnotationSpectraView)this.spectraView).setDetailsView(msdv);
                } else {
                    MSGlycanAnnotationTableDataProcessor peaksTableProcessor = (MSGlycanAnnotationTableDataProcessor)((MassSpecPeaksView)this.getPeaksView().get(0)).getTableDataProcessor();
                    ((MSGlycanAnnotationSpectraView)this.spectraView).setPeakListTableProcessor((MassSpecTableDataProcessor)peaksTableProcessor);
                }
            }
            ((MSGlycanAnnotationSpectraView)this.spectraView).setMSLevel(iMSLevelForSpectrum);
            this.updateMSView(prop, this.spectraView);
            return true;
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to open spectra view", (Throwable)ex);
            return false;
        }
    }

    protected MSGlycanAnnotationScansView getNewScansView(Entry entry, MassSpecEntityProperty entityProperty) {
        MSAnnotationEntityProperty msProp = (MSAnnotationEntityProperty)entityProperty.clone();
        msProp.setParentScanNum(entityProperty.getScanNum());
        msProp.setScanNum(null);
        this.getPart().getContext().set("MinMSLevelContext", (Object)this.getMinMSLevel());
        this.getPart().getContext().set(Property.class, (Object)msProp);
        this.getPart().getContext().set(Entry.class, (Object)entry);
        return (MSGlycanAnnotationScansView)((Object)ContextInjectionFactory.make(MSGlycanAnnotationScansView.class, (IEclipseContext)this.getPart().getContext()));
    }

    protected MSGlycanAnnotationPeaksView getNewPeaksView(Entry entry, MassSpecEntityProperty entityProperty) {
        this.getPart().getContext().set("MinMSLevelContext", (Object)this.getMinMSLevel());
        this.getPart().getContext().set(Property.class, (Object)entityProperty);
        this.getPart().getContext().set(Entry.class, (Object)entry);
        return (MSGlycanAnnotationPeaksView)((Object)ContextInjectionFactory.make(MSGlycanAnnotationPeaksView.class, (IEclipseContext)this.getPart().getContext()));
    }

    public static MSGlycanAnnotationMultiPageViewer getActiveSummaryViewer(IEclipseContext context, Entry _entry, String _sRowId) {
        EPartService partService = (EPartService)context.get(EPartService.class);
        for (MPart part : partService.getParts()) {
            if (!(part.getObject() instanceof MSGlycanAnnotationMultiPageViewer)) continue;
            try {
                MSGlycanAnnotationMultiPageViewer viewer = (MSGlycanAnnotationMultiPageViewer)((Object)part.getObject());
                if (!viewer.getEntry().getParent().equals(_entry) || viewer.getSummaryView() == null || !viewer.getSummaryView().getParentViewRowId().equals(_sRowId)) continue;
                return viewer;
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return null;
    }

    public static MSGlycanAnnotationMultiPageViewer getActiveViewer(IEclipseContext context) {
        MPart part = (MPart)context.get("e4ActivePart");
        if (part != null && part.getObject() instanceof MSGlycanAnnotationMultiPageViewer) {
            return (MSGlycanAnnotationMultiPageViewer)((Object)part.getObject());
        }
        return null;
    }

    public static MSGlycanAnnotationMultiPageViewer getActiveViewerForEntry(IEclipseContext context, Entry entry) {
        EPartService partService = (EPartService)context.get(EPartService.class);
        for (MPart part : partService.getParts()) {
            if (!(part.getObject() instanceof MSGlycanAnnotationMultiPageViewer) || !((MSGlycanAnnotationMultiPageViewer)((Object)part.getObject())).getEntry().equals(entry)) continue;
            return (MSGlycanAnnotationMultiPageViewer)((Object)part.getObject());
        }
        return null;
    }

    protected MSGlycanAnnotationDetails getNewDetailsView(Entry entry, MassSpecEntityProperty entityProperty) {
        MSGlycanAnnotationMultiPageViewer parent = MSGlycanAnnotationMultiPageViewer.getActiveViewerForEntry(this.getContext(), entry.getParent());
        if (parent != null) {
            CartoonOptions cOptions = this.getCartoonOptions();
            this.getPart().getContext().set(MSGlycanAnnotationMultiPageViewer.class, (Object)parent);
            this.getPart().getContext().set(Entry.class, (Object)entry);
            this.getPart().getContext().set(Property.class, (Object)entityProperty);
            this.getPart().getContext().set(CartoonOptions.class, (Object)cOptions);
            this.getPart().getContext().set("MinMSLevelContext", (Object)this.getMinMSLevel());
            MSGlycanAnnotationDetails view = (MSGlycanAnnotationDetails)((Object)ContextInjectionFactory.make(MSGlycanAnnotationDetails.class, (IEclipseContext)this.getPart().getContext()));
            return view;
        }
        return null;
    }

    protected CartoonOptions getCartoonOptions() {
        try {
            MSGlycanAnnotationCartoonPreferences prefs = MSGlycanAnnotationCartoonPreferencesLoader.getCartoonPreferences();
            CartoonOptions cartoonOptions = new CartoonOptions(MSGlycanAnnotationCartoonPreferences.getGWBlayoutString((String)prefs.getImageLayout()), MSGlycanAnnotationCartoonPreferences.getGWBStyleString((String)prefs.getImageStyle()), Double.valueOf(Double.parseDouble(prefs.getImageScaleFactor())), Integer.valueOf(MSGlycanAnnotationCartoonPreferences.getGWBOrientationCode((String)prefs.getOrientation())), prefs.isShowInfo(), prefs.isShowMasses(), prefs.isShowRedEnd());
            return cartoonOptions;
        }
        catch (NumberFormatException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static void showRowSelection(IEclipseContext context, Entry entry, MSAnnotationTable parentTable, int iRowNumber, int iSourceParentScanNum, String sSourceParentRowId) {
        try {
            MSGlycanAnnotationMultiPageViewer parent = MSGlycanAnnotationMultiPageViewer.getActiveViewerForEntry(context, entry);
            if (parent != null) {
                MSGlycanAnnotationPeaksView me = null;
                IEntryEditorPart oActiveTab = parent.getPageItem(parent.getActivePage());
                if (oActiveTab instanceof MSGlycanAnnotationDetails) {
                    me = (MSGlycanAnnotationPeaksView)parent.getAnnotationDetails().getCurrentPeaksView();
                } else if (oActiveTab instanceof MSGlycanAnnotationPeaksView) {
                    me = (MSGlycanAnnotationPeaksView)((Object)parent.getPeaksView().get(0));
                }
                if (me == null) {
                    return;
                }
                MSAnnotationSelectionView viewer = ViewRowChooserInTabCommandExecutor.showRowChooser((IMSAnnotationPeaksViewer)me, (MSAnnotationTable)parentTable, (int)iRowNumber, (int)iSourceParentScanNum, (String)sSourceParentRowId);
                me.setSelectionView(viewer);
                me.getBottomPane().layout();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void updateColumnVisibility(MassSpecViewerPreference updatePref) {
        super.updateColumnVisibility(updatePref);
        if (this.getSummaryView() != null) {
            try {
                MSGlycanAnnotationSummary summaryView = this.getSummaryView();
                MassSpecTableBase viewBase = summaryView.getViewBase();
                if (viewBase == null || viewBase.getNatTable() == null) {
                    return;
                }
                MSGlycanAnnotationSummaryTable table = (MSGlycanAnnotationSummaryTable)viewBase.getNatTable();
                MSGlycanAnnotationSummaryViewerPreference curPref = (MSGlycanAnnotationSummaryViewerPreference)table.getGRITSTableDataObject().getTablePreferences();
                this.updateColumnVisibility((MassSpecTable)table, (MassSpecViewerPreference)curPref, updatePref);
            }
            catch (Exception ex) {
                logger.error((Object)("Error updating Summary view from editor: " + this.getTitle()), (Throwable)ex);
            }
        }
    }

    @Optional
    @Inject
    public void updatePreferences(@UIEventTopic(value="preference_value_changed_in_grits") String preferenceName) {
        MSGlycanAnnotationViewerPreference updatePref;
        PreferenceEntity preferenceEntity;
        if (preferenceName != null && preferenceName.startsWith(MSGlycanAnnotationViewerPreference.class.getName())) {
            try {
                preferenceEntity = this.gritsPreferenceStore.getPreferenceEntity(preferenceName);
                updatePref = (MSGlycanAnnotationViewerPreference)TableViewerPreference.getTableViewerPreference((PreferenceEntity)preferenceEntity, MSGlycanAnnotationViewerPreference.class);
                this.updateColumnVisibility((MassSpecViewerPreference)updatePref);
            }
            catch (UnsupportedVersionException e) {
                logger.error((Object)"Error updating column visibility", (Throwable)e);
            }
        }
        if (preferenceName != null && preferenceName.startsWith(MSGlycanAnnotationSummaryViewerPreference.class.getName())) {
            try {
                preferenceEntity = this.gritsPreferenceStore.getPreferenceEntity(preferenceName);
                updatePref = (MSGlycanAnnotationSummaryViewerPreference)TableViewerPreference.getTableViewerPreference((PreferenceEntity)preferenceEntity, MSGlycanAnnotationSummaryViewerPreference.class);
                this.updateColumnVisibility((MassSpecViewerPreference)updatePref);
            }
            catch (UnsupportedVersionException e) {
                logger.error((Object)"Error updating column visibility", (Throwable)e);
            }
        }
    }

    public static String[] getPreferencePageLabels(int _iMSLevel) {
        if (_iMSLevel == 1) {
            return new String[]{"MS Scans"};
        }
        if (_iMSLevel == 2) {
            return new String[]{"MS Scans", "Structure Annotation", "Structure Annotation Selection"};
        }
        if (_iMSLevel == 3) {
            return new String[]{"MS Scans", "Details View", "Details View Selection", "Summary"};
        }
        return new String[]{"MS Scans", "Details View", "Details View Selection", "Summary", "Peak List"};
    }

    public static FillTypes[] getPreferencePageFillTypes(int _iMSLevel) {
        if (_iMSLevel == 1) {
            return new FillTypes[]{FillTypes.Scans};
        }
        if (_iMSLevel == 2) {
            return new FillTypes[]{FillTypes.Scans, FillTypes.PeaksWithFeatures, FillTypes.Selection};
        }
        if (_iMSLevel == 3) {
            return new FillTypes[]{FillTypes.Scans, FillTypes.PeaksWithFeatures, FillTypes.Selection, FillTypes.Scans};
        }
        return new FillTypes[]{FillTypes.Scans, FillTypes.PeaksWithFeatures, FillTypes.Selection, FillTypes.Scans, FillTypes.PeakList};
    }

    public static int getPreferencePageMaxNumPages() {
        return 4;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("Window Closed")) {
            msGlycanAnnotationCustomAnnotationDialog = null;
        }
    }

    public void applyFilter(final FilterSetting filterSetting, final String filterKey, final int numTopHits, final boolean overrideManual, final boolean keepExisting, final boolean highlightOnly) {
        if (((MassSpecPeaksView)this.getPeaksView().get(0)).getViewBase() == null) {
            logger.warn((Object)"You cannot apply filter at this level!");
            return;
        }
        final GRITSProgressDialog progressDialog = new GRITSProgressDialog(new Shell(), 1, false);
        progressDialog.open();
        progressDialog.getMajorProgressBarListener().setMaxValue(2);
        progressDialog.setGritsWorker(new GRITSWorker(){
            MSGlycanAnnotationTable table;
            {
                this.table = (MSGlycanAnnotationTable)((MassSpecPeaksView)MSGlycanAnnotationMultiPageViewer.this.getPeaksView().get(0)).getViewBase().getNatTable();
            }

            public int doWork() {
                try {
                    this.updateListeners("Filtering...", 1);
                    MSGlycanAnnotationMultiPageViewer.this.dirtyVal = false;
                    CancelableThread t = new CancelableThread(){

                        public boolean threadStart(IProgressThreadHandler a_progressThreadHandler) throws Exception {
                            try {
                                ((MSGlycanAnnotationTableDataProcessor)table.getTableDataProcessor()).setFilter(MSGlycanAnnotationMultiPageViewer.this.filter);
                                (this).MSGlycanAnnotationMultiPageViewer.this.dirtyVal = table.startUpdateHiddenRowsAfterEdit(filterKey, numTopHits, overrideManual, filterSetting, keepExisting, highlightOnly);
                                return true;
                            }
                            catch (Exception e) {
                                logger.error((Object)e.getMessage(), (Throwable)e);
                                return false;
                            }
                        }
                    };
                    t.setProgressThreadHandler((IProgressThreadHandler)progressDialog);
                    progressDialog.setThread(t);
                    this.table.getTableDataProcessor().setProgressBarDialog(progressDialog);
                    progressDialog.getMinorProgressBarListener(0).setProgressType(IProgressListener.ProgressType.Determinant);
                    t.start();
                    while (!t.isCanceled() && !t.isFinished() && t.isAlive()) {
                        Display.getDefault().readAndDispatch();
                    }
                    if (t.isCanceled()) {
                        t.interrupt();
                        return GRITSProcessStatus.CANCEL;
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                this.table.finishUpdateHiddenRowsAfterEdit(MSGlycanAnnotationMultiPageViewer.this.dirtyVal);
                this.updateListeners("Done", 2);
                return GRITSProcessStatus.OK;
            }
        });
        progressDialog.startWorker();
        int inx = this.getPeaksViewsFirstTabIndex();
        int current = this.getActivePage();
        if (inx != current) {
            this.setActivePage(inx);
        }
    }

    protected AnnotationFilter getFilter() {
        if (this.filter == null && !this.getPeaksView().isEmpty() && ((MassSpecPeaksView)this.getPeaksView().get(0)).getViewBase() != null && ((MSGlycanAnnotationTableDataProcessor)((MSGlycanAnnotationTable)((MassSpecPeaksView)this.getPeaksView().get(0)).getViewBase().getNatTable()).getTableDataProcessor()).getCurScanFeature() != null) {
            this.setFilter(((MSGlycanAnnotationTableDataProcessor)((MSGlycanAnnotationTable)((MassSpecPeaksView)this.getPeaksView().get(0)).getViewBase().getNatTable()).getTableDataProcessor()).getCurScanFeature().getFilter());
        }
        return this.filter;
    }

    public void setFilter(AnnotationFilter filter) {
        this.filter = filter;
    }

    public void sendFilterChanged() {
        this.eventBroker.post(EVENT_TOPIC_FILTER_CHANGED, (Object)this);
    }

    protected Entry getNewTableCompatibleEntry(Entry parentEntry) {
        Entry newEntry = MSGlycanAnnotationEntityProperty.getTableCompatibleEntry(parentEntry);
        return newEntry;
    }

    public static /* bridge */ /* synthetic */ MSAnnotationMultiPageViewer getActiveViewerForEntry(IEclipseContext iEclipseContext, Entry entry) {
        return MSGlycanAnnotationMultiPageViewer.getActiveViewerForEntry(iEclipseContext, entry);
    }

    public static /* bridge */ /* synthetic */ MSAnnotationMultiPageViewer getActiveViewer(IEclipseContext iEclipseContext) {
        return MSGlycanAnnotationMultiPageViewer.getActiveViewer(iEclipseContext);
    }
}

