/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.views.tabbed;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.widgets.Composite;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.datamodel.ms.annotation.glycan.preference.cartoon.MSGlycanAnnotationCartoonPreferences;
import org.grits.toolbox.datamodel.ms.tablemodel.FillTypes;
import org.grits.toolbox.display.control.table.process.TableDataProcessor;
import org.grits.toolbox.entry.ms.annotation.command.ViewRowChooserInTabCommandExecutor;
import org.grits.toolbox.entry.ms.annotation.glycan.process.loader.MSGlycanAnnotationTableDataProcessor;
import org.grits.toolbox.entry.ms.annotation.glycan.tablehelpers.MSGlycanAnnotationTable;
import org.grits.toolbox.entry.ms.annotation.glycan.views.tabbed.MSGlycanAnnotationMultiPageViewer;
import org.grits.toolbox.entry.ms.annotation.glycan.views.tabbed.MSGlycanAnnotationResultsComposite;
import org.grits.toolbox.entry.ms.annotation.glycan.views.tabbed.MSGlycanAnnotationSelectionView;
import org.grits.toolbox.entry.ms.annotation.property.MSAnnotationEntityProperty;
import org.grits.toolbox.entry.ms.annotation.tablehelpers.MSAnnotationTable;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.IMSAnnotationPeaksViewer;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationPeaksView;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationSelectionView;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecTableBase;

public class MSGlycanAnnotationPeaksView
extends MSAnnotationPeaksView
implements IMSAnnotationPeaksViewer {
    private static final Logger logger = Logger.getLogger(MSGlycanAnnotationPeaksView.class);
    public static final String VIEW_ID = "plugin.ms.annotation.glycan.views.MSGlycanAnnotationPeaksView";
    private MPart part;

    @Inject
    public MSGlycanAnnotationPeaksView(@Optional Entry entry, @Optional Property msEntityProperty, @Named(value="MinMSLevelContext") int iMinMSLevel) {
        super(entry, msEntityProperty, iMinMSLevel);
    }

    @PostConstruct
    public void postConstruct(MPart part) {
        this.part = part;
    }

    public MPart getPart() {
        return this.part;
    }

    protected MSGlycanAnnotationResultsComposite getNewResultsComposite(Composite composite, int style) {
        return new MSGlycanAnnotationResultsComposite(composite, style);
    }

    public String toString() {
        return "MSGlycanAnnotationPeaksView (" + this.entry + ")";
    }

    public static void showRowSelection(IEclipseContext context, Entry entry, MSAnnotationTable parentTable, int iRowNumber, int iScanNum, String sRowId) {
        MSGlycanAnnotationMultiPageViewer parent = MSGlycanAnnotationMultiPageViewer.getActiveViewerForEntry(context, entry);
        if (parent != null) {
            MSGlycanAnnotationPeaksView me = (MSGlycanAnnotationPeaksView)((Object)parent.getPeaksView());
            if (me == null) {
                me = (MSGlycanAnnotationPeaksView)parent.getAnnotationDetails().getCurrentPeaksView();
            }
            MSAnnotationSelectionView viewer = ViewRowChooserInTabCommandExecutor.showRowChooser((IMSAnnotationPeaksViewer)me, (MSAnnotationTable)parentTable, (int)iRowNumber, (int)iScanNum, (String)sRowId);
            me.setSelectionView(viewer);
            me.getBottomPane().layout();
        }
    }

    public void initNewSelectionView() {
        this.setSelectionView(new MSGlycanAnnotationSelectionView(this.getBottomPane()));
    }

    protected TableDataProcessor getNewTableDataProcessor(Entry entry, Property entityProperty) {
        MSGlycanAnnotationTableDataProcessor proc = new MSGlycanAnnotationTableDataProcessor(entry, entityProperty, FillTypes.PeaksWithFeatures, this.getMinMSLevel());
        proc.initializeTableDataObject(entityProperty);
        return proc;
    }

    protected TableDataProcessor getNewTableDataProcessor(Property entityProperty) {
        MSAnnotationEntityProperty ep;
        Entry parentEntry = this.getEntry().getParent();
        MSGlycanAnnotationMultiPageViewer parentViewer = MSGlycanAnnotationMultiPageViewer.getActiveViewerForEntry(this.part.getContext(), parentEntry);
        if (parentViewer == null || parentViewer.getScansView() == null) {
            return null;
        }
        MSGlycanAnnotationTableDataProcessor parentProc = (MSGlycanAnnotationTableDataProcessor)parentViewer.getScansView().getTableDataProcessor();
        if (parentProc.getGRITSdata() == null) {
            return null;
        }
        FillTypes fillType = FillTypes.PeaksWithFeatures;
        if (entityProperty instanceof MSAnnotationEntityProperty && (ep = (MSAnnotationEntityProperty)entityProperty).getMsLevel() > 3 && ep.getAnnotationId() == -1) {
            fillType = FillTypes.PeakList;
        }
        MSGlycanAnnotationTableDataProcessor proc = new MSGlycanAnnotationTableDataProcessor((TableDataProcessor)parentProc, entityProperty, fillType, this.getMinMSLevel());
        proc.initializeTableDataObject(entityProperty);
        return proc;
    }

    @Optional
    @Inject
    public void updatePreferences(@UIEventTopic(value="preference_value_changed_in_grits") String preferenceName) {
        if (MSGlycanAnnotationCartoonPreferences.getPreferenceID().equals(preferenceName)) {
            try {
                MSGlycanAnnotationSelectionView sv = (MSGlycanAnnotationSelectionView)this.getCurrentSelectionView();
                if (sv != null && sv.getSubTable() != null) {
                    ((MSGlycanAnnotationTable)sv.getSubTable()).refreshTableImages();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Could not refresh subtable images", (Throwable)e);
            }
            try {
                MassSpecTableBase viewBase = this.getViewBase();
                if (viewBase != null && viewBase.getNatTable() != null) {
                    ((MSGlycanAnnotationTable)viewBase.getNatTable()).refreshTableImages();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Could not refresh table images", (Throwable)e);
            }
        }
    }
}

