/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.preference;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.core.preference.share.PreferenceEntity;
import org.grits.toolbox.core.preference.share.PreferenceReader;
import org.grits.toolbox.core.preference.share.PreferenceWriter;
import org.grits.toolbox.core.utilShare.XMLUtils;
import org.grits.toolbox.entry.ms.annotation.glycan.preference.xml.MSGlycanAnnotationCustomAnnotation;
import org.grits.toolbox.entry.ms.annotation.glycan.preference.xml.MSGlycanAnnotationCustomAnnotationTemplate;
import org.grits.toolbox.entry.ms.preference.IMSPreferenceWithCustomAnnotation;
import org.grits.toolbox.entry.ms.preference.xml.MassSpecCustomAnnotation;

@XmlRootElement(name="msGlycanCustomAnnotations")
public class MSGlycanCustomAnnotationPreference
implements IMSPreferenceWithCustomAnnotation {
    private static final Logger logger = Logger.getLogger(MSGlycanCustomAnnotationPreference.class);
    private static final String PREFERENCE_NAME_ALL = "org.grits.toolbox.entry.ms.annotation.glycan.customannotation";
    private static final String CURRENT_VERSION = "1.1";
    private static final String VALUE_SEPERATOR = "~~~~~";
    List<MassSpecCustomAnnotation> customAnnotations = new ArrayList<MassSpecCustomAnnotation>();
    List<MSGlycanAnnotationCustomAnnotation> serializedCustomAnnotation = new ArrayList<MSGlycanAnnotationCustomAnnotation>();

    @XmlTransient
    public List<MassSpecCustomAnnotation> getCustomAnnotations() {
        return this.customAnnotations;
    }

    public void setCustomAnnotations(List<MassSpecCustomAnnotation> customAnnotations) {
        this.customAnnotations = customAnnotations;
    }

    @XmlElement(name="customAnnotations")
    public List<MSGlycanAnnotationCustomAnnotation> getSerializedCustomAnnotation() {
        return this.serializedCustomAnnotation;
    }

    public void setSerializedCustomAnnotation(List<MSGlycanAnnotationCustomAnnotation> serializedCustomAnnotation) {
        this.serializedCustomAnnotation = serializedCustomAnnotation;
    }

    public static MassSpecCustomAnnotation lookupCustomAnnotation(List<MassSpecCustomAnnotation> customAnnotations, String annotationName) {
        if (customAnnotations != null && !customAnnotations.isEmpty()) {
            int i = 0;
            while (i < customAnnotations.size()) {
                MassSpecCustomAnnotation annotation = customAnnotations.get(i);
                if (annotation.getAnnotationName().equalsIgnoreCase(annotationName)) {
                    return annotation;
                }
                ++i;
            }
        }
        return null;
    }

    public boolean saveValues() {
        PreferenceEntity preferenceEntity = new PreferenceEntity(PREFERENCE_NAME_ALL);
        preferenceEntity.setVersion(CURRENT_VERSION);
        this.serializedCustomAnnotation.clear();
        for (MassSpecCustomAnnotation ca : this.customAnnotations) {
            if (!(ca instanceof MSGlycanAnnotationCustomAnnotation)) continue;
            this.serializedCustomAnnotation.add((MSGlycanAnnotationCustomAnnotation)ca);
            ca.updateAnnotatedPeakText();
        }
        preferenceEntity.setValue(XMLUtils.marshalObjectXML((Object)this));
        return PreferenceWriter.savePreference((PreferenceEntity)preferenceEntity);
    }

    public static PreferenceEntity getPreferenceEntity() throws UnsupportedVersionException {
        PreferenceEntity preferenceEntity = PreferenceReader.getPreferenceByName((String)PREFERENCE_NAME_ALL);
        return preferenceEntity;
    }

    public static MSGlycanCustomAnnotationPreference getMSGlycanCustomAnnotationPreferences(PreferenceEntity preferenceEntity) throws UnsupportedVersionException {
        MSGlycanCustomAnnotationPreference preferenceSettings = null;
        if (preferenceEntity != null) {
            preferenceSettings = MSGlycanCustomAnnotationPreference.getMSGlycanCustomAnnotationPreferencesFromXML(preferenceEntity.getValue());
        }
        return preferenceSettings;
    }

    private static MSGlycanCustomAnnotationPreference getMSGlycanCustomAnnotationPreferencesFromXML(String xmlString) {
        MSGlycanCustomAnnotationPreference msPreference = null;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{MSGlycanCustomAnnotationPreference.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            msPreference = (MSGlycanCustomAnnotationPreference)unmarshaller.unmarshal((Reader)new StringReader(xmlString));
            for (MSGlycanAnnotationCustomAnnotation ca : msPreference.serializedCustomAnnotation) {
                msPreference.customAnnotations.add(ca);
                ca.unmarshalAnnotatedPeakList();
            }
        }
        catch (JAXBException e) {
            logger.error((Object)("The object could not be read from xml." + e.getMessage()), (Throwable)e);
        }
        return msPreference;
    }

    public static String createCustomAnnotationsText(MSGlycanAnnotationCustomAnnotation annotation) {
        annotation.updateAnnotatedPeakText();
        String asText = XMLUtils.marshalObjectXML((Object)((Object)annotation));
        return asText;
    }

    public static String createCustomAnnotationsText(List<MassSpecCustomAnnotation> customAnnotations) {
        StringBuilder sb = new StringBuilder();
        if (customAnnotations != null && !customAnnotations.isEmpty()) {
            int iAnnotCnt = 0;
            int i = 0;
            while (i < customAnnotations.size()) {
                MSGlycanAnnotationCustomAnnotation annotation = (MSGlycanAnnotationCustomAnnotation)customAnnotations.get(i);
                if (annotation != null) {
                    if (iAnnotCnt > 0) {
                        sb.append(VALUE_SEPERATOR);
                    }
                    String sXML = MSGlycanCustomAnnotationPreference.createCustomAnnotationsText(annotation);
                    sb.append(sXML);
                    ++iAnnotCnt;
                }
                ++i;
            }
        }
        return sb.toString();
    }

    public static List<MassSpecCustomAnnotation> unmarshalCustomAnnotationsList(String sCustomAnnotationText) {
        ArrayList<MassSpecCustomAnnotation> msca = new ArrayList<MassSpecCustomAnnotation>();
        try {
            if (sCustomAnnotationText != null) {
                String[] annotations;
                if (sCustomAnnotationText.startsWith(VALUE_SEPERATOR)) {
                    int iStartPos = sCustomAnnotationText.indexOf(VALUE_SEPERATOR) + VALUE_SEPERATOR.length();
                    sCustomAnnotationText = sCustomAnnotationText.substring(iStartPos);
                }
                if (!sCustomAnnotationText.equals("") && (annotations = sCustomAnnotationText.split(VALUE_SEPERATOR)) != null && annotations.length > 0) {
                    int i = 0;
                    while (i < annotations.length) {
                        String annotXML = annotations[i];
                        MSGlycanAnnotationCustomAnnotation annotation = (MSGlycanAnnotationCustomAnnotation)((Object)XMLUtils.getObjectFromXML((String)annotXML, MSGlycanAnnotationCustomAnnotation.class));
                        annotation.unmarshalAnnotatedPeakList();
                        if (annotation != null) {
                            annotation.unmarshalAnnotatedPeakList();
                            msca.add(annotation);
                        }
                        ++i;
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error loading default options from xml files.", (Throwable)ex);
        }
        return msca;
    }

    public void loadDefaultCustomAnnotations() {
        this.serializedCustomAnnotation.clear();
        try {
            URL resourceURL = FileLocator.toFileURL((URL)Platform.getBundle((String)"org.grits.toolbox.entry.ms.annotation.glycan").getResource("preference"));
            File preferenceDir = new File(resourceURL.getPath());
            if (preferenceDir.exists() && preferenceDir.isDirectory()) {
                File[] prefSubDirs;
                File[] fileArray = prefSubDirs = preferenceDir.listFiles();
                int n = prefSubDirs.length;
                int n2 = 0;
                while (n2 < n) {
                    File subDir = fileArray[n2];
                    if (subDir.isDirectory() && subDir.getName().equals("customAnnotation")) {
                        File[] files;
                        File[] fileArray2 = files = subDir.listFiles();
                        int n3 = files.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            File file = fileArray2[n4];
                            if (file.getName().endsWith(".xml")) {
                                this.processMSGlycanCustomAnnotation(file.getAbsolutePath());
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (IOException e) {
            logger.error((Object)"Could not load default preference files", (Throwable)e);
        }
    }

    private void processMSGlycanCustomAnnotation(String fileName) {
        try {
            MSGlycanAnnotationCustomAnnotationTemplate template = MSGlycanAnnotationCustomAnnotationTemplate.unmarshalAnnotationTemplate(fileName);
            MSGlycanAnnotationCustomAnnotation msca = (MSGlycanAnnotationCustomAnnotation)template.copyToNewAnnotation();
            this.customAnnotations.add(msca);
        }
        catch (Exception exception) {
            logger.warn((Object)(String.valueOf(fileName) + " is not a valid preference file"));
        }
    }
}

