/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.applications.ms.glycopeakfinder.calculation.xmlfiles;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.xmlfiles.DBInterface;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class GeneratorDefault {
    private DBInterface m_objDB = null;

    public void export(DBInterface dBInterface, String string) throws IOException, SQLException {
        this.m_objDB = dBInterface;
        Document document = new Document();
        Element element = new Element("defaults");
        Namespace namespace = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
        element.addNamespaceDeclaration(namespace);
        this.exportResidues(element);
        this.exportPersubstitutions(element);
        this.exportIons(element);
        this.exportDericatisation(element);
        this.exportMolecules(element);
        document.setRootElement(element);
        Format format = Format.getPrettyFormat();
        format.setEncoding("iso-8859-1");
        XMLOutputter xMLOutputter = new XMLOutputter(format);
        FileWriter fileWriter = new FileWriter(string);
        xMLOutputter.output(document, (Writer)fileWriter);
    }

    private void exportResidues(Element element) throws SQLException {
        Element element2 = new Element("residues");
        Element element3 = null;
        Element element4 = null;
        ResultSet resultSet = this.m_objDB.getResidues();
        while (resultSet.next()) {
            element3 = new Element("residue");
            element4 = new Element("name");
            element4.setText(resultSet.getString("name"));
            element3.addContent((Content)element4);
            element4 = new Element("abbr");
            element4.setText(resultSet.getString("abbr").toLowerCase());
            element3.addContent((Content)element4);
            element4 = new Element("pos");
            element4.setText(resultSet.getString("pos"));
            element3.addContent((Content)element4);
            element4 = new Element("pm");
            element4.setText(resultSet.getString("pm"));
            element3.addContent((Content)element4);
            element4 = new Element("pac");
            element4.setText(resultSet.getString("pac"));
            element3.addContent((Content)element4);
            element4 = new Element("mass_mono");
            element4.setText(resultSet.getString("mass_mono"));
            element3.addContent((Content)element4);
            element4 = new Element("mass_avg");
            element4.setText(resultSet.getString("mass_avg"));
            element3.addContent((Content)element4);
            element4 = new Element("mass_pm_mono");
            element4.setText(resultSet.getString("mass_pm_mono"));
            element3.addContent((Content)element4);
            element4 = new Element("mass_pm_avg");
            element4.setText(resultSet.getString("mass_pm_avg"));
            element3.addContent((Content)element4);
            element4 = new Element("mass_pdm_mono");
            element4.setText(resultSet.getString("mass_pdm_mono"));
            element3.addContent((Content)element4);
            element4 = new Element("mass_pdm_avg");
            element4.setText(resultSet.getString("mass_pdm_avg"));
            element3.addContent((Content)element4);
            element4 = new Element("mass_pac_mono");
            element4.setText(resultSet.getString("mass_pac_mono"));
            element3.addContent((Content)element4);
            element4 = new Element("mass_pac_avg");
            element4.setText(resultSet.getString("mass_pac_avg"));
            element3.addContent((Content)element4);
            element4 = new Element("mass_pdac_mono");
            element4.setText(resultSet.getString("mass_pdac_mono"));
            element3.addContent((Content)element4);
            element4 = new Element("mass_pdac_avg");
            element4.setText(resultSet.getString("mass_pdac_avg"));
            element3.addContent((Content)element4);
            element4 = new Element("increment");
            if (resultSet.getBoolean("increment")) {
                element4.setText("1");
            } else {
                element4.setText("0");
            }
            element3.addContent((Content)element4);
            element2.addContent((Content)element3);
        }
        element.addContent((Content)element2);
    }

    private void exportPersubstitutions(Element element) throws SQLException {
        Element element2 = new Element("persubstitutions");
        Element element3 = null;
        Element element4 = null;
        ResultSet resultSet = this.m_objDB.getPersubstitution();
        while (resultSet.next()) {
            element3 = new Element("persubstitution");
            element4 = new Element("name");
            element4.setText(resultSet.getString("name"));
            element3.addContent((Content)element4);
            element4 = new Element("mono");
            element4.setText(resultSet.getString("mono"));
            element3.addContent((Content)element4);
            element4 = new Element("avg");
            element4.setText(resultSet.getString("avg"));
            element3.addContent((Content)element4);
            element4 = new Element("ergaenzung_nonred_mono");
            element4.setText(resultSet.getString("ergaenzung_nonred_mono"));
            element3.addContent((Content)element4);
            element4 = new Element("ergaenzung_nonred_avg");
            element4.setText(resultSet.getString("ergaenzung_nonred_avg"));
            element3.addContent((Content)element4);
            element4 = new Element("ergaenzung_red_mono");
            element4.setText(resultSet.getString("ergaenzung_red_mono"));
            element3.addContent((Content)element4);
            element4 = new Element("ergaenzung_red_avg");
            element4.setText(resultSet.getString("ergaenzung_red_avg"));
            element3.addContent((Content)element4);
            element4 = new Element("increment_mono");
            element4.setText(resultSet.getString("increment_mono"));
            element3.addContent((Content)element4);
            element4 = new Element("increment_avg");
            element4.setText(resultSet.getString("increment_avg"));
            element3.addContent((Content)element4);
            element2.addContent((Content)element3);
        }
        element.addContent((Content)element2);
    }

    private void exportIons(Element element) throws SQLException {
        Element element2 = new Element("ions");
        Element element3 = null;
        Element element4 = null;
        ResultSet resultSet = this.m_objDB.getIons();
        while (resultSet.next()) {
            element3 = new Element("ion");
            element4 = new Element("name");
            element4.setText(resultSet.getString("name"));
            element3.addContent((Content)element4);
            element4 = new Element("formula");
            element4.setText(resultSet.getString("formula").toLowerCase());
            element3.addContent((Content)element4);
            element4 = new Element("mass_mono");
            element4.setText(resultSet.getString("mass_mono"));
            element3.addContent((Content)element4);
            element4 = new Element("mass_avg");
            element4.setText(resultSet.getString("mass_avg"));
            element3.addContent((Content)element4);
            element4 = new Element("charge");
            element4.setText(resultSet.getString("charge"));
            element3.addContent((Content)element4);
            element2.addContent((Content)element3);
        }
        element.addContent((Content)element2);
    }

    private void exportDericatisation(Element element) throws SQLException {
        Element element2 = new Element("dericatisation");
        Element element3 = null;
        Element element4 = null;
        ResultSet resultSet = this.m_objDB.getDerivatisations();
        while (resultSet.next()) {
            element3 = new Element("derivate");
            element3.setAttribute("name", resultSet.getString("name"));
            element3.setAttribute("abbr", resultSet.getString("abbr").toLowerCase());
            element4 = new Element("mass_mono");
            element4.setText(resultSet.getString("mass_mono"));
            element3.addContent((Content)element4);
            element4 = new Element("mass_avg");
            element4.setText(resultSet.getString("mass_avg"));
            element3.addContent((Content)element4);
            element4 = new Element("mass_pm_mono");
            element4.setText(resultSet.getString("mass_pm_mono"));
            element3.addContent((Content)element4);
            element4 = new Element("mass_pm_avg");
            element4.setText(resultSet.getString("mass_pm_avg"));
            element3.addContent((Content)element4);
            element4 = new Element("mass_pdm_mono");
            element4.setText(resultSet.getString("mass_pdm_mono"));
            element3.addContent((Content)element4);
            element4 = new Element("mass_pdm_avg");
            element4.setText(resultSet.getString("mass_pdm_avg"));
            element3.addContent((Content)element4);
            element4 = new Element("mass_pac_mono");
            element4.setText(resultSet.getString("mass_pac_mono"));
            element3.addContent((Content)element4);
            element4 = new Element("mass_pac_avg");
            element4.setText(resultSet.getString("mass_pac_avg"));
            element3.addContent((Content)element4);
            element4 = new Element("mass_pdac_mono");
            element4.setText(resultSet.getString("mass_pdac_mono"));
            element3.addContent((Content)element4);
            element4 = new Element("mass_pdac_avg");
            element4.setText(resultSet.getString("mass_pdac_avg"));
            element3.addContent((Content)element4);
            element2.addContent((Content)element3);
        }
        element.addContent((Content)element2);
    }

    private void exportMolecules(Element element) throws SQLException {
        Element element2 = new Element("molecules");
        Element element3 = null;
        Element element4 = null;
        ResultSet resultSet = this.m_objDB.getMolecules();
        while (resultSet.next()) {
            element3 = new Element("small_molecules");
            element4 = new Element("name");
            String string = resultSet.getString("formula");
            string = string.replaceAll("<sub>", "");
            string = string.replaceAll("</sub>", "");
            element4.setText(string.toLowerCase());
            element3.addContent((Content)element4);
            element4 = new Element("mass_mono");
            element4.setText(resultSet.getString("mass_mono"));
            element3.addContent((Content)element4);
            element4 = new Element("mass_avg");
            element4.setText(resultSet.getString("mass_avg"));
            element3.addContent((Content)element4);
            element2.addContent((Content)element3);
        }
        element.addContent((Content)element2);
    }
}

