/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.workbench.lifecycle.PostContextCreate;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.DataModelHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.GritsDataModelService;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.core.datamodel.io.MissingReaderException;
import org.grits.toolbox.core.datamodel.io.ProjectFileHandler;
import org.grits.toolbox.core.datamodel.property.WorkspaceProperty;
import org.grits.toolbox.core.log.GRITSLog;
import org.grits.toolbox.core.preference.GritsPreferenceStore;
import org.grits.toolbox.core.preference.share.IGritsPreferenceStore;
import org.grits.toolbox.core.preference.share.ProjectPreferenceStore;
import org.grits.toolbox.core.service.IGritsDataModelService;
import org.grits.toolbox.core.service.IGritsUIService;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.core.utils.ProjectEntry;
import org.grits.toolbox.core.utils.WorkspaceXMLHandler;
import org.grits.toolbox.core.workspace.WorkspaceDialog;
import org.grits.toolbox.core.workspace.WorkspaceHistoryFileHandler;
import org.osgi.framework.FrameworkUtil;

public class ApplicationManager {
    private static final Logger logger = Logger.getLogger(ApplicationManager.class);
    private static final int OK = 0;
    private static final int CLOSE = 1;
    private static final int EXIT = 2;
    @Inject
    IEclipseContext eclipseContext;

    @PostContextCreate
    void postContextCreate(IApplicationContext applicationContext) {
        GRITSLog.startLog();
        logger.info((Object)"Starting GRITS Application....");
        this.setConfigVariables();
        int result = this.createWorkspace();
        if (result == 1 || result == 2) {
            System.exit(-1);
        }
        if ((result = this.loadDataModel()) == 1) {
            System.exit(-1);
        }
        logger.info((Object)("Configuration Directory \t: " + PropertyHandler.getVariable("configuration_location")));
        logger.info((Object)("Workspace Location \t: " + PropertyHandler.getVariable("workspace_location") + ".workspace.xml"));
        logger.info((Object)("History File \t\t: " + PropertyHandler.getVariable("configuration_location") + "/history.xml"));
        this.disableGeneralMenuItems();
        applicationContext.applicationRunning();
    }

    private void disableGeneralMenuItems() {
        Menu systemMenu = Display.getDefault().getSystemMenu();
        if (systemMenu != null) {
            MenuItem sysItem = ApplicationManager.getSystemItem(systemMenu, -2);
            sysItem.setEnabled(false);
            MenuItem aboutItem = ApplicationManager.getSystemItem(systemMenu, -1);
            aboutItem.setEnabled(false);
        }
    }

    static MenuItem getSystemItem(Menu menu, int id) {
        MenuItem[] menuItemArray = menu.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem item = menuItemArray[n2];
            if (item.getID() == id) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    private void setConfigVariables() {
        logger.info((Object)"Setting configuration variables for grits.");
        this.eclipseContext.set(DataModelHandler.class, (Object)((DataModelHandler)ContextInjectionFactory.make(DataModelHandler.class, (IEclipseContext)this.eclipseContext)));
        this.eclipseContext.set(PropertyHandler.class, (Object)((PropertyHandler)ContextInjectionFactory.make(PropertyHandler.class, (IEclipseContext)this.eclipseContext)));
        this.eclipseContext.set(IGritsPreferenceStore.class, (Object)((IGritsPreferenceStore)ContextInjectionFactory.make(GritsPreferenceStore.class, (IEclipseContext)this.eclipseContext)));
        this.eclipseContext.set(ProjectPreferenceStore.class, (Object)((ProjectPreferenceStore)ContextInjectionFactory.make(ProjectPreferenceStore.class, (IEclipseContext)this.eclipseContext)));
        Location configLoc = Platform.getConfigurationLocation();
        this.eclipseContext.set("configuration_location_install", (Object)(String.valueOf(configLoc.getURL().getPath()) + "org.grits.toolbox"));
        PropertyHandler.setVariable("configuration_location_install", String.valueOf(configLoc.getURL().getPath()) + "org.grits.toolbox");
        logger.info((Object)("Installation Configuration Directory : " + PropertyHandler.getVariable("configuration_location_install")));
        try {
            String homeDirectory = System.getProperty("user.home");
            if (homeDirectory != null && homeDirectory.trim().length() > 0) {
                String gritsFolderName = String.valueOf(homeDirectory) + File.separator + ".grits-toolbox";
                File gritsFolder = new File(gritsFolderName);
                if (!gritsFolder.exists()) {
                    gritsFolder.mkdirs();
                }
                this.eclipseContext.set("configuration_location", (Object)gritsFolderName);
                PropertyHandler.setVariable("configuration_location", gritsFolderName);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Unable to load \".grits-toolbox\" folder from home directory\n" + e.getMessage()), (Throwable)e);
            this.eclipseContext.set("configuration_location", (Object)(String.valueOf(configLoc.getURL().getPath()) + "org.grits.toolbox"));
            PropertyHandler.setVariable("configuration_location", String.valueOf(configLoc.getURL().getPath()) + "org.grits.toolbox");
        }
        logger.info((Object)("Configuration Directory : " + PropertyHandler.getVariable("configuration_location")));
        logger.info((Object)"Variables Set for Grits Application");
    }

    @PreDestroy
    private void dispose(IApplicationContext applicationContext) {
        logger.info((Object)"Removing services");
        try {
            logger.info((Object)"Removing GritsUIService");
            FrameworkUtil.getBundle(this.getClass()).getBundleContext().ungetService(Platform.getBundle((String)"org.grits.toolbox.core").getBundleContext().getServiceReference(IGritsUIService.class));
        }
        catch (Exception e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
        }
        try {
            logger.info((Object)"Removing GritsDataModelService");
            FrameworkUtil.getBundle(this.getClass()).getBundleContext().ungetService(Platform.getBundle((String)"org.grits.toolbox.core").getBundleContext().getServiceReference(IGritsDataModelService.class));
        }
        catch (Exception e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
        }
        logger.info((Object)"Services removed");
    }

    private int createWorkspace() {
        logger.info((Object)"Initializing Grits workspace..");
        int result = 0;
        Shell shell = PropertyHandler.getModalDialog(Display.getCurrent().getActiveShell());
        result = this.createWorkspaceDialog();
        if (result == 1 || result == 2) {
            return result;
        }
        try {
            if (!WorkspaceXMLHandler.CheckWorkspaceXMLExist()) {
                WorkspaceXMLHandler.createNewWorkspaceXMLFile();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            ErrorUtils.createErrorMessageBoxReturn(shell, "Unable to create workspace xml file", e);
        }
        try {
            WorkspaceXMLHandler.checkWorkspaceXMLfile();
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            result = ErrorUtils.createErrorMessageBoxReturn(shell, "Invalid workspace file", new IOException("Missing or invalid tag\nPlease choose another workspace"));
            result = this.createWorkspace();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            result = ErrorUtils.createErrorMessageBoxReturn(shell, "Invalid workspace file", new IOException("Missing or invalid tag\nPlease choose another workspace"));
            result = this.createWorkspace();
        }
        return result;
    }

    private int createWorkspaceDialog() {
        File configDir = new File(PropertyHandler.getVariable("configuration_location"));
        Shell shell = PropertyHandler.getModalDialog(Display.getCurrent().getActiveShell());
        this.locateCenterOfMonitor(shell);
        if (!configDir.exists()) {
            boolean created = new File(PropertyHandler.getVariable("configuration_location")).mkdir();
            if (!created) {
                return ErrorUtils.createErrorMessageBoxReturn(shell, "Error", new IOException("Configuration folder cannot be created."));
            }
            try {
                WorkspaceHistoryFileHandler.createHistoryXMLFile();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                return ErrorUtils.createErrorMessageBoxReturn(shell, "Error: Cannot create history xml", e);
            }
        }
        if (!WorkspaceHistoryFileHandler.isHistoryExists()) {
            try {
                WorkspaceHistoryFileHandler.createHistoryXMLFile();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                return ErrorUtils.createErrorMessageBoxReturn(shell, "Error: Cannot create history xml", e);
            }
        }
        WorkspaceDialog dialog = new WorkspaceDialog(shell);
        int result = dialog.open();
        PropertyHandler.setVariable("workspace_location", String.valueOf(dialog.getPath()) + File.separator);
        this.eclipseContext.set("workspace_location", (Object)(String.valueOf(dialog.getPath()) + File.separator));
        return result;
    }

    private void locateCenterOfMonitor(Shell shell) {
        Monitor primary = shell.getDisplay().getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        shell.setLocation(x, y);
        shell.setSize(500, 300);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int loadDataModel() {
        Entry workspaceEntry = new Entry();
        workspaceEntry.setDisplayName("workspace");
        WorkspaceProperty wp = new WorkspaceProperty();
        wp.setLocation(PropertyHandler.getVariable("workspace_location"));
        workspaceEntry.setProperty(wp);
        IGritsDataModelService dataModelService = (IGritsDataModelService)this.eclipseContext.get(IGritsDataModelService.class);
        dataModelService.setRoot(workspaceEntry);
        this.eclipseContext.set("grits_workspace_entry", (Object)workspaceEntry);
        GritsDataModelService.updateMode = false;
        Display display = Display.getCurrent();
        Shell shell = PropertyHandler.getModalDialog(display.getActiveShell());
        ContextInjectionFactory.make(ProjectFileHandler.class, (IEclipseContext)this.eclipseContext);
        ProjectEntry[] projectFolders = null;
        try {
            projectFolders = WorkspaceXMLHandler.getProjectFolders();
            Entry projectEntry = null;
            ProjectEntry[] projectEntryArray = projectFolders;
            int n = projectFolders.length;
            int n2 = 0;
            while (n2 < n) {
                block20: {
                    Shell shell1;
                    ProjectEntry projectFolder = projectEntryArray[n2];
                    try {
                        projectEntry = projectFolder.getOpen() != false ? ProjectFileHandler.loadProject(projectFolder.getName()) : ProjectFileHandler.loadPartialProject(projectFolder.getName());
                        dataModelService.addEntry(workspaceEntry, projectEntry);
                        WorkspaceXMLHandler.setOpenClosed(projectEntry);
                    }
                    catch (FileNotFoundException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        if (e.getMessage().contains("Access is denied")) {
                            try {
                                projectEntry = ProjectFileHandler.loadPartialProject(projectFolder.getName());
                                dataModelService.addEntry(workspaceEntry, projectEntry);
                                WorkspaceXMLHandler.closeProject(projectFolder.getName());
                            }
                            catch (IOException ex) {
                                shell1 = PropertyHandler.getModalDialog(display.getActiveShell());
                                logger.error((Object)ex.getMessage(), (Throwable)ex);
                                ErrorUtils.createErrorMessageBoxReturn(shell1, "Error", ex);
                                break block20;
                            }
                            catch (Exception e1) {
                                shell1 = PropertyHandler.getModalDialog(display.getActiveShell());
                                logger.error((Object)e1.getMessage(), (Throwable)e1);
                                ErrorUtils.createErrorMessageBoxReturn(shell1, "Error", e1);
                                return 1;
                            }
                        }
                        try {
                            WorkspaceXMLHandler.removeProjectEntry(projectFolder.getName());
                        }
                        catch (Exception e1) {
                            shell1 = PropertyHandler.getModalDialog(display.getActiveShell());
                            logger.error((Object)e1.getMessage(), (Throwable)e1);
                            ErrorUtils.createErrorMessageBoxReturn(shell1, "Error", e1);
                            return 1;
                        }
                    }
                    catch (IOException | UnsupportedVersionException | MissingReaderException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        try {
                            projectEntry = ProjectFileHandler.loadPartialProject(projectFolder.getName());
                            dataModelService.addEntry(workspaceEntry, projectEntry);
                            WorkspaceXMLHandler.closeProject(projectFolder.getName());
                        }
                        catch (IOException iOException) {
                            try {
                                WorkspaceXMLHandler.removeProjectEntry(projectFolder.getName());
                            }
                            catch (Exception e1) {
                                shell1 = PropertyHandler.getModalDialog(display.getActiveShell());
                                logger.error((Object)e1.getMessage(), (Throwable)e1);
                                ErrorUtils.createErrorMessageBoxReturn(shell1, "Error", e1);
                                return 1;
                            }
                        }
                        catch (Exception e1) {
                            shell1 = PropertyHandler.getModalDialog(display.getActiveShell());
                            logger.error((Object)e1.getMessage(), (Throwable)e1);
                            ErrorUtils.createErrorMessageBoxReturn(shell1, "Error", e1);
                            return 1;
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        try {
                            WorkspaceXMLHandler.removeProjectEntry(projectFolder.getName());
                        }
                        catch (Exception e1) {
                            shell1 = PropertyHandler.getModalDialog(display.getActiveShell());
                            logger.error((Object)e1.getMessage(), (Throwable)e1);
                            ErrorUtils.createErrorMessageBoxReturn(shell1, "Error", e1);
                            return 1;
                        }
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return ErrorUtils.createErrorMessageBoxReturn(shell, "Error", e);
        }
        GritsDataModelService.updateMode = true;
        return 0;
    }
}

