/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.ontology;

import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class OntologyManager {
    public static String ontURI = "http://www.grits-toolbox.org/ontology/experimentdesigner";
    public static String baseURI = String.valueOf(ontURI) + "#";
    public static String dcTermsURI = "http://purl.org/dc/terms/";
    public static final String PROTOCOLCATEGORY_CLASS_URI = String.valueOf(baseURI) + "Category";
    public static final String TOPLEVELCATEGORY_CLASS_URI = String.valueOf(baseURI) + "PaletteCategory";
    public static final String PARAMETERGROUP_CLASS_URI = String.valueOf(baseURI) + "ParameterGroup";
    public static final String PARAMETER_CLASS_URI = String.valueOf(baseURI) + "Parameter";
    public static final String PROTOCOL_CLASS_URI = String.valueOf(baseURI) + "Protocol";
    public static final String PAPER_CLASS_URI = String.valueOf(baseURI) + "PaperReference";
    public static final String PARAMETERCONTEXT_CLASS_URI = String.valueOf(baseURI) + "ParameterContext";
    public static final String PARAMETER_GROUPCONTEXT_CLASS_URI = String.valueOf(baseURI) + "ParameterGroupContext";
    public static final String UNIT_URI = String.valueOf(baseURI) + "Unit";
    public static final String NAMESPACE_CLASS_URI = String.valueOf(baseURI) + "namespace";
    public OntModel standardOntologymodel = null;
    public OntModel localOntologymodel = null;

    public OntologyManager() {
    }

    public OntologyManager(OntModel model) {
        this.standardOntologymodel = model;
    }

    public OntologyManager(OntModel model, OntModel local) {
        this.standardOntologymodel = model;
        this.localOntologymodel = local;
    }

    public OntologyManager(InputStream standardInputOntology) {
        this.standardOntologymodel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM_RDFS_INF, null);
        this.standardOntologymodel.read(standardInputOntology, baseURI);
    }

    public OntologyManager(InputStream standardInputOntology, InputStream localInputOntology) {
        this.standardOntologymodel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM_RDFS_INF, null);
        this.standardOntologymodel.read(standardInputOntology, baseURI);
        this.localOntologymodel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM_RDFS_INF, null);
        this.localOntologymodel.read(localInputOntology, baseURI);
    }

    public void reloadLocalOntology(InputStream localInputOntology) {
        this.localOntologymodel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM_RDFS_INF, null);
        this.localOntologymodel.read(localInputOntology, baseURI);
    }

    public void writeOntology(OntModel model, OutputStream outputOntology) {
        model.write(outputOntology);
    }

    public void addProperty(OntModel model, String subjectUri, String property, String objectUri) {
        Individual indiv = model.getIndividual(subjectUri);
        String propertyUri = String.valueOf(baseURI) + property;
        ObjectProperty prop = model.getObjectProperty(propertyUri);
        if (prop != null) {
            indiv.addProperty((Property)prop, (RDFNode)model.getIndividual(objectUri));
        }
    }

    public void addLiteral(OntModel model, String subjectUri, String property, Literal literalValue) {
        Individual indiv = model.getIndividual(subjectUri);
        String propertyUri = String.valueOf(baseURI) + property;
        Property prop = model.getProperty(propertyUri);
        if (prop != null) {
            indiv.addLiteral(prop, literalValue);
        }
    }

    public boolean addComment(OntModel model, String subjectUri, String comment) {
        Individual indiv = this.getIndividual(model, subjectUri);
        if (indiv != null) {
            indiv.addComment(comment, null);
            return true;
        }
        return false;
    }

    public boolean addAnnotation(OntModel model, String subjectUri, String annotationName, String value) {
        Individual indiv = this.getIndividual(model, subjectUri);
        if (indiv != null) {
            Literal literalValue = model.createLiteral(value);
            indiv.addLiteral(model.getProperty(String.valueOf(dcTermsURI) + annotationName), literalValue);
            return true;
        }
        return false;
    }

    public String createNewIndividual(OntModel model, String classUri, String label) throws UnsupportedEncodingException {
        String indivURI = String.valueOf(baseURI) + URLEncoder.encode(label.replace(' ', '_'), "UTF-8");
        Individual indiv = model.createIndividual(indivURI, (Resource)model.getOntClass(classUri));
        indiv.setLabel(label, null);
        return indiv.getURI();
    }

    public void createNewIndividualwithURI(OntModel model, String classUri, String label, String uri) {
        Individual indiv = model.createIndividual(uri, (Resource)model.getOntClass(classUri));
        indiv.setLabel(label, null);
    }

    String createUniqueRandomIndividualURI(String className) {
        String newURI = String.valueOf(baseURI) + className.toLowerCase().replaceAll(" ", "_");
        Random random = new Random();
        int randomLength = 8;
        boolean notUnique = true;
        String randomSuffix = null;
        Resource searchResource = null;
        while (notUnique) {
            randomSuffix = "";
            int i = 0;
            while (i < randomLength) {
                char randamCharacter = (char)(97 + random.nextInt(26));
                randomSuffix = String.valueOf(randomSuffix) + randamCharacter;
                ++i;
            }
            searchResource = ResourceFactory.createResource((String)(String.valueOf(newURI) + "_" + randomSuffix));
            notUnique = this.standardOntologymodel.containsResource((RDFNode)searchResource);
            if (this.localOntologymodel == null) continue;
            boolean bl = notUnique = notUnique || this.localOntologymodel.containsResource((RDFNode)searchResource);
        }
        newURI = searchResource.getURI();
        return newURI;
    }

    public Individual getIndividual(String uri) {
        return this.getIndividual(this.standardOntologymodel, uri);
    }

    public Individual getIndividual(OntModel model, String uri) {
        return model.getIndividual(uri);
    }

    public List<Individual> getAllIndiviudalsOfClass(String classUri) {
        return this.getAllIndiviudalsOfClass(this.standardOntologymodel, classUri);
    }

    public List<Individual> getAllIndiviudalsOfClass(OntModel model, String classUri) {
        OntClass thisClass = model.getOntClass(classUri);
        Set individuals = model.listIndividuals((Resource)thisClass).toSet();
        ArrayList<Individual> actualIndividuals = new ArrayList<Individual>(individuals);
        return actualIndividuals;
    }

    public Set<String> getAllSubjectURIs(String propertyLabel, String objectUri) {
        return this.getAllSubjectURIs(this.standardOntologymodel, propertyLabel, objectUri);
    }

    public Set<String> getAllSubjectURIs(OntModel model, String propertyLabel, String objectUri) {
        Property property = model.getProperty(String.valueOf(baseURI) + propertyLabel);
        ResIterator subjectIterator = model.listSubjectsWithProperty(property, (RDFNode)model.getIndividual(objectUri));
        HashSet<String> subjects = new HashSet<String>();
        while (subjectIterator.hasNext()) {
            subjects.add(((Resource)subjectIterator.next()).getURI());
        }
        return subjects;
    }

    public Set<String> getAllIndividualURIs(OntModel model, Property property, String propertyValue) {
        ResIterator subjectIterator = model.listResourcesWithProperty(property, (Object)propertyValue);
        HashSet<String> subjects = new HashSet<String>();
        while (subjectIterator.hasNext()) {
            subjects.add(((Resource)subjectIterator.next()).getURI());
        }
        return subjects;
    }

    public List<Individual> getAllSubjects(String propertyLabel, String objectUri) {
        return this.getAllSubjects(this.standardOntologymodel, propertyLabel, objectUri);
    }

    public List<Individual> getAllSubjects(OntModel model, String propertyLabel, String objectUri) {
        Property property = model.getProperty(String.valueOf(baseURI) + propertyLabel);
        ArrayList<Individual> subjects = new ArrayList<Individual>();
        Individual indiv = model.getIndividual(objectUri);
        if (indiv == null) {
            return subjects;
        }
        ResIterator subjectIterator = model.listSubjectsWithProperty(property, (RDFNode)model.getIndividual(objectUri));
        while (subjectIterator.hasNext()) {
            Resource subject = (Resource)subjectIterator.next();
            if (model.getIndividual(subject.getURI()) == null) continue;
            subjects.add(model.getIndividual(subject.getURI()));
        }
        return subjects;
    }

    public List<Individual> getAllObjects(Individual subject, String property) {
        return this.getAllObjects(this.standardOntologymodel, subject, property);
    }

    public List<Individual> getAllObjects(OntModel model, Individual subject, String property) {
        NodeIterator objectIterator = model.listObjectsOfProperty((Resource)subject, model.getProperty(String.valueOf(baseURI) + property));
        ArrayList<Individual> objects = new ArrayList<Individual>();
        for (RDFNode n : objectIterator.toList()) {
            String uri = n.asResource().getURI();
            Individual indiv = model.getIndividual(uri);
            objects.add(indiv);
        }
        return objects;
    }

    public Literal getLiteralValue(Individual indiv, String propertyName) {
        return this.getLiteralValue(this.standardOntologymodel, indiv, propertyName);
    }

    public Literal getLiteralValue(OntModel model, Individual indiv, String propertyName) {
        Literal val = null;
        RDFNode node = indiv.getPropertyValue(model.getProperty(String.valueOf(baseURI) + propertyName));
        if (node != null && node.isLiteral()) {
            val = node.asLiteral();
        }
        return val;
    }

    public List<Literal> getLiteralValues(Individual indiv, String propertyName) {
        return this.getLiteralValues(this.standardOntologymodel, indiv, propertyName);
    }

    public List<Literal> getLiteralValues(OntModel model, Individual indiv, String propertyName) {
        ArrayList<Literal> literals = new ArrayList<Literal>();
        NodeIterator nodeIterator = indiv.listPropertyValues(model.getProperty(String.valueOf(baseURI) + propertyName));
        RDFNode node = null;
        while (nodeIterator.hasNext()) {
            node = nodeIterator.next();
            if (!node.isLiteral()) continue;
            literals.add(node.asLiteral());
        }
        return literals;
    }

    public Literal getAnnotationValue(Individual indiv, String annotationName) {
        return this.getAnnotationValue(this.standardOntologymodel, indiv, annotationName);
    }

    public Literal getAnnotationValue(OntModel model, Individual indiv, String annotationName) {
        Literal val = null;
        RDFNode node = indiv.getPropertyValue(model.getProperty(String.valueOf(dcTermsURI) + annotationName));
        if (node != null && node.isLiteral()) {
            val = node.asLiteral();
        }
        return val;
    }

    public List<Literal> getAnnotationValues(OntModel model, Individual indiv, String annotationName) {
        ArrayList<Literal> literals = new ArrayList<Literal>();
        NodeIterator nodeIterator = indiv.listPropertyValues(model.getProperty(String.valueOf(dcTermsURI) + annotationName));
        RDFNode node = null;
        while (nodeIterator.hasNext()) {
            node = nodeIterator.next();
            if (!node.isLiteral()) continue;
            literals.add(node.asLiteral());
        }
        return literals;
    }
}

