/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.pdfgeneration;

import java.util.List;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.grits.toolbox.editor.experimentdesigner.pdfgeneration.Column;

public class Table {
    private float margin;
    private float height;
    private float maxHeight;
    private PDRectangle pageSize;
    private boolean isLandscape;
    private float rowHeight;
    private PDFont textFont;
    private float fontSize;
    private PDFont headerFont;
    private Integer numberOfRows;
    private List<Column> columns;
    private String[][] content;
    private float cellMargin;
    private float maxRowHeight = 1.0f;

    public Integer getNumberOfColumns() {
        return this.getColumns().size();
    }

    public float getWidth() {
        float tableWidth = 0.0f;
        for (Column column : this.columns) {
            tableWidth += column.getWidth();
        }
        return tableWidth;
    }

    public float getMargin() {
        return this.margin;
    }

    public void setMargin(float margin) {
        this.margin = margin;
    }

    public PDRectangle getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(PDRectangle pageSize) {
        this.pageSize = pageSize;
    }

    public PDFont getTextFont() {
        return this.textFont;
    }

    public void setTextFont(PDFont textFont) {
        this.textFont = textFont;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(float fontSize) {
        this.fontSize = fontSize;
    }

    public String[] getColumnsNamesAsArray() {
        String[] columnNames = new String[this.getNumberOfColumns().intValue()];
        int i = 0;
        while (i < this.getNumberOfColumns()) {
            columnNames[i] = this.columns.get(i).getName();
            ++i;
        }
        return columnNames;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public void setColumns(List<Column> columns) {
        this.columns = columns;
    }

    public Integer getNumberOfRows() {
        return this.numberOfRows;
    }

    public void setNumberOfRows(Integer numberOfRows) {
        this.numberOfRows = numberOfRows;
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public float getRowHeight() {
        return this.rowHeight;
    }

    public void setRowHeight(float rowHeight) {
        this.rowHeight = rowHeight;
    }

    public String[][] getContent() {
        return this.content;
    }

    public void setContent(String[][] content) {
        this.content = content;
    }

    public float getCellMargin() {
        return this.cellMargin;
    }

    public void setCellMargin(float cellMargin) {
        this.cellMargin = cellMargin;
    }

    public boolean isLandscape() {
        return this.isLandscape;
    }

    public void setLandscape(boolean isLandscape) {
        this.isLandscape = isLandscape;
    }

    public float getMaxRowHeight() {
        return this.maxRowHeight;
    }

    public void setMaxRowHeight(float maxRowHeight) {
        this.maxRowHeight = maxRowHeight;
    }

    public PDFont getHeaderFont() {
        return this.headerFont;
    }

    public void setHeaderFont(PDFont headerFont) {
        this.headerFont = headerFont;
    }

    public float getMaxHeight() {
        return this.maxHeight;
    }

    public void setMaxHeight(float maxHeight) {
        this.maxHeight = maxHeight;
    }
}

