/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.dialogs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.entry.qrtpcr.dialogs.CustomSelectionDialogWithDescription;
import org.grits.toolbox.entry.qrtpcr.dialogs.PlateLayoutDialog;
import org.grits.toolbox.entry.qrtpcr.dialogs.PlateLayoutToolWizard;
import org.grits.toolbox.entry.qrtpcr.model.Gene;
import org.grits.toolbox.entry.qrtpcr.model.GeneList;
import org.grits.toolbox.entry.qrtpcr.model.PlateLayout;
import org.grits.toolbox.entry.qrtpcr.model.Size;
import org.grits.toolbox.entry.qrtpcr.model.Well;
import org.grits.toolbox.entry.qrtpcr.util.FileUtils;

public class PlateLayoutToolInfoPage
extends WizardPage
implements ModifyListener {
    private static Logger logger = Logger.getLogger(PlateLayoutToolInfoPage.class);
    private Text inputGeneList;
    private Text replicatesText;
    private Text plateWidth;
    private Text plateHeight;
    private Text layoutNameText;
    private Text descriptionText;
    GeneList inputList;
    Map<Gene, Well> controlGeneLocations = new HashMap<Gene, Well>();
    PlateLayout layout;
    private Table table;
    protected Well[] defaultGeneLocations;
    private TableViewer controlTableViewer;
    private Button btnAutoGeneratePlate;
    private Button btnBrowse;

    protected PlateLayoutToolInfoPage(String pageName) {
        super(pageName);
        this.layout = new PlateLayout();
        this.layout.setSize(new Size(12, 8));
        this.layout.setNumberOfReplicates(3);
        this.setPageComplete(false);
        this.defaultGeneLocations = new Well[]{new Well('A', 7), new Well('H', 7), new Well('H', 10)};
    }

    protected PlateLayoutToolInfoPage(String pageName, PlateLayout layout) {
        super(pageName);
        this.layout = layout;
        this.inputList = layout.getInputList();
        this.controlGeneLocations = layout.getControlGeneLocations();
        this.setPageComplete(false);
        this.defaultGeneLocations = new Well[]{new Well('A', 7), new Well('H', 7), new Well('H', 10)};
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout(4, false));
        this.setMessage("Enter information about the layout");
        Label lblLayoutName = new Label(composite, 0);
        lblLayoutName.setText("Plate Layout Name");
        new Label(composite, 0);
        this.layoutNameText = new Text(composite, 2048);
        this.layoutNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        new Label(composite, 0);
        if (this.layout.getName() != null) {
            this.layoutNameText.setText(this.layout.getName());
        }
        this.layoutNameText.addModifyListener((ModifyListener)this);
        Label lblDescription = new Label(composite, 0);
        lblDescription.setText("Description");
        new Label(composite, 0);
        this.descriptionText = new Text(composite, 2048);
        GridData gd_descriptionText = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_descriptionText.heightHint = 30;
        this.descriptionText.setLayoutData((Object)gd_descriptionText);
        new Label(composite, 0);
        if (this.layout.getDescription() != null) {
            this.descriptionText.setText(this.layout.getDescription());
        }
        this.descriptionText.addModifyListener((ModifyListener)this);
        Label lblInputGeneList = new Label(composite, 0);
        lblInputGeneList.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblInputGeneList.setText("Input Gene List");
        new Label(composite, 0);
        this.inputGeneList = new Text(composite, 2056);
        this.inputGeneList.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnBrowse = new Button(composite, 0);
        this.btnBrowse.setText("Browse");
        this.btnBrowse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                List<Object> input = new ArrayList();
                try {
                    input = FileUtils.getAllGeneLists(true);
                }
                catch (Exception ex) {
                    logger.warn((Object)" Cannot load the gene lists! ", (Throwable)ex);
                }
                CustomSelectionDialogWithDescription dialog = new CustomSelectionDialogWithDescription(Display.getCurrent().getActiveShell(), true, PlateLayoutToolInfoPage.this.inputGeneList, input);
                dialog.initializeGeneListSelectionDialog();
                if (dialog.open() == 0) {
                    PlateLayoutToolInfoPage.this.inputList = (GeneList)dialog.getSelection();
                    PlateLayoutToolInfoPage.this.layout.setInputList(PlateLayoutToolInfoPage.this.inputList);
                    PlateLayoutToolInfoPage.this.layout.setPlates(null);
                    PlateLayoutToolInfoPage.this.controlGeneLocations = new HashMap<Gene, Well>();
                    int i = 0;
                    for (Gene gene : PlateLayoutToolInfoPage.this.inputList.getGenes()) {
                        if (!gene.getIsCommon().booleanValue()) continue;
                        if (i < PlateLayoutToolInfoPage.this.defaultGeneLocations.length) {
                            PlateLayoutToolInfoPage.this.controlGeneLocations.put(gene, PlateLayoutToolInfoPage.this.defaultGeneLocations[i]);
                        } else {
                            PlateLayoutToolInfoPage.this.controlGeneLocations.put(gene, new Well('A', 1));
                        }
                        ++i;
                    }
                    PlateLayoutToolInfoPage.this.controlTableViewer.setInput(PlateLayoutToolInfoPage.this.controlGeneLocations);
                    PlateLayoutToolInfoPage.this.controlTableViewer.refresh();
                    PlateLayoutToolInfoPage.this.layout.setControlGeneLocations(PlateLayoutToolInfoPage.this.controlGeneLocations);
                    PlateLayoutToolInfoPage.this.btnAutoGeneratePlate.setEnabled(true);
                    PlateLayoutToolInfoPage.this.btnAutoGeneratePlate.setSelection(true);
                    PlateLayoutToolInfoPage.this.checkStatus();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (this.layout.getInputList() != null) {
            this.inputGeneList.setText(this.layout.getInputList().getListName());
            this.btnBrowse.setEnabled(false);
        }
        Label lblNumberOfReplicates = new Label(composite, 0);
        lblNumberOfReplicates.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblNumberOfReplicates.setText("Number of Replicates");
        new Label(composite, 0);
        this.replicatesText = new Text(composite, 2048);
        GridData gd_replicatesText = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_replicatesText.widthHint = 133;
        this.replicatesText.setLayoutData((Object)gd_replicatesText);
        this.replicatesText.setText("" + this.layout.getNumberOfReplicates());
        this.replicatesText.addModifyListener((ModifyListener)this);
        new Label(composite, 0);
        Label lblPlateSize = new Label(composite, 0);
        lblPlateSize.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblPlateSize.setText("Plate Size");
        new Label(composite, 0);
        new Label(composite, 0);
        new Label(composite, 0);
        new Label(composite, 0);
        Label lblWidth = new Label(composite, 0);
        lblWidth.setText("width");
        this.plateWidth = new Text(composite, 2048);
        this.plateWidth.setText("" + this.layout.getSize().getWidth());
        GridData gd_plateWidth = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_plateWidth.widthHint = 133;
        this.plateWidth.setLayoutData((Object)gd_plateWidth);
        new Label(composite, 0);
        new Label(composite, 0);
        this.plateWidth.addModifyListener((ModifyListener)this);
        Label lblHeight = new Label(composite, 0);
        lblHeight.setText("height");
        this.plateHeight = new Text(composite, 2048);
        GridData gd_plateHeight = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_plateHeight.widthHint = 133;
        this.plateHeight.setLayoutData((Object)gd_plateHeight);
        this.plateHeight.setText("" + this.layout.getSize().getHeight());
        this.plateHeight.addModifyListener((ModifyListener)this);
        new Label(composite, 0);
        Label lblControlGenes = new Label(composite, 0);
        lblControlGenes.setText("Control Genes");
        this.controlTableViewer = new TableViewer(composite, 67584);
        this.table = this.controlTableViewer.getTable();
        GridData gd = new GridData(4, 4, true, true, 2, 1);
        gd.heightHint = 50;
        this.table.setLayoutData((Object)gd);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.controlTableViewer, 0);
        TableColumn tblclmnControlGene = tableViewerColumn.getColumn();
        tblclmnControlGene.setWidth(100);
        tblclmnControlGene.setText("Control Gene");
        tableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Map.Entry) {
                    return ((Gene)((Map.Entry)element).getKey()).getGeneIdentifier();
                }
                return super.getText(element);
            }
        });
        TableViewerColumn tableViewerColumn_1 = new TableViewerColumn(this.controlTableViewer, 0);
        TableColumn tblclmnLocation = tableViewerColumn_1.getColumn();
        tblclmnLocation.setWidth(100);
        tblclmnLocation.setText("Location");
        tableViewerColumn_1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Map.Entry) {
                    return PlateLayoutToolInfoPage.this.controlGeneLocations.get(((Map.Entry)element).getKey()).toString();
                }
                return super.getText(element);
            }
        });
        tableViewerColumn_1.setEditingSupport(new EditingSupport((ColumnViewer)this.controlTableViewer){
            ComboBoxViewerCellEditor cellEditor;

            protected void setValue(Object element, Object value) {
                if (element instanceof Map.Entry) {
                    Well well = (Well)((Map.Entry)element).getValue();
                    if (value instanceof Well && value != null && !value.equals(well)) {
                        ((Map.Entry)element).setValue(value);
                    }
                    PlateLayoutToolInfoPage.this.controlTableViewer.update(element, null);
                }
            }

            protected Object getValue(Object element) {
                if (element instanceof Map.Entry) {
                    return PlateLayoutToolInfoPage.this.controlGeneLocations.get(((Map.Entry)element).getKey());
                }
                return null;
            }

            protected CellEditor getCellEditor(Object element) {
                this.cellEditor = new ComboBoxViewerCellEditor((Composite)this.getViewer().getControl(), 8);
                this.cellEditor.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
                this.cellEditor.setLabelProvider((IBaseLabelProvider)new LabelProvider());
                this.cellEditor.setInput(PlateLayoutToolInfoPage.this.generateGeneLocations());
                return this.cellEditor;
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        this.controlTableViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.controlTableViewer.setInput(this.controlGeneLocations);
        new Label(composite, 0);
        this.btnAutoGeneratePlate = new Button(composite, 32);
        this.btnAutoGeneratePlate.setAlignment(0x1000000);
        this.btnAutoGeneratePlate.setSelection(true);
        this.btnAutoGeneratePlate.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.btnAutoGeneratePlate.setText("Auto Generate Plate Layouts");
        if (this.layout.getPlates() != null) {
            this.btnAutoGeneratePlate.setEnabled(false);
            this.btnAutoGeneratePlate.setSelection(false);
        }
        new Label(composite, 0);
    }

    private void checkStatus() {
        this.canFlipToNextPage();
        this.getWizard().getContainer().updateButtons();
    }

    public boolean canFlipToNextPage() {
        if (this.layout != null) {
            if (this.layout.getName() == null) {
                return false;
            }
            if (this.inputList == null) {
                return false;
            }
            if (this.layout.getNumberOfReplicates() == null) {
                return false;
            }
            if (this.layout.getSize() == null || this.layout.getSize().getWidth() == -1 || this.layout.getSize().getHeight() == -1) {
                return false;
            }
            return this.layout.getControlGeneLocations() != null;
        }
        return false;
    }

    public IWizardPage getNextPage() {
        int platesNo = this.calculateNumberOfPlates();
        List<List<Gene>> listOfGeneLists = this.generateGeneListsForEachPlate(platesNo);
        PlateLayoutDialog nextPage = null;
        int i = 0;
        while (i < platesNo) {
            PlateLayoutDialog platePage = (PlateLayoutDialog)this.getWizard().getPage("Plate Page " + (i + 1));
            if (platePage == null) {
                platePage = new PlateLayoutDialog("Plate Page " + (i + 1), "Plate " + (i + 1), null);
                platePage.setWizard(this.getWizard());
                platePage.setLayout(this.layout);
                if (this.btnAutoGeneratePlate.getSelection()) {
                    platePage.layoutGenes(listOfGeneLists.get(i));
                } else {
                    platePage.setGeneList(listOfGeneLists.get(i));
                }
                ((PlateLayoutToolWizard)this.getWizard()).addPage((IWizardPage)platePage);
            }
            if (i == 0) {
                nextPage = platePage;
            }
            this.setPageComplete(true);
            ++i;
        }
        return nextPage;
    }

    private List<List<Gene>> generateGeneListsForEachPlate(int numOfPlates) {
        List<Gene> inputGenes;
        ArrayList<List<Gene>> listOfGenesLists = new ArrayList<List<Gene>>();
        int k = 0;
        int numberOfControlGenes = this.controlGeneLocations.keySet().size();
        int numberOfGenesPerPlate = this.layout.getSize().getWidth() * this.layout.getSize().getHeight() / this.layout.getNumberOfReplicates();
        if (numberOfGenesPerPlate > (inputGenes = this.inputList.getGenes()).size()) {
            numberOfGenesPerPlate = inputGenes.size();
        }
        int i = 0;
        while (i < numOfPlates) {
            ArrayList<Gene> plateGeneList = new ArrayList<Gene>();
            int j = 0;
            while (j < numberOfGenesPerPlate - numberOfControlGenes && k < inputGenes.size()) {
                Gene gene;
                if ((gene = inputGenes.get(k++)).getIsCommon().booleanValue()) {
                    --j;
                } else {
                    plateGeneList.add(gene);
                }
                ++j;
            }
            for (Gene gene : this.controlGeneLocations.keySet()) {
                plateGeneList.add(gene);
            }
            listOfGenesLists.add(plateGeneList);
            ++i;
        }
        return listOfGenesLists;
    }

    private int calculateNumberOfPlates() {
        int numberOfWells = this.layout.getSize().getWidth() * this.layout.getSize().getHeight();
        int numberOfGenes = this.inputList.getGenes().size() - this.controlGeneLocations.size();
        int numberOfReplicates = this.layout.getNumberOfReplicates();
        int numberOfPlates = (int)Math.ceil((double)(numberOfReplicates * numberOfGenes) / (double)numberOfWells);
        int totalGenes = numberOfPlates * this.controlGeneLocations.keySet().size() + numberOfGenes;
        if (totalGenes > numberOfPlates * numberOfWells / numberOfReplicates) {
            ++numberOfPlates;
        }
        return numberOfPlates;
    }

    public void modifyText(ModifyEvent e) {
        Text newText = (Text)e.widget;
        String newValue = newText.getText();
        if (newValue != null) {
            newValue = newValue.trim();
        }
        if (e.getSource().equals(this.layoutNameText)) {
            this.layout.setName(newValue);
        } else if (e.getSource().equals(this.descriptionText)) {
            this.layout.setDescription(newValue);
        } else if (e.getSource().equals(this.replicatesText)) {
            try {
                int numberOfReplicates = Integer.parseInt(newValue);
                this.layout.setNumberOfReplicates(numberOfReplicates);
            }
            catch (NumberFormatException numberFormatException) {
                this.setMessage("Please enter a number for number of replicates");
                this.layout.setNumberOfReplicates(null);
            }
        } else if (e.getSource().equals(this.plateHeight)) {
            try {
                int height = Integer.parseInt(newValue);
                this.layout.getSize().setHeight(height);
            }
            catch (NumberFormatException numberFormatException) {
                this.setMessage("Please enter a valid number for plate height");
                this.layout.getSize().setHeight(-1);
            }
        } else if (e.getSource().equals(this.plateWidth)) {
            try {
                int width = Integer.parseInt(newValue);
                this.layout.getSize().setWidth(width);
            }
            catch (NumberFormatException numberFormatException) {
                this.setMessage("Please enter a valid number for plate width");
                this.layout.getSize().setWidth(-1);
            }
        }
        this.checkStatus();
    }

    List<Well> generateGeneLocations() {
        ArrayList<Well> locations = new ArrayList<Well>();
        if (this.plateHeight != null && this.plateWidth != null && this.replicatesText != null) {
            int height = Integer.parseInt(this.plateHeight.getText());
            int width = Integer.parseInt(this.plateWidth.getText());
            int replicates = Integer.parseInt(this.replicatesText.getText());
            Character character = Character.valueOf('A');
            int charPos = 1;
            int loc = 1;
            int i = 1;
            while (i <= height) {
                int j = 1;
                while (j <= width) {
                    if (charPos == i && loc == j) {
                        Well well = new Well();
                        well.setX(character);
                        well.setY(loc);
                        locations.add(well);
                        loc += replicates;
                    }
                    ++j;
                }
                character = Character.valueOf((char)(character.charValue() + '\u0001'));
                ++charPos;
                loc = 1;
                ++i;
            }
        }
        return locations;
    }

    public PlateLayout getLayout() {
        return this.layout;
    }

    public void setLayout(PlateLayout layout) {
        this.layout = layout;
    }

    public void setWizard(IWizard newWizard) {
        super.setWizard(newWizard);
        ((PlateLayoutToolWizard)newWizard).layout = this.layout;
    }

    private static class ContentProvider
    implements IStructuredContentProvider {
        private ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof HashMap) {
                Set entrySet = ((HashMap)inputElement).entrySet();
                Object[] array = new Object[entrySet.size()];
                int i = 0;
                for (Map.Entry entry : entrySet) {
                    array[i++] = entry;
                }
                return array;
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

