/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.manager.actions;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.entry.qrtpcr.ImageRegistry;
import org.grits.toolbox.entry.qrtpcr.manager.GeneListManagerEditor;
import org.grits.toolbox.entry.qrtpcr.manager.actions.AddGeneDialog;
import org.grits.toolbox.entry.qrtpcr.model.Gene;

public class AddGeneToListAction
extends Action {
    private static final Logger logger = Logger.getLogger(AddGeneToListAction.class);
    GeneListManagerEditor editor;
    String organism;
    List<Gene> input;

    public AddGeneToListAction(GeneListManagerEditor geneListManagerEditor) {
        this.editor = geneListManagerEditor;
    }

    public void setInput(List<Gene> input) {
        this.input = input;
    }

    public void setOrganism(String organism) {
        this.organism = organism;
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageRegistry.getImageDescriptor(ImageRegistry.QrtPCRImage.ADD_ICON);
    }

    public String getText() {
        return "Add";
    }

    public String getToolTipText() {
        return "Add a new gene to the list";
    }

    public void run() {
        AddGeneDialog dialog = new AddGeneDialog(Display.getCurrent().getActiveShell(), this.input, this.organism);
        if (dialog.open() == 0) {
            Gene gene = dialog.getGene();
            List<Gene> existing = this.input;
            for (Gene gene2 : existing) {
                if (!gene2.getGeneIdentifier().equals(gene.getGeneIdentifier())) continue;
                logger.info((Object)("A gene with " + gene.getGeneIdentifier() + " already exists in the list. Not added!"));
                ErrorUtils.createErrorMessageBox((Shell)Display.getCurrent().getActiveShell(), (String)"A gene with this identifier already exists in the list");
                return;
            }
            existing.add(gene);
            this.editor.refreshGeneListPage(existing);
            this.editor.markDirty();
        }
    }
}

