/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import org.eurocarbdb.application.glycanbuilder.Geometry;
import org.eurocarbdb.application.glycanbuilder.GlycanRenderer;
import org.eurocarbdb.application.glycanbuilder.GraphicOptions;
import org.eurocarbdb.application.glycanbuilder.Linkage;
import org.eurocarbdb.application.glycanbuilder.LinkageRenderer;
import org.eurocarbdb.application.glycanbuilder.LinkageStyle;
import org.eurocarbdb.application.glycanbuilder.LinkageStyleDictionary;
import org.eurocarbdb.application.glycanbuilder.Paintable;

public abstract class AbstractLinkageRenderer
implements LinkageRenderer {
    protected LinkageStyleDictionary theLinkageStyleDictionary;
    protected GraphicOptions theGraphicOptions;

    public AbstractLinkageRenderer() {
        this.theLinkageStyleDictionary = new LinkageStyleDictionary();
        this.theGraphicOptions = new GraphicOptions();
    }

    public AbstractLinkageRenderer(GlycanRenderer src) {
        this.theLinkageStyleDictionary = src.getLinkageStyleDictionary();
        this.theGraphicOptions = src.getGraphicOptions();
    }

    public GraphicOptions getGraphicOptions() {
        return this.theGraphicOptions;
    }

    public void setGraphicOptions(GraphicOptions opt) {
        this.theGraphicOptions = opt;
    }

    public LinkageStyleDictionary getLinkageStyleDictionary() {
        return this.theLinkageStyleDictionary;
    }

    public void setLinkageStyleDictionary(LinkageStyleDictionary linkageStyleDictionary) {
        this.theLinkageStyleDictionary = linkageStyleDictionary;
    }

    public abstract void paintEdge(Paintable var1, Linkage var2, boolean var3, Rectangle var4, Rectangle var5, Rectangle var6, Rectangle var7);

    public abstract void paintInfo(Paintable var1, Linkage var2, Rectangle var3, Rectangle var4, Rectangle var5, Rectangle var6);

    protected abstract void paintInfo(Paintable var1, String var2, Rectangle var3, Rectangle var4, Rectangle var5, Rectangle var6, boolean var7, boolean var8, boolean var9);

    protected Point computePosition(Dimension tb, Rectangle p, Rectangle pb, Rectangle c, Rectangle cb, boolean toparent, boolean above, boolean multiple) {
        Point cp = Geometry.center(p);
        Point cc = Geometry.center(c);
        double r = 0.5 * (double)this.theGraphicOptions.LINKAGE_INFO_SIZE;
        double cx = 0.0;
        double cy = 0.0;
        double R = 0.0;
        double angle = 0.0;
        if (toparent) {
            cx = cp.x;
            cy = cp.y;
            angle = Geometry.angle(cc, cp);
            R = Geometry.getExclusionRadius(cp, angle, pb) + 2.0;
        } else {
            cx = c.x + c.width / 2;
            cy = c.y + c.height / 2;
            angle = Geometry.angle(cp, cc);
            R = Geometry.getExclusionRadius(cc, angle, cb) + 2.0;
        }
        double space = multiple ? 4.0 : 2.0;
        boolean add = above;
        if (toparent) {
            add = !add;
        }
        double tx = 0.0;
        double ty = 0.0;
        if (add) {
            tx = cx + (R + r) * Math.cos(angle) + (r + space) * Math.cos(angle - 1.5707963267948966);
            ty = cy + (R + r) * Math.sin(angle) + (r + space) * Math.sin(angle - 1.5707963267948966);
        } else {
            tx = cx + (R + r) * Math.cos(angle) + (r + space) * Math.cos(angle + 1.5707963267948966);
            ty = cy + (R + r) * Math.sin(angle) + (r + space) * Math.sin(angle + 1.5707963267948966);
        }
        return new Point((int)(tx -= tb.getWidth() / 2.0), (int)(ty += tb.getHeight() / 2.0));
    }

    private static Shape createLine(Point p1, Point p2) {
        Polygon l = new Polygon();
        l.addPoint(p1.x, p1.y);
        l.addPoint(p2.x, p2.y);
        return l;
    }

    protected Shape createCurve(Point p1, Point p2) {
        double cx = (double)(p1.x + p2.x) / 2.0;
        double cy = (double)(p1.y + p2.y) / 2.0;
        double r = Geometry.distance(p1, p2) / 2.0;
        double angle = Geometry.angle(p1, p2);
        double x1 = cx + r * Math.cos(angle);
        double y1 = cy + r * Math.sin(angle);
        double x2 = cx + r * Math.cos(angle + Math.PI);
        double y2 = cy + r * Math.sin(angle + Math.PI);
        double cx1 = cx + 0.1 * r * Math.cos(angle);
        double cy1 = cy + 0.1 * r * Math.sin(angle);
        double tx1 = cx1 + r * Math.cos(angle + 1.5707963267948966);
        double ty1 = cy1 + r * Math.sin(angle + 1.5707963267948966);
        double cx2 = cx + 0.1 * r * Math.cos(angle + Math.PI);
        double cy2 = cy + 0.1 * r * Math.sin(angle + Math.PI);
        double tx2 = cx2 + r * Math.cos(angle - 1.5707963267948966);
        double ty2 = cy2 + r * Math.sin(angle - 1.5707963267948966);
        return new CubicCurve2D.Double(x1, y1, tx1, ty1, tx2, ty2, x2, y2);
    }

    private Shape createCurve(Point p1, Point p2, boolean multiple) {
        if (multiple) {
            GeneralPath gp = new GeneralPath();
            double a = Geometry.angle(p1, p2);
            Shape curve1 = this.createCurve(Geometry.translate(p1, 2.0 * Math.cos(a + 1.5707963267948966), 2.0 * Math.sin(a + 1.5707963267948966)), Geometry.translate(p2, 2.0 * Math.cos(a + 1.5707963267948966), 2.0 * Math.sin(a + 1.5707963267948966)), false);
            gp.append(curve1, false);
            Shape curve2 = this.createCurve(Geometry.translate(p1, 2.0 * Math.cos(a - 1.5707963267948966), 2.0 * Math.sin(a - 1.5707963267948966)), Geometry.translate(p2, 2.0 * Math.cos(a - 1.5707963267948966), 2.0 * Math.sin(a - 1.5707963267948966)), false);
            gp.append(curve2, false);
            return gp;
        }
        return this.createCurve(p1, p2);
    }

    protected Shape createShape(Linkage link, Rectangle parent_bbox, Rectangle child_bbox) {
        LinkageStyle style = this.theLinkageStyleDictionary.getStyle(link);
        String edge_style = style.getShape();
        Point parent_center = Geometry.center(parent_bbox);
        Point child_center = Geometry.center(child_bbox);
        if (edge_style.equals("none")) {
            return null;
        }
        if (edge_style.equals("empty")) {
            return null;
        }
        if (edge_style.equals("line")) {
            return this.createLine(parent_center, child_center, link.hasMultipleBonds());
        }
        if (edge_style.equals("curve")) {
            return this.createCurve(parent_center, child_center, link.hasMultipleBonds());
        }
        return AbstractLinkageRenderer.createLine(parent_center, child_center);
    }

    private Shape createLine(Point p1, Point p2, boolean multiple) {
        if (multiple) {
            GeneralPath gp = new GeneralPath();
            double a = Geometry.angle(p1, p2);
            Shape line1 = this.createLine(Geometry.translate(p1, 2.0 * Math.cos(a + 1.5707963267948966), 2.0 * Math.sin(a + 1.5707963267948966)), Geometry.translate(p2, 2.0 * Math.cos(a + 1.5707963267948966), 2.0 * Math.sin(a + 1.5707963267948966)), false);
            gp.append(line1, false);
            Shape line2 = this.createLine(Geometry.translate(p1, 2.0 * Math.cos(a - 1.5707963267948966), 2.0 * Math.sin(a - 1.5707963267948966)), Geometry.translate(p2, 2.0 * Math.cos(a - 1.5707963267948966), 2.0 * Math.sin(a - 1.5707963267948966)), false);
            gp.append(line2, false);
            return gp;
        }
        return AbstractLinkageRenderer.createLine(p1, p2);
    }
}

